/*
 * Decompiled with CFR 0.152.
 */
package splar.core.fm;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import splar.core.constraints.BooleanVariableInterface;
import splar.core.constraints.CNFClause;
import splar.core.constraints.PropositionalFormula;
import splar.core.constraints.parsing.CNFClauseParseException;
import splar.core.constraints.parsing.CNFClauseParser;
import splar.core.fm.FeatureGroup;
import splar.core.fm.FeatureModel;
import splar.core.fm.FeatureModelException;
import splar.core.fm.FeatureTreeNode;
import splar.core.fm.GroupedFeature;
import splar.core.fm.RootNode;
import splar.core.fm.SolitaireFeature;
import splar.core.fm.TreeNodeRendererFactory;

public class XMLFeatureModel
extends FeatureModel {
    public static final int USE_VARIABLE_NAME_AS_ID = 10;
    public static final int SET_ID_AUTOMATICALLY = 20;
    private String fileName;
    private int idCounter;
    private int idCreationStrategy;

    public XMLFeatureModel(String fileName) {
        this(fileName, 20);
    }

    public XMLFeatureModel(String fileName, int idCreationStrategy) {
        this.fileName = fileName;
        this.idCreationStrategy = idCreationStrategy;
    }

    public int getIDCreationStrategy() {
        return this.idCreationStrategy;
    }

    @Override
    protected FeatureTreeNode createNodes() throws FeatureModelException {
        FeatureTreeNode rootNode = null;
        this.idCounter = 0;
        if (this.getRoot() != null) {
            rootNode = this.getRoot();
        } else {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(this.fileName);
                Element rootEle = doc.getDocumentElement();
                String featureModelName = rootEle.getAttribute("name");
                if (featureModelName == null || featureModelName.equals("")) {
                    throw new FeatureModelException("Missing mandatory feature model name.");
                }
                this.setName(featureModelName);
                NodeList metalist = rootEle.getElementsByTagName("meta");
                if (metalist.getLength() > 0) {
                    Element metaElement = (Element)metalist.item(0);
                    this.readMetaData(metaElement);
                }
                NodeList list = rootEle.getElementsByTagName("feature_tree");
                Element featureTreeEle = (Element)list.item(0);
                rootNode = this.parseFeatureTree(featureTreeEle.getTextContent());
                list = rootEle.getElementsByTagName("constraints");
                Element constraintsEle = (Element)list.item(0);
                String constraintsText = constraintsEle.getTextContent();
                this.parseConstraints(constraintsText);
            }
            catch (FeatureModelException e) {
                throw e;
            }
            catch (ParserConfigurationException pce) {
                throw new FeatureModelException("XML error parsing SXFM file: " + pce.getMessage(), pce);
            }
            catch (SAXException se) {
                throw new FeatureModelException("XML SAX error parsing SXFM file: " + se.getMessage(), se);
            }
            catch (IOException ioe) {
                throw new FeatureModelException("Error reading SXFM file: " + ioe.getMessage(), ioe);
            }
        }
        return rootNode;
    }

    protected void readMetaData(Element metaElement) {
        NodeList nodeList = metaElement.getElementsByTagName("data");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String name = element.getAttribute("name");
            String value = element.getTextContent();
            this.addMetaData(name, value);
        }
    }

    protected void parseConstraints(String constraints) throws FeatureModelException {
        CNFClauseParser cnfClauseParser = new CNFClauseParser();
        Scanner scanner = new Scanner(constraints);
        String line = "";
        while (scanner.hasNextLine()) {
            int index1;
            line = scanner.nextLine().trim();
            if (line.trim().length() <= 0 || (index1 = line.indexOf(":")) == -1) continue;
            String constraintName = line.substring(0, index1).trim();
            String constraintFormula = line.substring(index1 + 1).trim();
            try {
                CNFClause cnfClause = cnfClauseParser.parse(constraintFormula);
                for (BooleanVariableInterface var : cnfClause.getVariables()) {
                    if (this.getNodeByID(var.getID()) != null) continue;
                    throw new FeatureModelException("Error parsing extra constraint labelled '" + constraintName + "' (variable id '" + var.getID() + "' used in the formula is not defined in the feature tree).");
                }
                this.addConstraint(new PropositionalFormula(constraintName, cnfClause.toString2()));
            }
            catch (CNFClauseParseException e1) {
                throw new FeatureModelException("Error parsing extra constraint labelled '" + constraintName + "' (" + e1.getMessage() + "').", e1);
            }
            catch (FeatureModelException e2) {
                throw e2;
            }
            catch (Exception e3) {
                throw new FeatureModelException("Error parsing extra constraint labelled '" + constraintName + "' (Line: " + line + "').", e3);
            }
        }
    }

    protected FeatureTreeNode parseFeatureTree(String featureTree) throws IOException, FeatureModelException {
        FeatureTreeNode rootNode = null;
        Stack<FeatureTreeNode> nodeStack = new Stack<FeatureTreeNode>();
        LineNumberReader reader = new LineNumberReader(new StringReader(featureTree));
        String line = this.skipBlanks(reader);
        ArrayList<FeatureTreeNode> processedNodes = new ArrayList<FeatureTreeNode>();
        try {
            while (line != null) {
                FeatureTreeNode node = this.parseNode(line);
                while (processedNodes.contains(node)) {
                    node.setID("_" + node.getID());
                }
                processedNodes.add(node);
                int level = this.countTabs(line);
                if (rootNode == null && level == 0) {
                    rootNode = node;
                    nodeStack.push(node);
                } else {
                    int curLevel = nodeStack.size() - 1;
                    if (level > curLevel) {
                        FeatureTreeNode parent = (FeatureTreeNode)nodeStack.peek();
                        parent.add(node);
                        nodeStack.push(node);
                    } else if (level == curLevel) {
                        nodeStack.pop();
                        FeatureTreeNode parent = (FeatureTreeNode)nodeStack.peek();
                        parent.add(node);
                        nodeStack.push(node);
                    } else {
                        int countPops = curLevel - level + 1;
                        for (int i = 0; i < countPops; ++i) {
                            nodeStack.pop();
                        }
                        FeatureTreeNode parent = (FeatureTreeNode)nodeStack.peek();
                        parent.add(node);
                        nodeStack.push(node);
                    }
                }
                this.nodesMap.put(node.getID(), node);
                line = this.skipBlanks(reader);
            }
        }
        catch (FeatureModelException e1) {
            throw e1;
        }
        catch (Exception e2) {
            throw new FeatureModelException("Error parsing Feature Tree on line '" + line.trim() + "': " + e2.toString());
        }
        return rootNode;
    }

    private int countTabs(String line) {
        int count = 0;
        int index = line.indexOf(9);
        while (index != -1) {
            ++count;
            index = line.indexOf(9, index + 1);
        }
        return count;
    }

    private FeatureTreeNode parseNode(String line) throws FeatureModelException {
        FeatureTreeNode node = null;
        int index = line.indexOf(58);
        if (index != -1) {
            int findex1 = line.indexOf("(");
            int findex2 = line.indexOf(")");
            int findex3 = line.indexOf("[");
            String nodeType = line.substring(index + 1, index + 2).trim().toUpperCase();
            if (index == -1 || nodeType.length() > 0 && !nodeType.equals("R") && !nodeType.equals("O") && !nodeType.equals("M") && !nodeType.equals("G")) {
                throw new FeatureModelException("Error parsing Feature Tree on line '" + line.trim() + "' (invalid node type). Valid node types are :r (root), :m (mandatory), :o (optional), :g (group), and : (grouped)");
            }
            String featureName = "";
            String featureID = "";
            if (findex1 != -1) {
                featureID = line.substring(findex1 + 1, findex2);
                featureName = line.substring(index + 2, findex1).trim();
                if (featureName.length() == 0) {
                    featureName = featureID;
                }
            } else if (findex3 != -1) {
                featureName = line.substring(index + 2, findex3).trim();
                if (featureName.length() == 0) {
                    featureName = "_id_" + this.idCounter++;
                    featureID = featureName.replace(' ', '_');
                } else {
                    featureID = this.idCreationStrategy == 10 ? featureName.replace(' ', '_') : "_id_" + this.idCounter++;
                }
            } else {
                featureName = line.substring(index + 2).trim();
                if (featureName.length() == 0) {
                    featureName = "_id_" + this.idCounter++;
                    featureID = featureName.replace(' ', '_');
                } else {
                    featureID = this.idCreationStrategy == 10 ? featureName.replace(' ', '_') : "_id_" + this.idCounter++;
                }
            }
            if (nodeType.compareToIgnoreCase("R") == 0) {
                node = new RootNode(featureID, featureName, TreeNodeRendererFactory.createRootRenderer());
            } else if (nodeType.compareToIgnoreCase("M") == 0) {
                node = new SolitaireFeature(false, featureID, featureName, TreeNodeRendererFactory.createMandatoryRenderer());
            } else if (nodeType.compareToIgnoreCase("O") == 0) {
                node = new SolitaireFeature(true, featureID, featureName, TreeNodeRendererFactory.createOptionalRenderer());
            } else if (nodeType.compareToIgnoreCase("G") == 0) {
                int index1 = line.indexOf(91, index);
                int index2 = line.indexOf(44, index1);
                int index3 = line.indexOf(93, index2);
                int min = 1;
                int max = -1;
                try {
                    min = Integer.parseInt(line.substring(index1 + 1, index2).trim());
                }
                catch (NumberFormatException ex) {
                    throw new FeatureModelException("Error parsing Feature Tree on line '" + line.trim() + "' (invalid cardinality lower bound value). It must be a valid integer.");
                }
                try {
                    String upperBound = line.substring(index2 + 1, index3).trim();
                    max = upperBound.equals("*") ? -1 : Integer.parseInt(upperBound);
                }
                catch (NumberFormatException ex) {
                    throw new FeatureModelException("Error parsing Feature Tree on line '" + line.trim() + "' (invalid cardinality upper bound value). It must be a valid integer.");
                }
                node = new FeatureGroup(featureID, featureName, min, max, TreeNodeRendererFactory.createFeatureGroupRenderer());
            } else {
                node = new GroupedFeature(featureID, featureName, TreeNodeRendererFactory.createGroupedRenderer());
            }
        }
        return node;
    }

    private String skipBlanks(LineNumberReader reader) throws IOException {
        String line = reader.readLine();
        while (line != null && line.length() == 0) {
            line = reader.readLine();
        }
        return line;
    }

    @Override
    protected void saveNodes() {
    }
}

