/*
 * Decompiled with CFR 0.152.
 */
package splar.core.fm.randomization;

import java.util.List;
import java.util.Random;
import java.util.Vector;
import splar.core.constraints.PropositionalFormula;
import splar.core.fm.FeatureGroup;
import splar.core.fm.FeatureModel;
import splar.core.fm.FeatureModelException;
import splar.core.fm.FeatureTreeNode;
import splar.core.fm.GroupedFeature;
import splar.core.fm.RootNode;
import splar.core.fm.SolitaireFeature;
import splar.core.fm.TreeNodeRendererFactory;
import splar.core.fm.randomization._LevelConstraintGenerator;

public class RandomFeatureModel
extends FeatureModel {
    private int numberOfFeaturesToCreate;
    private int maxChildrenPerNode;
    private int minChildrenPerNode;
    private int mandatoryOdds;
    private int optionalOdds;
    private int group1NOdds;
    private int group11Odds;
    private int maxGroupCardinality;
    private int balanceFactor;

    public RandomFeatureModel(String name, int numberOfFeaturesToCreate, int mandatoryOdds, int optionalOdds, int group1NOdds, int group11Odds, int minChildrenPerNode, int maxChildrenPerNode, int maxGroupCardinality, int balanceFactor) {
        this.setName(name);
        this.numberOfFeaturesToCreate = numberOfFeaturesToCreate;
        this.maxChildrenPerNode = maxChildrenPerNode;
        this.minChildrenPerNode = minChildrenPerNode;
        this.mandatoryOdds = mandatoryOdds;
        this.optionalOdds = optionalOdds;
        this.group1NOdds = group1NOdds;
        this.group11Odds = group11Odds;
        this.maxGroupCardinality = maxGroupCardinality;
        this.balanceFactor = balanceFactor;
    }

    @Override
    protected FeatureTreeNode createNodes() throws FeatureModelException {
        int countFeatures = 1;
        Vector<FeatureTreeNode> fmNodes = new Vector<FeatureTreeNode>();
        String featureName = "R";
        ++countFeatures;
        RootNode root = new RootNode(featureName, featureName, TreeNodeRendererFactory.createRootRenderer());
        fmNodes.add(root);
        FeatureTreeNode parentNode = null;
        while (countFeatures <= this.numberOfFeaturesToCreate) {
            parentNode = (FeatureTreeNode)fmNodes.firstElement();
            fmNodes.removeElement(parentNode);
            int numberOfChildNodesToCreate = Math.min(this.numberOfFeaturesToCreate - countFeatures + 1, Math.abs(new Random().nextInt()) % (this.maxChildrenPerNode - this.minChildrenPerNode + 1) + this.minChildrenPerNode);
            if (parentNode.getParent() == null) {
                numberOfChildNodesToCreate = this.maxChildrenPerNode;
            } else if (this.isRoot((FeatureTreeNode)parentNode.getParent())) {
                numberOfChildNodesToCreate = this.maxChildrenPerNode;
            }
            if (numberOfChildNodesToCreate == 0 && fmNodes.size() == 0) {
                numberOfChildNodesToCreate = 1;
            }
            if (numberOfChildNodesToCreate <= 0) continue;
            for (int i = 0; i < numberOfChildNodesToCreate && countFeatures <= this.numberOfFeaturesToCreate; ++i) {
                String childFeatureName = parentNode.getID().substring(1) + (i + 1);
                FeatureTreeNode randomNode = this.createRandomNode(childFeatureName, this.randonlyChooseNodeTypeToCreate());
                parentNode.add(randomNode);
                if (randomNode instanceof FeatureGroup) {
                    FeatureGroup groupRandomNode = (FeatureGroup)randomNode;
                    int countGroupedNodes = groupRandomNode.getChildCount();
                    if (Math.abs(new Random().nextInt()) % 100 > this.balanceFactor || fmNodes.size() == 0) {
                        for (int j = 0; j < countGroupedNodes; ++j) {
                            fmNodes.add((FeatureTreeNode)groupRandomNode.getChildAt(j));
                        }
                    }
                    countFeatures += countGroupedNodes;
                    continue;
                }
                if (Math.abs(new Random().nextInt()) % 100 > this.balanceFactor || fmNodes.size() == 0) {
                    fmNodes.add(randomNode);
                }
                ++countFeatures;
            }
        }
        return root;
    }

    private String randonlyChooseNodeTypeToCreate() {
        int randomIndex = Math.abs(new Random().nextInt()) % (this.mandatoryOdds + this.optionalOdds + this.group1NOdds + this.group11Odds);
        if (randomIndex < this.mandatoryOdds) {
            return "mandatory";
        }
        if (randomIndex < this.mandatoryOdds + this.optionalOdds) {
            return "optional";
        }
        if (randomIndex < this.mandatoryOdds + this.optionalOdds + this.group1NOdds) {
            return "group1N";
        }
        return "group11";
    }

    private FeatureTreeNode createRandomNode(String childFeatureName, String nodeType) {
        FeatureTreeNode node;
        block5: {
            String featureName;
            block7: {
                block6: {
                    block4: {
                        node = null;
                        featureName = "";
                        if (nodeType.compareToIgnoreCase("optional") != 0) break block4;
                        featureName = "o" + childFeatureName;
                        node = new SolitaireFeature(true, featureName, featureName, TreeNodeRendererFactory.createOptionalRenderer());
                        break block5;
                    }
                    if (nodeType.compareToIgnoreCase("mandatory") != 0) break block6;
                    featureName = "m" + childFeatureName;
                    node = new SolitaireFeature(false, featureName, featureName, TreeNodeRendererFactory.createOptionalRenderer());
                    break block5;
                }
                if (nodeType.compareToIgnoreCase("group1N") != 0) break block7;
                int groupSize = Math.abs(new Random().nextInt()) % this.maxGroupCardinality + 1;
                if (groupSize <= 1) {
                    groupSize = 2;
                }
                int lower = 1;
                int upper = -1;
                String groupName = "_Gi_" + childFeatureName;
                node = new FeatureGroup(groupName, groupName, lower, upper, TreeNodeRendererFactory.createFeatureGroupRenderer());
                for (int i = 0; i < groupSize; ++i) {
                    featureName = "g" + childFeatureName + (i + 1);
                    node.add(new GroupedFeature(featureName, featureName, TreeNodeRendererFactory.createGroupedRenderer()));
                }
                break block5;
            }
            if (nodeType.compareToIgnoreCase("group11") != 0) break block5;
            int groupSize = Math.abs(new Random().nextInt()) % this.maxGroupCardinality + 1;
            if (groupSize <= 1) {
                groupSize = 2;
            }
            int lower = 1;
            int upper = 1;
            String groupName = "_Ge_" + childFeatureName;
            node = new FeatureGroup(groupName, groupName, lower, upper, TreeNodeRendererFactory.createFeatureGroupRenderer());
            for (int i = 0; i < groupSize; ++i) {
                featureName = "g" + childFeatureName + (i + 1);
                node.add(new GroupedFeature(featureName, featureName, TreeNodeRendererFactory.createGroupedRenderer()));
            }
        }
        return node;
    }

    public int createExtraConstraints(int numVars, int numConstraints, int maxArity, int[][] modularityParameters) {
        return RandomFeatureModel.createExtraConstraints(this, numVars, numConstraints, maxArity, modularityParameters);
    }

    public static int createExtraConstraints(FeatureModel fm, int numVars, int numConstraints, int maxArity, int[][] modularityParameters) {
        int levelsToConsider = modularityParameters.length;
        int depth = fm.depth() - 1;
        levelsToConsider = levelsToConsider > depth ? depth : levelsToConsider;
        for (int i = 0; i < levelsToConsider; ++i) {
            modularityParameters[i][0] = Math.round((float)modularityParameters[i][0] / 100.0f * (float)depth);
            modularityParameters[i][1] = Math.round((float)modularityParameters[i][1] / 100.0f * (float)numVars);
        }
        fm.resetNodesAttachedData();
        int countLevelsWithContraints = 0;
        for (int i = levelsToConsider - 1; i >= 0; --i) {
            if (modularityParameters[i][1] < 2) continue;
            int numConstraintsLevel = Math.round(numConstraints * modularityParameters[i][1] / numVars);
            _LevelConstraintGenerator constraintGenerator = new _LevelConstraintGenerator(fm, modularityParameters[i][0], modularityParameters[i][1], numConstraintsLevel, maxArity, modularityParameters[i][2]);
            List<PropositionalFormula> levelFormulas = constraintGenerator.createExtraConstraints();
            countLevelsWithContraints = levelFormulas.size() > 0 ? countLevelsWithContraints + 1 : countLevelsWithContraints;
            for (PropositionalFormula formula : levelFormulas) {
                fm.addConstraint(formula);
            }
        }
        return countLevelsWithContraints;
    }

    @Override
    public void saveNodes() {
    }
}

