/*
 * Decompiled with CFR 0.152.
 */
package splar.core.heuristics;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Stack;
import splar.core.constraints.BooleanVariableInterface;
import splar.core.constraints.CNFClause;
import splar.core.constraints.CNFFormula;
import splar.core.constraints.PropositionalFormula;
import splar.core.fm.FeatureGroup;
import splar.core.fm.FeatureModel;
import splar.core.fm.FeatureTreeNode;
import splar.core.heuristics.FTTraversalHeuristic;

public class ECFT_PreOrderHeuristic
extends FTTraversalHeuristic {
    public ECFT_PreOrderHeuristic(String name, FeatureModel featureModel) {
        super(name, featureModel);
    }

    @Override
    public String[] runHeuristic(CNFFormula cnf) {
        LinkedHashSet<String> variables = new LinkedHashSet<String>();
        for (PropositionalFormula formula : this.featureModel.getConstraints()) {
            for (CNFClause clause : formula.toCNFClauses()) {
                for (BooleanVariableInterface var : clause.getVariables()) {
                    if (variables.contains(var.getID())) continue;
                    variables.add(var.getID());
                }
            }
        }
        Set<BooleanVariableInterface> cnfVariables = cnf.getVariables();
        Stack<FeatureTreeNode> nodes = new Stack<FeatureTreeNode>();
        nodes.push(this.getFeatureModel().getRoot());
        while (nodes.size() > 0) {
            FeatureTreeNode curNode = (FeatureTreeNode)nodes.pop();
            if (curNode == null) continue;
            if (!(curNode instanceof FeatureGroup) && cnfVariables.contains(curNode) && !variables.contains(curNode.getID())) {
                variables.add(curNode.getID());
            }
            FeatureTreeNode[] childNodes = this.orderChildNodes(curNode);
            for (int i = childNodes.length - 1; i >= 0; --i) {
                nodes.push(childNodes[i]);
            }
        }
        return variables.toArray(new String[0]);
    }

    protected FeatureTreeNode[] orderChildNodes(FeatureTreeNode node) {
        int count = node.getChildCount();
        FeatureTreeNode[] nodes = new FeatureTreeNode[count];
        for (int i = 0; i < count; ++i) {
            nodes[i] = (FeatureTreeNode)node.getChildAt(i);
        }
        return nodes;
    }
}

