/*
 * Decompiled with CFR 0.152.
 */
package splar.core.heuristics;

import java.util.ArrayList;
import splar.core.constraints.CNFFormula;
import splar.core.fm.FeatureTreeNode;
import splar.core.fm.clustering.FeatureModelClustersManager;
import splar.core.fm.clustering.NodeCluster;
import splar.core.heuristics.FTPreOrderTraversalHeuristic;

public class FTPreOrderClustersTraversalHeuristic
extends FTPreOrderTraversalHeuristic {
    public static final int SIZE_SORT = 10;
    public static final int FORCE_SORT = 20;
    private int sortType = 10;
    private FeatureModelClustersManager clustersManager;

    public FTPreOrderClustersTraversalHeuristic(String name, FeatureModelClustersManager clustersManager, int sortType) {
        super(name, clustersManager.getFeatureModel());
        this.sortType = sortType;
        this.clustersManager = clustersManager;
    }

    @Override
    protected FeatureTreeNode[] orderChildNodes(FeatureTreeNode node) {
        ArrayList<FeatureTreeNode> orderedNodes = new ArrayList<FeatureTreeNode>();
        for (NodeCluster cluster : this.clustersManager.sortClusterAscendingOrder(node)) {
            FeatureTreeNode[] nodes = null;
            if (this.sortType == 10 || cluster.countNodes() <= 2) {
                nodes = cluster.sortedNodes();
            } else if (this.sortType == 20) {
                nodes = cluster.sortedNodesbyFORCE();
            }
            for (FeatureTreeNode sortedNode : nodes) {
                orderedNodes.add(sortedNode);
            }
        }
        return orderedNodes.toArray(new FeatureTreeNode[0]);
    }

    @Override
    protected void runPreProcessing(CNFFormula cnf) {
        if (!this.clustersManager.clustersReady()) {
            this.clustersManager.createClusters();
        }
    }
}

