/*
 * Decompiled with CFR 0.152.
 */
package splar.core.heuristics;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import splar.core.constraints.BooleanVariable;
import splar.core.constraints.BooleanVariableInterface;
import splar.core.constraints.CNFFormula;
import splar.core.heuristics.VariableOrderingHeuristicsManager;

public abstract class VariableOrderingHeuristic {
    protected String name;
    protected Map<String, Object> parameters;
    protected String[] lastVo;
    protected double lastRunningTime;

    public VariableOrderingHeuristic(String name) {
        this.name = name;
        this.parameters = new LinkedHashMap<String, Object>();
        this.lastVo = null;
        this.lastRunningTime = -1.0;
        this.registerToHeuristicManager();
    }

    protected void registerToHeuristicManager() {
        VariableOrderingHeuristicsManager.createHeuristicsManager().registerHeuristic(this.name, this);
    }

    public String getName() {
        return this.name;
    }

    public String[] getVariableOrdering() {
        return this.lastVo;
    }

    public double getRunningTime() {
        return this.lastRunningTime;
    }

    public void setParameter(String name, Object value) {
        this.parameters.put(name, value);
    }

    public void clearParameters() {
        this.parameters.clear();
    }

    public static Map<String, Integer> variableOrderingAsHashMap(String[] vo) {
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        for (int i = 0; i < vo.length; ++i) {
            map.put(vo[i], new Integer(i));
        }
        return map;
    }

    public static String variableOrderingAsCommaSepString(String[] vo) {
        String voStr = "";
        for (int i = 0; i < vo.length; ++i) {
            voStr = voStr + vo[i];
            if (i >= vo.length - 1) continue;
            voStr = voStr + ",";
        }
        return voStr;
    }

    public static Map<String, Integer> variableOrderingAsHashMap(BooleanVariableInterface[] vo) {
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        for (int i = 0; i < vo.length; ++i) {
            map.put(vo[i].getID(), new Integer(i));
        }
        return map;
    }

    public static BooleanVariableInterface[] variableOrderingAsBooleanVariableArray(String[] vo) {
        Vector<BooleanVariable> varOrderList = new Vector<BooleanVariable>();
        if (vo != null) {
            for (int i = 0; i < vo.length; ++i) {
                varOrderList.add(new BooleanVariable(vo[i]));
            }
        }
        return varOrderList.toArray(new BooleanVariableInterface[0]);
    }

    public static BooleanVariableInterface[] variableOrderingAsBooleanVariableArray(String commaSepString) {
        Vector<BooleanVariable> varOrderList = new Vector<BooleanVariable>();
        String[] result = commaSepString.split(",");
        for (int i = 0; i < result.length; ++i) {
            varOrderList.add(new BooleanVariable(result[i].trim()));
        }
        return varOrderList.toArray(new BooleanVariableInterface[0]);
    }

    public static String[] variableOrderingAsStringVariableArray(BooleanVariableInterface[] vo) {
        String[] varOrder = null;
        int countVars = vo.length;
        if (vo != null) {
            varOrder = new String[countVars];
            for (int i = 0; i < countVars; ++i) {
                varOrder[i] = vo[i].getID();
            }
        }
        return varOrder;
    }

    public String[] run(CNFFormula cnf) {
        long start = System.nanoTime();
        this.runPreProcessing(cnf);
        this.lastVo = this.runHeuristic(cnf);
        this.runPostProcessing(cnf);
        this.lastRunningTime = (double)(System.nanoTime() - start) / 1000000.0;
        return this.lastVo;
    }

    protected void runPreProcessing(CNFFormula cnf) {
    }

    protected void runPostProcessing(CNFFormula cnf) {
    }

    protected abstract String[] runHeuristic(CNFFormula var1);
}

