/*
 * Decompiled with CFR 0.152.
 */
package splar.plugins.reasoners.sat.sat4j;

import org.sat4j.core.VecInt;
import org.sat4j.specs.ISolver;
import splar.core.constraints.CNFClause;
import splar.core.constraints.CNFLiteral;
import splar.core.constraints.PropositionalFormula;
import splar.core.fm.FeatureModel;
import splar.plugins.reasoners.sat.sat4j.FTReasoningWithSAT;

public class FMReasoningWithSAT
extends FTReasoningWithSAT {
    public FMReasoningWithSAT(String solverName, FeatureModel featureModel, int timeout) {
        super(solverName, featureModel, timeout);
    }

    @Override
    protected void addSolverClauses(ISolver solver) throws Exception {
        super.addSolverClauses(solver);
        for (PropositionalFormula formula : this.featureModel.getConstraints()) {
            for (CNFClause clause : formula.toCNFClauses()) {
                VecInt vectInt = new VecInt(clause.countLiterals());
                for (CNFLiteral literal : clause.getLiterals()) {
                    int signal = literal.isPositive() ? 1 : -1;
                    int varID = this.getVariableIndex(literal.getVariable().getID());
                    vectInt.push(signal * varID);
                }
                solver.addClause(vectInt);
            }
        }
    }
}

