/*
 * Decompiled with CFR 0.152.
 */
package splar.plugins.reasoners.sat.sat4j;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.sat4j.core.LiteralsUtils;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.core.Solver;
import org.sat4j.specs.ISolver;
import splar.core.fm.FTTraversalNodeSelector;
import splar.core.fm.FTTraversals;
import splar.core.fm.FeatureGroup;
import splar.core.fm.FeatureModel;
import splar.core.fm.FeatureTreeNode;
import splar.core.fm.SolitaireFeature;
import splar.plugins.reasoners.sat.sat4j.ReasoningWithSAT;
import splar.plugins.reasoners.sat.sat4j.StaticVariableOrderSAT;

public class FTReasoningWithSAT
extends ReasoningWithSAT {
    protected FeatureModel featureModel;
    private String[] satVarOrder = null;
    private StaticVariableOrderSAT satOrderObj = null;

    public FTReasoningWithSAT(String solverName, FeatureModel featureModel, int timeout) {
        super(solverName, timeout);
        this.featureModel = featureModel;
    }

    public FeatureModel getFeatureModel() {
        return this.featureModel;
    }

    protected void updateVariableMappings() {
        this.varIndex2NameMap = new String[this.featureModel.countNodes()];
        for (FeatureTreeNode node : this.featureModel.getNodes()) {
            if (node instanceof FeatureGroup) continue;
            String varName = node.getID();
            Integer index = (Integer)node.getAttachedData();
            this.varName2IndexMap.put(varName, index);
            this.varIndex2NameMap[index.intValue() - 1] = varName;
        }
    }

    @Override
    protected void addSolverClauses(ISolver solver) throws Exception {
        this.featureModel.resetNodesAttachedData();
        solver.newVar(this.featureModel.countNodes());
        int countFeatures = 1;
        VecInt vectInt = new VecInt(1);
        vectInt.push(countFeatures);
        solver.addClause(vectInt);
        FeatureTreeNode rootNode = this.featureModel.getRoot();
        rootNode.attachData(new Integer(countFeatures));
        Vector<FeatureTreeNode> nodes = new Vector<FeatureTreeNode>();
        nodes.add(rootNode);
        while (nodes.size() > 0) {
            FeatureTreeNode curNode = (FeatureTreeNode)nodes.firstElement();
            nodes.remove(curNode);
            if (curNode == null) continue;
            int parentVarID = 0;
            int count = curNode.getChildCount();
            if (count <= 0) continue;
            block1: for (int i = 0; i < count; ++i) {
                FeatureTreeNode childNode = (FeatureTreeNode)curNode.getChildAt(i);
                int childVarID = 0;
                if (childNode instanceof SolitaireFeature) {
                    parentVarID = (Integer)curNode.getAttachedData();
                    childVarID = ++countFeatures;
                    childNode.attachData(childVarID);
                    nodes.add(childNode);
                    SolitaireFeature solitaireNode = (SolitaireFeature)childNode;
                    vectInt = new VecInt(2);
                    vectInt.push(parentVarID);
                    vectInt.push(-childVarID);
                    solver.addClause(vectInt);
                    if (solitaireNode.isOptional()) continue;
                    vectInt = new VecInt(2);
                    vectInt.push(-parentVarID);
                    vectInt.push(childVarID);
                    solver.addClause(vectInt);
                    continue;
                }
                if (!(childNode instanceof FeatureGroup)) continue;
                FeatureGroup fgNode = (FeatureGroup)childNode;
                parentVarID = (Integer)((FeatureTreeNode)fgNode.getParent()).getAttachedData();
                int countGroupedNodes = fgNode.getChildCount();
                vectInt = new VecInt(countGroupedNodes + 1);
                vectInt.push(-parentVarID);
                for (int j = 0; j < countGroupedNodes; ++j) {
                    FeatureTreeNode groupedNode = (FeatureTreeNode)fgNode.getChildAt(j);
                    childVarID = ++countFeatures;
                    groupedNode.attachData(childVarID);
                    nodes.add(groupedNode);
                    vectInt.push(childVarID);
                    VecInt vectIntGrpOR = new VecInt(2);
                    vectIntGrpOR.push(parentVarID);
                    vectIntGrpOR.push(-childVarID);
                    solver.addClause(vectIntGrpOR);
                }
                solver.addClause(vectInt);
                int min = fgNode.getMin();
                int max = fgNode.getMax();
                int n = max = max == -1 ? countGroupedNodes : max;
                if (min == 1 && max == 1) {
                    ArrayList<List<Integer>> combinations = new ArrayList<List<Integer>>();
                    FTReasoningWithSAT.computeCombinations(combinations, countGroupedNodes, 2);
                    for (List list : combinations) {
                        VecInt vectIntGrpXOR = new VecInt(2);
                        for (Integer index : list) {
                            vectIntGrpXOR.push(-(countFeatures - countGroupedNodes + 1 + index));
                        }
                        solver.addClause(vectIntGrpXOR);
                    }
                    continue;
                }
                if (min <= 1 && max >= countGroupedNodes) continue;
                int startIndex = 0;
                int endIndex = min - 1;
                ArrayList<List<Integer>> combinations = new ArrayList<List<Integer>>();
                while (true) {
                    for (int j = startIndex; j < endIndex; ++j) {
                        FTReasoningWithSAT.computeCombinations(combinations, countGroupedNodes, j + 1);
                        for (List list : combinations) {
                            VecInt vectIntGrp = new VecInt(countGroupedNodes);
                            for (Integer index : list) {
                                vectIntGrp.push(-(countFeatures - countGroupedNodes + 1 + index));
                            }
                            for (int posIndex = 0; posIndex < countGroupedNodes; ++posIndex) {
                                if (list.contains(posIndex)) continue;
                                vectIntGrp.push(countFeatures - countGroupedNodes + 1 + posIndex);
                            }
                            solver.addClause(vectIntGrp);
                        }
                    }
                    if (endIndex == countGroupedNodes) continue block1;
                    startIndex = max;
                    endIndex = countGroupedNodes;
                }
            }
        }
        this.updateVariableMappings();
        for (FeatureTreeNode node : this.featureModel.getInstantiatedNodes()) {
            if (node instanceof FeatureGroup) continue;
            VecInt vInt = new VecInt(1);
            int index = this.getVariableIndex(node.getID());
            vInt.push(node.getValue() == 1 ? index : -index);
            solver.addClause(vInt);
        }
    }

    public static List<List<Integer>> computeCombinations(List<List<Integer>> combinations, int n, int p) {
        combinations.clear();
        FTReasoningWithSAT.groupCombination(combinations, null, 0, 0, n, p);
        return combinations;
    }

    public static void groupCombination(List<List<Integer>> combinations, ArrayList<Integer> index, int level, int start, int n, int p) {
        if (level == 0 && index == null) {
            index = new ArrayList(p);
        }
        if (level == p) {
            ArrayList<Integer> theIndex = new ArrayList<Integer>();
            theIndex.addAll(index);
            combinations.add(theIndex);
        } else {
            for (int i = start; i < n; ++i) {
                index.add(level, i);
                FTReasoningWithSAT.groupCombination(combinations, index, level + 1, i + 1, n, p);
                index.remove(level);
            }
        }
    }

    @Override
    public byte[][] computeValidDomains(int[] testValues, boolean[] optimizations, Map<String, String> stats) {
        byte[][] domainTable = null;
        try {
            domainTable = new byte[this.featureModel.countFeatures()][2];
            for (int i = 0; i < domainTable.length; ++i) {
                FeatureTreeNode node = this.featureModel.getNodeByID(this.getVariableName(i + 1));
                if (node.isInstantiated()) {
                    domainTable[i][node.getValue()] = 2;
                    domainTable[i][1 - node.getValue()] = 3;
                    continue;
                }
                domainTable[i][0] = 1;
                domainTable[i][1] = 1;
            }
            int satChecks = 0;
            long processingTime = System.currentTimeMillis();
            int varOrderIndex = 0;
            List<FeatureTreeNode> processingVarOrder = this.getVariableProcessingOrder(domainTable);
            int opt3NumVariablesEliminated = 0;
            for (FeatureTreeNode uninstantiatedNode : processingVarOrder) {
                Solver solver = (Solver)this.getSolver();
                int varIndex = this.getVariableIndex(uninstantiatedNode.getID());
                for (Integer value : this.getValueProcessingOrder(domainTable, varIndex, testValues)) {
                    this.setVariableAndValueOrderForSAT(domainTable, varIndex, testValues, optimizations);
                    try {
                        solver.assume(value == 1 ? LiteralsUtils.posLit(varIndex) : LiteralsUtils.negLit(varIndex));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ++satChecks;
                    boolean isSAT = solver.isSatisfiable();
                    int[] solution = null;
                    if (isSAT) {
                        solution = this.satSolver.model();
                    }
                    if (isSAT && (solution[this.getVariableIndex(uninstantiatedNode.getID()) - 1] < 0 && value == 0 || solution[this.getVariableIndex(uninstantiatedNode.getID()) - 1] > 0 && value == 1)) {
                        domainTable[varIndex - 1][value.intValue()] = 2;
                        if (!optimizations[0]) continue;
                        for (int j = varOrderIndex + 1; j < processingVarOrder.size(); ++j) {
                            int tempIndex = this.getVariableIndex(processingVarOrder.get(j).getID());
                            domainTable[tempIndex - 1][solution[tempIndex - 1] < 0 ? 0 : 1] = 2;
                        }
                        continue;
                    }
                    domainTable[varIndex - 1][value.intValue()] = 3;
                    domainTable[varIndex - 1][1 - value.intValue()] = 2;
                    if (optimizations[1]) {
                        VecInt tempVecInt = new VecInt(1);
                        tempVecInt.push(value == 0 ? varIndex : -varIndex);
                        this.satSolver.addClause(tempVecInt);
                    }
                    if (!optimizations[2]) break;
                    LinkedList propNodes = new LinkedList();
                    if (value == 1) {
                        this.featureModel.getSubtreeNodes(this.featureModel.getNodeByID(uninstantiatedNode.getID()), propNodes);
                    }
                    for (FeatureTreeNode propNode : propNodes) {
                        int propVarIndex = this.getVariableIndex(propNode.getID());
                        if (domainTable[propVarIndex - 1][value] != 1) continue;
                        domainTable[propVarIndex - 1][value.intValue()] = 3;
                        domainTable[propVarIndex - 1][1 - value.intValue()] = 2;
                        VecInt tempVecInt = new VecInt(1);
                        tempVecInt.push(value == 0 ? propVarIndex : -propVarIndex);
                        this.satSolver.addClause(tempVecInt);
                        ++opt3NumVariablesEliminated;
                    }
                    break;
                }
                ++varOrderIndex;
            }
            processingTime = System.currentTimeMillis() - processingTime;
            stats.put("sat-checks", String.valueOf(satChecks));
            stats.put("processing-time", String.valueOf(processingTime));
            stats.put("opt3-eliminated-vars", String.valueOf(opt3NumVariablesEliminated));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return domainTable;
    }

    public void dumpDomainTable(byte[][] table, boolean isFinal) {
        int i = 0;
        System.out.println("-----------------------");
        for (byte[] entry : table) {
            int j = 0;
            if (isFinal) {
                if (entry[0] == 2 && entry[1] == 2) {
                    System.out.println("      FREE  : " + this.getVariableName(i + 1) + ": {true, false}");
                } else if (entry[1] == 3) {
                    System.out.println(">>>>> DEAD  : " + this.getVariableName(i + 1) + ": {false}");
                } else if (entry[0] == 3) {
                    System.out.println(">>>>> COMMON: " + this.getVariableName(i + 1) + ": {true}");
                } else {
                    System.out.println("      PARTIAL  : " + this.getVariableName(i + 1) + ": {" + (entry[0] == 2 ? "false, " : (entry[0] == 3 ? "" : "?, ")) + (entry[1] == 2 ? "true" : (entry[0] == 3 ? "" : "?")) + "}");
                }
            } else {
                System.out.print("      " + this.getVariableName(i + 1) + ": {");
                for (byte value : entry) {
                    if (value == 2) {
                        System.out.print((j == 1) + ",");
                    } else if (value == 1) {
                        System.out.print("?,");
                    }
                    ++j;
                }
                System.out.print("}\r\n");
            }
            ++i;
        }
        System.out.println("-----------------------");
    }

    protected List<FeatureTreeNode> getVariableProcessingOrder(final byte[][] domainTable) {
        FTTraversalNodeSelector selector = new FTTraversalNodeSelector(){

            @Override
            public boolean select(FeatureTreeNode node) {
                if (node instanceof FeatureGroup) {
                    return false;
                }
                int varIndex = FTReasoningWithSAT.this.getVariableIndex(node.getID()) - 1;
                return domainTable[varIndex][0] == 1 && domainTable[varIndex][1] == 1;
            }
        };
        List<FeatureTreeNode> order = FTTraversals.dfs(this.featureModel.getRoot(), selector);
        return order;
    }

    protected List<Integer> getValueProcessingOrder(byte[][] domainTable, int varIndex, int[] testValues) {
        ArrayList<Integer> order = new ArrayList<Integer>();
        for (int value : testValues) {
            if (domainTable[varIndex - 1][value] != 1) continue;
            order.add(value);
        }
        return order;
    }

    protected void setVariableAndValueOrderForSAT(byte[][] domainTable, int varIndex, int[] testValues, boolean[] optimizations) {
        if (optimizations[3]) {
            if (this.satVarOrder == null) {
                this.satVarOrder = new String[domainTable.length];
                FTTraversalNodeSelector selector = new FTTraversalNodeSelector(){

                    @Override
                    public boolean select(FeatureTreeNode node) {
                        return !(node instanceof FeatureGroup);
                    }
                };
                int index = 0;
                for (FeatureTreeNode node : FTTraversals.dfs(this.featureModel.getRoot(), selector)) {
                    this.satVarOrder[index++] = node.getID();
                }
                this.satOrderObj = new StaticVariableOrderSAT(this.satVarOrder, false, this.varName2IndexMap, this.varIndex2NameMap);
            }
            int[] valueOrder = new int[this.satVarOrder.length];
            for (int i = 0; i < valueOrder.length; ++i) {
                valueOrder[i] = testValues.length == 1 ? testValues[0] : (domainTable[this.getVariableIndex(this.satVarOrder[i]) - 1][0] == 1 ? 0 : 1);
            }
            this.satOrderObj.setValueOrder(valueOrder);
            this.setVariableOrderObject(this.satOrderObj);
        }
    }
}

