/*
 * Decompiled with CFR 0.152.
 */
package splar.plugins.reasoners.sat.sat4j;

import java.util.Map;
import java.util.Random;
import org.sat4j.core.LiteralsUtils;
import org.sat4j.minisat.core.ILits2;
import org.sat4j.minisat.orders.VarOrder;

public class StaticVariableOrderSAT
extends VarOrder<ILits2> {
    private static final long serialVersionUID = 1L;
    private String[] varOrder;
    private Map<String, Integer> varName2IndexMap;
    private String[] varIndex2NameMap;
    private Boolean phase = false;
    private int[] valueOrder = null;

    public StaticVariableOrderSAT(String[] varOrder, Boolean phase, Map<String, Integer> varName2IndexMap, String[] varIndex2NameMap) {
        this.varOrder = varOrder;
        this.varName2IndexMap = varName2IndexMap;
        this.varIndex2NameMap = varIndex2NameMap;
        this.phase = phase;
        this.valueOrder = null;
    }

    public void setPhase(boolean phase) {
        this.phase = phase;
    }

    public void setValueOrder(int[] valueOrder) {
        if (this.valueOrder == null) {
            this.valueOrder = new int[valueOrder.length];
        }
        System.arraycopy(valueOrder, 0, this.valueOrder, 0, valueOrder.length);
    }

    @Override
    public void init() {
        super.init();
        if (this.valueOrder == null) {
            Random random = new Random();
            for (int i = 0; i < this.varOrder.length; ++i) {
                int varIndex = this.varName2IndexMap.get(this.varOrder[i]);
                this.order[i + 1] = this.phase == null ? (random.nextBoolean() ? LiteralsUtils.posLit(varIndex) : LiteralsUtils.negLit(varIndex)) : (this.phase != false ? LiteralsUtils.posLit(varIndex) : LiteralsUtils.negLit(varIndex));
                this.varpos[varIndex] = i + 1;
            }
        } else {
            for (int i = 0; i < this.valueOrder.length; ++i) {
                int varIndex = this.varName2IndexMap.get(this.varOrder[i]);
                this.order[i + 1] = this.valueOrder[i] == 1 ? LiteralsUtils.posLit(varIndex) : LiteralsUtils.negLit(varIndex);
                this.varpos[varIndex] = i + 1;
            }
        }
        this.lastVar = 1;
    }

    @Override
    public String toString() {
        return "Init VSIDS order with binary clause occurrences.";
    }
}

