/*
 * Author : Christopher Henard (christopher.henard@uni.lu)
 * Date : 21/05/2012
 * Copyright 2012 University of Luxembourg – Interdisciplinary Centre for Security Reliability and Trust (SnT)
 * All rights reserved
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package spl.fm;

/**
 * This class represents a pair of features. Features are represented by a 
 * couple of integers, positive if the feature is selected, negative otherwise.
 * The integer value cannot be 0.
 *
 * If we consider the pair (1, 2), then (2, 1) denotes the same pair of features.
 * 
 * @author Christopher Henard
 */
public class FeaturesPair {

    private int x, y;

    public FeaturesPair(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getX() {
        return x;
    }

    public int getY() {
        return y;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final FeaturesPair other = (FeaturesPair) obj;
        return (this.x == other.x && this.y == other.y) || (this.x == other.y && this.y == other.x);
    }

    @Override
    public int hashCode() {
        int min = x < y ? x : y;
        int max = x > y ? x : y;
        return min << 16 ^ max;
    }

    @Override
    public String toString() {
        return "(" + x + ", " + y + ")";
    }
}
