/*
 * Decompiled with CFR 0.152.
 */
package spl.techniques;

import java.util.HashSet;
import spl.fm.Product;

public class DistancesUtil {
    public static double getSetBasedDistance(Product p1, Product p2, double weight) {
        HashSet<Integer> intersection = new HashSet<Integer>(p1);
        HashSet<Integer> union = new HashSet<Integer>(p1);
        intersection.retainAll(p2);
        union.addAll(p2);
        double intersectionSize = intersection.size();
        double unionSize = union.size();
        return 1.0 - intersectionSize / (intersectionSize + weight * (unionSize - intersectionSize));
    }

    public static double getJaccardDistance(Product p1, Product p2) {
        return DistancesUtil.getSetBasedDistance(p1, p2, 1.0);
    }

    public static double getDiceDistance(Product p1, Product p2) {
        return DistancesUtil.getSetBasedDistance(p1, p2, 0.5);
    }

    public static double getAntiDiceDistance(Product p1, Product p2) {
        return DistancesUtil.getSetBasedDistance(p1, p2, 2.0);
    }
}

