/*
 * Decompiled with CFR 0.152.
 */
package spl.techniques.ga;

import java.util.ArrayList;
import java.util.List;
import spl.SPL;
import spl.fm.Product;
import spl.techniques.SimilarityTechnique;

public class Individual {
    private double fitness;
    private List<Product> products;
    private static SimilarityTechnique st = new SimilarityTechnique(1, 3);
    private boolean evaluated;

    public Individual(Individual other) {
        this.products = new ArrayList<Product>(other.products);
        this.fitness = -1.0;
        this.evaluated = false;
    }

    public Individual(List<Product> products) {
        this.products = products;
        this.evaluated = false;
    }

    public void fitnessAndOrdering() {
        this.products = st.prioritize(this.products);
        this.fitness = st.getLastFitnessComputed();
        this.evaluated = true;
    }

    public boolean isEvaluated() {
        return this.evaluated;
    }

    public double getFitness() {
        return this.fitness;
    }

    public int getSize() {
        return this.products.size();
    }

    public List<Product> getProducts() {
        return this.products;
    }

    public void mutate(Individual best) throws Exception {
        if (best == null) {
            Product p;
            while (this.products.contains(p = SPL.getInstance().getUnpredictableProduct())) {
            }
            this.products.set(this.products.size() - 1, SPL.getInstance().getUnpredictableProduct());
        } else {
            Product p = best.getProducts().get(0);
            if (this.products.contains(p)) {
                // empty if block
            }
            while (this.products.contains(p = SPL.getInstance().getUnpredictableProduct())) {
            }
            this.products.set(this.products.size() - 1, p);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Individual other = (Individual)obj;
        return this.products == other.products || this.products != null && ((Object)this.products).equals(other.products);
    }

    public String toString() {
        return "Individual{fitness=" + this.fitness + ", products=" + this.products + '}';
    }
}

