/*
 * Decompiled with CFR 0.152.
 */
package splar.apps.experiments;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import net.sf.javabdd.BDDFactory;
import splar.apps.experiments.CollectionData;
import splar.apps.experiments.TestData;
import splar.core.constraints.CNFFormula;
import splar.core.fm.FeatureModel;
import splar.core.fm.FeatureModelException;
import splar.core.fm.FeatureModelStatistics;
import splar.core.fm.XMLFeatureModel;
import splar.core.heuristics.FORCEVariableOrderingHeuristic;
import splar.core.heuristics.FTPreOrderSortedECTraversalHeuristic;
import splar.core.heuristics.FTPreOrderTraversalHeuristic;
import splar.core.heuristics.VariableOrderingHeuristic;
import splar.core.heuristics.VariableOrderingHeuristicsManager;
import splar.plugins.reasoners.bdd.javabdd.FMReasoningWithBDD;
import splar.plugins.reasoners.bdd.javabdd.ReasoningWithBDD;

public class ScalabilityExperiments {
    String resultsOutputPath = "c:\\users\\marcilio\\eclipse\\4watreason\\experiments\\thesis\\analysis\\";
    String resultsOutputFileName = "scalability_results.txt";
    String restoreFilePath = "c:\\users\\marcilio\\eclipse\\4watreason\\experiments\\thesis\\scalability\\";
    String restoreFileName = "_restore.txt";
    String collectionPath = "c:\\users\\marcilio\\eclipse\\4watreason\\experiments\\thesis\\scalability\\files\\";
    CollectionData[] collections = this.createCollections();
    String[] heuristics = new String[]{"Pre-CL-MinSpan"};
    boolean simplifyModels = true;
    int modelStartIndex = 4;
    long bddTimeout = 3600000L;
    int bddNodeNum = 5000000;
    int bddCacheSize = 1000000;
    double bddNodeTableIncreaseFactor = 0.2;
    double bddMinimumGCFactor = 0.2;
    BDDFactory.ReorderMethod reorderMethod = BDDFactory.REORDER_NONE;
    int collectionCurIndex = 0;
    int heuristicCurIndex = 0;
    int modelCurIndex = this.modelStartIndex;

    public static void main(String[] args) {
        ScalabilityExperiments exp = new ScalabilityExperiments();
        String[] parms = args;
        if (parms.length < 1) {
            parms = new String[]{"memory-overflow"};
        }
        exp.init(parms);
    }

    private CollectionData[] createCollections() {
        CollectionData[] collections = new CollectionData[]{new CollectionData("FM-2500-SAT-20", 4)};
        return collections;
    }

    public void init(String[] args) {
        if (this.restoreState(args[0])) {
            this.logLastFailure(this.collectionCurIndex);
            ++this.modelCurIndex;
        }
        this.initializeHeuristics(null);
        for (int collectionIndex = this.collectionCurIndex; collectionIndex < this.collections.length; ++collectionIndex) {
            for (int heuristicIndex = this.heuristicCurIndex; heuristicIndex < this.heuristics.length; ++heuristicIndex) {
                for (int modelIndex = this.modelCurIndex; modelIndex <= this.collections[collectionIndex].size; ++modelIndex) {
                    String modelName = this.getModelToProcess(collectionIndex, modelIndex);
                    String heurName = this.heuristics[heuristicIndex];
                    System.out.println("-------------------------------------------------------");
                    System.out.println("Processing: [" + modelName + ", " + heurName + "]");
                    this.saveState(collectionIndex, heuristicIndex, modelIndex);
                    TestData data = new TestData();
                    data.heuristic = heurName;
                    data.modelName = modelName;
                    XMLFeatureModel fm = new XMLFeatureModel(this.collectionPath + modelName + ".xml", 20);
                    try {
                        fm.loadModel();
                    }
                    catch (FeatureModelException e) {
                        e.printStackTrace();
                    }
                    FeatureModelStatistics stats = new FeatureModelStatistics(fm);
                    stats.update();
                    data.fmSize = stats.countFeatures();
                    data.fmMan = stats.countMandatory();
                    data.fmOpt = stats.countOptional();
                    data.fmGrp1 = stats.countGrouped11();
                    data.fmGrpn = stats.countGrouped1n();
                    data.ecClauses = stats.countExtraConstraintCNFClauses();
                    data.ECR = (double)stats.countConstraintVars() * 1.0 / (double)data.fmSize;
                    data.simplified = 0;
                    if (this.simplifyModels) {
                        fm.shrink();
                        stats.update();
                        data.simplified = 1;
                    }
                    data.fmSizeSimp = stats.countFeatures();
                    data.ECRSimp = 1.0 * (double)stats.countConstraintVars() / (double)data.fmSizeSimp;
                    VariableOrderingHeuristic heurObject = VariableOrderingHeuristicsManager.createHeuristicsManager().getHeuristic(heurName);
                    heurObject.setParameter("feature_model", fm);
                    heurObject.setParameter("start_node", "output");
                    CNFFormula cnf = fm.FM2CNF();
                    System.out.println(">> Running heuristic...");
                    heurObject.run(cnf);
                    data.heurTime = heurObject.getRunningTime();
                    System.out.println(">> done! (" + data.heurTime + "ms)");
                    FMReasoningWithBDD reasoning = new FMReasoningWithBDD((FeatureModel)fm, heurObject, this.bddNodeNum, this.bddCacheSize, this.bddTimeout, this.reorderMethod, "pre-order");
                    try {
                        System.out.println(">> Building BDD...");
                        ((ReasoningWithBDD)reasoning).init();
                        data.timeout = 0;
                        System.out.println(">> done! (" + reasoning.getBDD().nodeCount() + " BDD nodes - " + reasoning.getBDDBuildingTime() + "ms)");
                    }
                    catch (Exception e) {
                        System.out.println(">>> Timeout: > " + this.bddTimeout);
                        data.timeout = 1;
                        System.out.println(">> done! (timed out!)");
                    }
                    data.bddTime = reasoning.getBDDBuildingTime();
                    data.bddSize = reasoning.getBDD().nodeCount();
                    data.sifting = 0L;
                    data.span = cnf.calculateClauseSpan(VariableOrderingHeuristic.variableOrderingAsHashMap(heurObject.getVariableOrdering()));
                    long tempTime = System.nanoTime();
                    reasoning.getBDD().satCount();
                    data.timeToCountBDDSolutions = (double)(System.nanoTime() - tempTime) / 1000000.0;
                    this.logData(data, collectionIndex);
                }
                this.saveState(collectionIndex, heuristicIndex, this.collections[collectionIndex].size + 1);
                this.modelCurIndex = this.modelStartIndex;
                if (heuristicIndex >= this.heuristics.length - 1) continue;
                this.startNewHeuristicInLog(collectionIndex);
            }
            this.heuristicCurIndex = 0;
        }
    }

    private void initializeHeuristics(FeatureModel featureModel) {
        new FTPreOrderTraversalHeuristic("Pre", featureModel);
        new FTPreOrderSortedECTraversalHeuristic("Pre-CL-MinSpan", featureModel, 20);
        new FTPreOrderSortedECTraversalHeuristic("Pre-CL-Size", featureModel, 10);
        new FORCEVariableOrderingHeuristic("FORCE", null, 1);
    }

    private String getModelToProcess(int collectionIndex, int modelIndex) {
        return this.collections[collectionIndex].name + "-" + modelIndex;
    }

    private String getOutputFileName(int collectionIndex) {
        return this.collections[collectionIndex].name + "-" + this.resultsOutputFileName;
    }

    private void startNewHeuristicInLog(int collectionIndex) {
        try {
            System.out.println("SPACES --------------");
            File file = new File(this.resultsOutputPath + this.getOutputFileName(collectionIndex));
            FileWriter writer = new FileWriter(file, true);
            writer.write("--\r\n--\r\n");
            writer.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private void logLastFailure(int collectionIndex) {
        try {
            File file = new File(this.resultsOutputPath + this.getOutputFileName(collectionIndex));
            FileWriter writer = new FileWriter(file, true);
            String line = "";
            line = line + this.heuristics[this.heuristicCurIndex];
            line = line + ",";
            line = line + this.getModelToProcess(this.collectionCurIndex, this.modelCurIndex);
            line = line + ",";
            line = line + "Memory Overflow";
            writer.write(line + "\r\n");
            writer.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private void logData(TestData data, int collectionIndex) {
        try {
            File file = new File(this.resultsOutputPath + this.getOutputFileName(collectionIndex));
            System.out.println(">> Logging data in " + file.getName() + "...");
            FileWriter writer = new FileWriter(file, true);
            String line = "";
            line = line + data.heuristic;
            line = line + ",";
            line = line + data.modelName;
            line = line + ",";
            line = line + data.heurTime;
            line = line + ",";
            line = line + data.bddTime;
            line = line + ",";
            line = line + ((double)data.bddTime + data.heurTime);
            line = line + ",";
            line = line + data.timeout;
            line = line + ",";
            line = line + data.fmSize;
            line = line + ",";
            line = line + data.fmSizeSimp;
            line = line + ",";
            line = line + data.simplified;
            line = line + ",";
            line = line + data.fmMan;
            line = line + ",";
            line = line + data.fmOpt;
            line = line + ",";
            line = line + data.fmGrp1;
            line = line + ",";
            line = line + data.fmGrpn;
            line = line + ",";
            line = line + data.ecClauses;
            line = line + ",";
            line = line + data.ECR;
            line = line + ",";
            line = line + data.ECRSimp;
            line = line + ",";
            line = line + data.bddTablePeek;
            line = line + ",";
            line = line + data.bddSizePeek;
            line = line + ",";
            line = line + data.sifting;
            line = line + ",";
            line = line + data.bddSize;
            line = line + ",";
            line = line + data.bddSize / (long)data.fmSize;
            line = line + ",";
            line = line + data.span;
            line = line + ",";
            line = line + data.timeToCountBDDSolutions;
            writer.write(line + "\r\n");
            writer.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private boolean restoreState(String typeOfInterruption) {
        File file = new File(this.restoreFilePath + this.restoreFileName);
        try {
            if (file.exists()) {
                DataInputStream stream = new DataInputStream(new FileInputStream(file));
                this.collectionCurIndex = stream.readInt();
                this.heuristicCurIndex = stream.readInt();
                this.modelCurIndex = stream.readInt();
                System.out.println(">> Indexes restored: [collection=" + this.collectionCurIndex + ", heuristic=" + this.heuristicCurIndex + ", model=" + this.modelCurIndex + "]");
                stream.close();
                if (typeOfInterruption.compareToIgnoreCase("manual-stop") == 0) {
                    System.out.println("Type of interruption: Manual");
                    return false;
                }
                return this.modelCurIndex <= this.collections[this.collectionCurIndex].size;
            }
        }
        catch (FileNotFoundException e1) {
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return false;
    }

    private void saveState(int collectionIndex, int heuristicIndex, int modelIndex) {
        File file = new File(this.restoreFilePath + this.restoreFileName);
        try {
            DataOutputStream stream = new DataOutputStream(new FileOutputStream(file));
            stream.writeInt(collectionIndex);
            stream.writeInt(heuristicIndex);
            stream.writeInt(modelIndex);
            stream.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }
}

