/*
 * Decompiled with CFR 0.152.
 */
package splar.core.constraints;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import splar.core.constraints.BooleanVariableInterface;
import splar.core.constraints.CNFClause;
import splar.core.constraints.CNFLiteral;

public class CNFFormula {
    private Set<CNFClause> clauses = new LinkedHashSet<CNFClause>();

    public void addClause(CNFClause clause) {
        this.clauses.add(clause);
    }

    public void addClauses(Collection<CNFClause> clauses) {
        this.clauses.addAll(clauses);
    }

    public Set<CNFClause> getClauses() {
        return this.clauses;
    }

    public double getClauseDensity() {
        if (this.getVariables().size() == 0) {
            return 0.0;
        }
        return 1.0 * (double)this.clauses.size() / (double)this.getVariables().size();
    }

    public int countClauses() {
        return this.clauses.size();
    }

    public Set<CNFLiteral> getLiterals() {
        HashSet<CNFLiteral> set = new HashSet<CNFLiteral>();
        Iterator<CNFClause> it = this.clauses.iterator();
        while (it.hasNext()) {
            Iterator<CNFLiteral> it2 = it.next().getLiterals().iterator();
            while (it2.hasNext()) {
                set.add(it2.next());
            }
        }
        return set;
    }

    public int countLiterals() {
        return this.getLiterals().size();
    }

    public Set<BooleanVariableInterface> getVariables() {
        HashSet<BooleanVariableInterface> set = new HashSet<BooleanVariableInterface>();
        Iterator<CNFClause> it = this.clauses.iterator();
        while (it.hasNext()) {
            Iterator<CNFLiteral> it2 = it.next().getLiterals().iterator();
            while (it2.hasNext()) {
                set.add(it2.next().getVariable());
            }
        }
        return set;
    }

    public int countVariables() {
        return this.getVariables().size();
    }

    public int calculateClauseSpan(Map<String, Integer> variable2indexMap) {
        int span = 0;
        Iterator<CNFClause> it = this.clauses.iterator();
        while (it.hasNext()) {
            span += it.next().calculateSpan(variable2indexMap);
        }
        return span;
    }

    public String toString() {
        StringBuffer toString = new StringBuffer(100);
        Iterator<CNFClause> it = this.clauses.iterator();
        while (it.hasNext()) {
            toString.append(it.next());
        }
        return toString.toString();
    }
}

