/*
 * Decompiled with CFR 0.152.
 */
package splar.core.constraints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import splar.core.constraints.BooleanVariableInterface;
import splar.core.constraints.CNFClause;
import splar.core.constraints.CNFLiteral;
import splar.core.constraints.CNFLiteralComparator;

public class CNFGenerator {
    private Map<String, byte[]> clausesMap = new HashMap<String, byte[]>();
    private int varIndex = -1;

    public List<CNFClause> generateCNFInstance(List<BooleanVariableInterface> variables, List<CNFClause> clauses, float clauseDensity, int arity) {
        this.clausesMap.clear();
        if (clauses != null) {
            for (CNFClause clause : clauses) {
                this.storeClause(clause, arity);
            }
        }
        this.varIndex = -1;
        LinkedList<CNFClause> createdClauses = new LinkedList<CNFClause>();
        int numClausesToCreate = (int)(clauseDensity * (float)variables.size()) - (clauses == null ? 0 : clauses.size());
        for (int i = 0; i < numClausesToCreate; ++i) {
            CNFClause createdClause = this.createNewClause(variables, arity);
            if (!this.storeClause(createdClause, arity)) continue;
            createdClauses.add(createdClause);
        }
        return createdClauses;
    }

    private List<BooleanVariableInterface> pickVariables(List<BooleanVariableInterface> variables, int arity) {
        ArrayList<BooleanVariableInterface> pickedVars = new ArrayList<BooleanVariableInterface>(arity);
        Random randomGen = new Random();
        int numVars = variables.size();
        for (int i = 0; i < arity; ++i) {
            BooleanVariableInterface var = null;
            while (pickedVars.contains(var = variables.get(Math.abs(randomGen.nextInt()) % numVars))) {
            }
            pickedVars.add(var);
        }
        return pickedVars;
    }

    private CNFClause createNewClause(List<BooleanVariableInterface> variables, int arity) {
        String key;
        CNFClause newClause = null;
        List<BooleanVariableInterface> pickedVariables = this.pickVariables(variables, arity);
        byte[] existingClauses = null;
        int pos = -1;
        int maxLoop = Math.max(1000, pickedVariables.size());
        do {
            newClause = new CNFClause();
            for (int i = 0; i < arity; ++i) {
                newClause.addLiteral(new CNFLiteral(pickedVariables.get(i), new Random().nextBoolean()));
            }
            key = this.getClauseKey(newClause);
            pos = this.getClausePos(newClause);
        } while ((existingClauses = this.clausesMap.get(key)) != null && existingClauses[pos] != 0 && maxLoop-- > 0);
        return newClause;
    }

    private boolean storeClause(CNFClause clause, int arity) {
        assert (clause.getLiterals().size() == arity);
        String key = this.getClauseKey(clause);
        int pos = this.getClausePos(clause);
        byte[] existingClauses = this.clausesMap.get(key);
        if (existingClauses == null) {
            existingClauses = new byte[(int)Math.pow(2.0, arity)];
            this.clausesMap.put(key, existingClauses);
        }
        if (existingClauses[pos] == 0) {
            existingClauses[pos] = 1;
            return true;
        }
        return false;
    }

    private String getClauseKey(CNFClause clause) {
        String key = "";
        List<CNFLiteral> literals = clause.getLiterals();
        Collections.sort(literals, new CNFLiteralComparator());
        for (CNFLiteral literal : literals) {
            key = key + literal.getVariable().getID() + "-";
        }
        return key;
    }

    private int getClausePos(CNFClause clause) {
        int pos = 0;
        int power = 1;
        List<CNFLiteral> literals = clause.getLiterals();
        Collections.sort(literals, new CNFLiteralComparator());
        for (CNFLiteral literal : literals) {
            pos += (literal.isPositive() ? 0 : 1) * power;
            power *= 2;
        }
        return pos;
    }

    public String getStats(Set<CNFClause> clauses) {
        return this.getStats(new LinkedList<CNFClause>(clauses));
    }

    public String getStats(List<CNFClause> clauses) {
        LinkedHashSet<CNFLiteral> literals = new LinkedHashSet<CNFLiteral>();
        LinkedHashSet<BooleanVariableInterface> variables = new LinkedHashSet<BooleanVariableInterface>();
        int[] arities = new int[]{0, 0, 0, 0};
        for (CNFClause clause : clauses) {
            literals.addAll(clause.getLiterals());
            variables.addAll(clause.getVariables());
            int index = clause.getLiterals().size() - 1;
            int n = index < 4 ? index : arities.length - 1;
            arities[n] = arities[n] + 1;
        }
        String stats = "";
        stats = stats + "\r\n  Total Variables: " + variables.size();
        stats = stats + "\r\n  Total Literals.: " + literals.size();
        stats = stats + "\r\n  Total Clauses..: " + clauses.size();
        stats = stats + "\r\n  Clause density.: " + 1.0f * (float)clauses.size() / (float)variables.size();
        return stats;
    }
}

