/*
 * Decompiled with CFR 0.152.
 */
package splar.core.fm.clustering;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import splar.core.constraints.CNFClause;
import splar.core.constraints.CNFFormula;
import splar.core.fm.FeatureModel;
import splar.core.fm.FeatureTreeNode;
import splar.core.heuristics.FORCEVariableOrderingHeuristic;

public class NodeCluster {
    private FeatureTreeNode root;
    private FeatureModel featureModel;
    private List<FeatureTreeNode> nodes;
    private int size = -1;
    private List<CNFClause> ecClauses;
    private List<CNFClause> clusterClauses;

    public NodeCluster(FeatureModel featureModel, FeatureTreeNode root) {
        this.root = root;
        this.featureModel = featureModel;
        this.nodes = new ArrayList<FeatureTreeNode>();
        this.ecClauses = null;
        this.clusterClauses = null;
    }

    public List<FeatureTreeNode> getNodes() {
        return this.nodes;
    }

    public FeatureTreeNode getRoot() {
        return this.root;
    }

    public void addNode(FeatureTreeNode node) {
        this.nodes.add(node);
    }

    public void addECClauses(List<CNFClause> ecClauses) {
        this.ecClauses = ecClauses;
    }

    public void addClusterClauses(List<CNFClause> clusterClauses) {
        this.clusterClauses = clusterClauses;
    }

    public List<CNFClause> getECClauses() {
        return this.ecClauses;
    }

    public List<CNFClause> getClusterClauses() {
        return this.clusterClauses;
    }

    public int countNodes() {
        return this.nodes.size();
    }

    public int size() {
        if (this.size == -1) {
            for (FeatureTreeNode node : this.nodes) {
                this.size += this.featureModel.countNodes(node);
            }
        }
        return this.size;
    }

    public FeatureTreeNode[] sortedNodes() {
        FeatureTreeNode[] sortedNodes = new FeatureTreeNode[this.nodes.size()];
        int index = 0;
        for (FeatureTreeNode node : this.nodes) {
            sortedNodes[index++] = node;
        }
        if (sortedNodes.length > 1) {
            Comparator<FeatureTreeNode> c = new Comparator<FeatureTreeNode>(){

                @Override
                public int compare(FeatureTreeNode node1, FeatureTreeNode node2) {
                    int size2;
                    int size1 = NodeCluster.this.featureModel.countNodes(node1);
                    return size1 > (size2 = NodeCluster.this.featureModel.countNodes(node2)) ? 1 : (size1 < size2 ? -1 : 0);
                }
            };
            Arrays.sort(sortedNodes, c);
        }
        return sortedNodes;
    }

    public FeatureTreeNode[] sortedNodesbyFORCE() {
        FORCEVariableOrderingHeuristic force = new FORCEVariableOrderingHeuristic("", 1);
        CNFFormula cnf = new CNFFormula();
        cnf.addClauses(this.clusterClauses);
        String[] vo = force.run(cnf);
        FeatureTreeNode[] voNodes = new FeatureTreeNode[vo.length];
        int index = 0;
        for (String nodeID : vo) {
            voNodes[index++] = this.featureModel.getNodeByID(nodeID);
        }
        return voNodes;
    }

    public void dump() {
        System.out.println("\nCluster: " + this.root.getID());
        System.out.print("  Nodes: ");
        for (FeatureTreeNode node : this.nodes) {
            System.out.print(node.getID() + ", ");
        }
        if (this.clusterClauses != null) {
            System.out.print("\n  Cluster clauses: ");
            for (CNFClause clause : this.clusterClauses) {
                System.out.print(clause + ", ");
            }
        }
        if (this.ecClauses != null) {
            System.out.print("\n  EC clauses: ");
            for (CNFClause clause : this.ecClauses) {
                System.out.print(clause + ", ");
            }
        }
    }
}

