/*
 * Decompiled with CFR 0.152.
 */
package splar.core.fm.randomization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import splar.core.constraints.PropositionalFormula;
import splar.core.fm.FeatureGroup;
import splar.core.fm.FeatureModel;
import splar.core.fm.FeatureTreeNode;
import splar.core.fm.GroupedFeature;

class _LevelConstraintGenerator {
    private FeatureModel fm;
    private int level;
    private int numVars;
    private int numConstraints;
    private int maxArity;
    private int percentage;

    public _LevelConstraintGenerator(FeatureModel fm, int level, int numVars, int numConstraints, int maxArity, int percentage) {
        this.fm = fm;
        this.level = level;
        this.numVars = numVars;
        this.numConstraints = numConstraints;
        this.maxArity = maxArity;
        this.percentage = percentage;
    }

    public int getNumberOfVariables() {
        return this.numVars;
    }

    public List<PropositionalFormula> createExtraConstraints() {
        ArrayList<PropositionalFormula> formulas = new ArrayList<PropositionalFormula>();
        List<FeatureTreeNode> selectedClusters = this.selectClusters(this.fm.getNodesAtLevel(this.level), this.percentage);
        int numClusters = selectedClusters.size();
        if (numClusters > 0) {
            int clustersTotalSize = 0;
            for (FeatureTreeNode cluster : selectedClusters) {
                clustersTotalSize += this.fm.countNodes(cluster);
            }
            for (FeatureTreeNode cluster : selectedClusters) {
                float percVarsConst = (float)this.fm.countNodes(cluster) / (1.0f * (float)clustersTotalSize);
                int numVarsCluster = Math.round(percVarsConst * (float)this.numVars);
                int numConstraintsCluster = numVarsCluster / 3;
                if (numVarsCluster < 2 || numConstraintsCluster < 1) {
                    numVarsCluster = 2;
                    numConstraintsCluster = 1;
                }
                formulas.addAll(this.createClusterConstraints(cluster, numVarsCluster, numConstraintsCluster));
            }
        }
        return formulas;
    }

    private List<PropositionalFormula> createClusterConstraints(FeatureTreeNode clusterNode, int numVarsCluster, int numConstraintsCluster) {
        ArrayList<PropositionalFormula> formulas = new ArrayList<PropositionalFormula>();
        ArrayList<FeatureTreeNode> nodes = new ArrayList<FeatureTreeNode>();
        for (int i = 0; i < clusterNode.getChildCount(); ++i) {
            nodes.add((FeatureTreeNode)clusterNode.getChildAt(i));
        }
        ArrayList pickedNodesForVariables = new ArrayList();
        int countNodes = nodes.size();
        for (int i = 0; i < countNodes; ++i) {
            pickedNodesForVariables.add(i, new ArrayList());
        }
        ArrayList<FeatureTreeNode> tempNodes = new ArrayList<FeatureTreeNode>();
        tempNodes.addAll(nodes);
        int nodeIndex = 0;
        for (int i = 0; i < numVarsCluster && tempNodes.size() > 0; ++i) {
            FeatureTreeNode node = (FeatureTreeNode)tempNodes.get(nodeIndex);
            if (!this.selectVariableFeature(node, (List)pickedNodesForVariables.get(nodeIndex))) {
                tempNodes.remove(nodeIndex);
                nodeIndex = nodeIndex == tempNodes.size() ? 0 : nodeIndex;
                continue;
            }
            ++nodeIndex;
            nodeIndex %= tempNodes.size();
        }
        int indexToRemove = 0;
        for (int i = 0; i < countNodes; ++i) {
            List pickedFeatures = (List)pickedNodesForVariables.get(indexToRemove);
            if (pickedFeatures.size() == 0) {
                pickedNodesForVariables.remove(indexToRemove);
                nodes.remove(indexToRemove);
                continue;
            }
            ++indexToRemove;
        }
        countNodes = nodes.size();
        if (countNodes > 0) {
            int i;
            int[] varsIndex = new int[countNodes];
            for (i = 0; i < countNodes; ++i) {
                varsIndex[i] = 0;
            }
            Collections.shuffle(pickedNodesForVariables);
            nodeIndex = 0;
            for (i = 0; i < numConstraintsCluster; ++i) {
                ArrayList variables = new ArrayList();
                int arity = 2;
                for (int j = 0; j < arity; ++j) {
                    List variablesForNode = (List)pickedNodesForVariables.get(nodeIndex);
                    variables.add(variablesForNode.get(varsIndex[nodeIndex]));
                    int n = nodeIndex;
                    int n2 = varsIndex[n] + 1;
                    varsIndex[n] = n2;
                    varsIndex[nodeIndex] = n2 % ((List)pickedNodesForVariables.get(nodeIndex)).size();
                    if (varsIndex[nodeIndex] == 0) {
                        Collections.shuffle((List)pickedNodesForVariables.get(nodeIndex));
                    }
                    if (Math.abs(new Random().nextInt()) % 2 == 0) {
                        nodeIndex = Math.abs(new Random().nextInt()) % countNodes;
                        continue;
                    }
                    if (++nodeIndex != countNodes) continue;
                    nodeIndex = 0;
                }
                String formulaStr = "";
                Iterator it = variables.iterator();
                while (it.hasNext()) {
                    formulaStr = formulaStr + ((FeatureTreeNode)it.next()).getID();
                    if (!it.hasNext()) continue;
                    formulaStr = formulaStr + " OR ";
                }
                try {
                    formulas.add(new PropositionalFormula("C_" + (this.level + 1) + "_" + clusterNode.getID() + "_" + i, formulaStr));
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Error: " + formulaStr);
                }
            }
        }
        return formulas;
    }

    private boolean selectVariableFeature(FeatureTreeNode subtreeRootNode, List<FeatureTreeNode> pickedNodesForVariables) {
        ArrayList<FeatureTreeNode> subtreeNodes = new ArrayList<FeatureTreeNode>();
        this.fm.getSubtreeNodes(subtreeRootNode, subtreeNodes);
        if (!(subtreeRootNode instanceof FeatureGroup)) {
            subtreeNodes.add(subtreeRootNode);
        }
        Iterator it = subtreeNodes.iterator();
        while (it.hasNext()) {
            Integer isSelected;
            FeatureTreeNode node = (FeatureTreeNode)it.next();
            if (node instanceof FeatureGroup || ((isSelected = (Integer)node.getAttachedData()) == null || isSelected != 1) && !pickedNodesForVariables.contains(node)) continue;
            it.remove();
        }
        int countNodes = subtreeNodes.size();
        if (countNodes > 0) {
            FeatureTreeNode nodeSelected = (FeatureTreeNode)subtreeNodes.get(Math.abs(new Random().nextInt()) % countNodes);
            nodeSelected.attachData(new Integer(1));
            pickedNodesForVariables.add(nodeSelected);
            return true;
        }
        return false;
    }

    public List<FeatureTreeNode> selectClusters(List<FeatureTreeNode> nodes, int percentage) {
        int totalCandidateClusters = nodes.size();
        Iterator<FeatureTreeNode> it = nodes.iterator();
        while (it.hasNext()) {
            FeatureTreeNode node = it.next();
            boolean qualifies = false;
            if (node.getChildCount() >= 2) {
                int countCandidateSubTrees = 0;
                for (int i = 0; i < node.getChildCount(); ++i) {
                    FeatureTreeNode childNode = (FeatureTreeNode)node.getChildAt(i);
                    if (this.countAvailableFeatures(childNode, !(node instanceof GroupedFeature)) < 1) continue;
                    ++countCandidateSubTrees;
                }
                boolean bl = qualifies = countCandidateSubTrees >= 2;
            }
            if (qualifies) continue;
            it.remove();
        }
        Collections.shuffle(nodes);
        int nodesToEliminate = Math.min(nodes.size(), Math.round((1.0f - (float)percentage / 100.0f) * (float)totalCandidateClusters));
        for (int i = 0; i < nodesToEliminate; ++i) {
            nodes.remove(Math.abs(new Random().nextInt()) % nodes.size());
        }
        float numClusters = nodes.size();
        if (2.0f * numClusters > (float)this.numVars) {
            int clustersToRemove = Math.round(numClusters - (float)this.numVars / 2.0f);
            for (int i = 0; i < clustersToRemove; ++i) {
                nodes.remove(Math.round(Math.abs(new Random().nextInt()) % nodes.size()));
            }
        }
        return nodes;
    }

    private int countAvailableFeatures(FeatureTreeNode node, boolean includesNodeItSelf) {
        ArrayList<FeatureTreeNode> nodes = new ArrayList<FeatureTreeNode>();
        this.fm.getSubtreeNodes(node, nodes);
        if (includesNodeItSelf) {
            nodes.add(node);
        }
        int countFeatures = 0;
        for (FeatureTreeNode descendantNode : nodes) {
            if (descendantNode instanceof FeatureGroup || descendantNode.getAttachedData() != null) continue;
            ++countFeatures;
        }
        return countFeatures;
    }
}

