/*
 * Decompiled with CFR 0.152.
 */
package splar.core.heuristics;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import splar.core.constraints.BooleanVariableInterface;
import splar.core.constraints.CNFFormula;
import splar.core.fm.FeatureGroup;
import splar.core.fm.FeatureModel;
import splar.core.fm.FeatureTreeNode;
import splar.core.heuristics.FTTraversalHeuristic;

public class FTPostOrderTraversalHeuristic
extends FTTraversalHeuristic {
    public FTPostOrderTraversalHeuristic(String name, FeatureModel featureModel) {
        super(name, featureModel);
    }

    @Override
    public String[] runHeuristic(CNFFormula cnf) {
        this.featureModel.resetNodesAttachedData();
        String[] varOrder = new String[cnf.getVariables().size()];
        Set<BooleanVariableInterface> cnfVariables = cnf.getVariables();
        Stack<FeatureTreeNode> nodes = new Stack<FeatureTreeNode>();
        FeatureTreeNode curNode = this.featureModel.getRoot();
        List childNodes = new ArrayList<FeatureTreeNode>();
        for (FeatureTreeNode node : this.orderChildNodes(curNode)) {
            childNodes.add(node);
        }
        curNode.attachData(childNodes);
        nodes.push(curNode);
        int curIndex = 0;
        while (nodes.size() > 0) {
            curNode = (FeatureTreeNode)nodes.peek();
            if (curNode == null) continue;
            childNodes = (List)curNode.getAttachedData();
            if (childNodes.size() > 0) {
                FeatureTreeNode childNode = (FeatureTreeNode)childNodes.get(0);
                childNodes.remove(0);
                ArrayList<FeatureTreeNode> childChildNodes = new ArrayList<FeatureTreeNode>();
                for (FeatureTreeNode node : this.orderChildNodes(childNode)) {
                    childChildNodes.add(node);
                }
                childNode.attachData(childChildNodes);
                nodes.push(childNode);
                continue;
            }
            nodes.pop();
            if (curNode instanceof FeatureGroup || !cnfVariables.contains(curNode)) continue;
            varOrder[curIndex++] = curNode.getID();
        }
        return varOrder;
    }

    protected FeatureTreeNode[] orderChildNodes(FeatureTreeNode node) {
        int count = node.getChildCount();
        FeatureTreeNode[] nodes = new FeatureTreeNode[count];
        for (int i = 0; i < count; ++i) {
            nodes[i] = (FeatureTreeNode)node.getChildAt(i);
        }
        return nodes;
    }
}

