/*
 * Decompiled with CFR 0.152.
 */
package splar.core.util.alloy;

import java.util.Iterator;
import java.util.LinkedList;
import splar.core.fm.FeatureGroup;
import splar.core.fm.FeatureModel;
import splar.core.fm.FeatureTreeNode;
import splar.core.fm.SolitaireFeature;

public class FM2AlloyConversor {
    private static String header = "\r\n//Header Declarations\r\n\nsig FM {\r\n\tfeatures: set Name\r\n}\r\nsig Name {}\r\npred optional[A,B:Name, conf:set Name] {\r\n\tB in conf => A in conf\r\n}\r\npred mandatory[A,B:Name, conf:set Name] {\r\n\tA in conf <=> B in conf\r\n}\r\npred root[A:Name, conf: set Name] {\r\n\tA in conf\r\n}\r\npred orFeature[A,B,C:Name, conf: set Name] {\r\n\tA in conf <=> (B in conf) or (C in conf)\r\n}\r\npred alternativeFeature[A,B,C:Name, conf: set Name] {\r\n\torFeature[A,B,C,conf]\r\n\tB in conf => C !in conf\r\n\tC in conf => B !in conf\r\n}\r\n";

    public static String convert(FeatureModel fm, boolean includeHeader) {
        FeatureTreeNode feature;
        String alloy = "";
        if (includeHeader) {
            alloy = alloy + header;
        }
        alloy = alloy + "\r\n\n// Feature Model Declaration\r\n\r\none sig " + fm.getName() + " extends FM {}\r\n";
        alloy = alloy + "one sig ";
        Iterator<FeatureTreeNode> it = fm.getNodes().iterator();
        while (it.hasNext()) {
            feature = it.next();
            if (feature instanceof FeatureGroup) continue;
            alloy = alloy + feature.getID();
            if (!it.hasNext()) continue;
            alloy = alloy + ",";
        }
        alloy = alloy + " extends Name {}\r\n";
        alloy = alloy + "fact " + fm.getName() + "Features {\r\n" + "\t" + fm.getName() + ".features = ";
        it = fm.getNodes().iterator();
        while (it.hasNext()) {
            feature = it.next();
            if (feature instanceof FeatureGroup) continue;
            alloy = alloy + feature.getID();
            if (!it.hasNext()) continue;
            alloy = alloy + "+";
        }
        alloy = alloy + "\r\n}\r\n";
        alloy = alloy + "pred semantics" + fm.getName() + "[conf: set Name] {\r\n" + "\tconf in " + fm.getName() + ".features\r\n";
        alloy = alloy + "\troot[" + fm.getRoot().getID() + ",conf]\r\n";
        alloy = alloy + FM2AlloyConversor.FT2Alloy(fm);
        alloy = alloy + "}\r\n";
        return alloy;
    }

    private static String FT2Alloy(FeatureModel fm) {
        String output = "";
        LinkedList<FeatureTreeNode> features = new LinkedList<FeatureTreeNode>();
        features.add(fm.getRoot());
        while (!features.isEmpty()) {
            FeatureTreeNode feature = (FeatureTreeNode)features.getFirst();
            features.removeFirst();
            for (int i = 0; i < feature.getChildCount(); ++i) {
                FeatureTreeNode childFeature = (FeatureTreeNode)feature.getChildAt(i);
                if (childFeature instanceof SolitaireFeature) {
                    output = ((SolitaireFeature)childFeature).isOptional() ? output + "\toptional[" + feature.getID() + "," + childFeature.getID() + ",conf]\r\n" : output + "\tmandatory[" + feature.getID() + "," + childFeature.getID() + ",conf]\r\n";
                    features.add(childFeature);
                    continue;
                }
                if (!(childFeature instanceof FeatureGroup)) continue;
                FeatureGroup group = (FeatureGroup)childFeature;
                FeatureTreeNode parent = (FeatureTreeNode)group.getParent();
                if (group.getMax() == 1 && group.getMax() == 1) {
                    output = output + "\talternativeFeature[" + parent.getID() + ",";
                } else if (group.getMax() == -1 || group.getMax() == group.getChildCount()) {
                    output = output + "\torFeature[" + parent.getID() + ",";
                }
                int childCount = group.getChildCount();
                for (int j = 0; j < childCount; ++j) {
                    FeatureTreeNode groupedFeature = (FeatureTreeNode)group.getChildAt(j);
                    output = output + groupedFeature.getID();
                    output = output + ",";
                    features.add(groupedFeature);
                }
                output = output + "conf]\r\n";
            }
        }
        return output;
    }
}

