/*
 * Decompiled with CFR 0.152.
 */
package splar.plugins.configuration.sat.sat4j;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.core.Solver;
import org.sat4j.specs.ContradictionException;
import splar.core.fm.FTTraversalNodeSelector;
import splar.core.fm.FTTraversals;
import splar.core.fm.FeatureGroup;
import splar.core.fm.FeatureModel;
import splar.core.fm.FeatureTreeNode;
import splar.core.fm.configuration.ConfigurationEngine;
import splar.core.fm.configuration.ConfigurationEngineException;
import splar.core.fm.configuration.ConfigurationStep;
import splar.plugins.reasoners.sat.sat4j.FMReasoningWithSAT;
import splar.plugins.reasoners.sat.sat4j.StaticVariableOrderSAT;

public class SATConfigurationEngine
extends ConfigurationEngine {
    protected FMReasoningWithSAT reasoner = null;
    Map<String, String> satStats = null;

    public SATConfigurationEngine(String featureModelURL) throws ConfigurationEngineException {
        super(featureModelURL);
        try {
            FMReasoningWithSAT tempReasoner = new FMReasoningWithSAT("MiniSAT", this.model, 60000);
            tempReasoner.init();
            if (!tempReasoner.isConsistent()) {
                throw new ConfigurationEngineException("Model is inconsistent and thus cannot be configured ");
            }
        }
        catch (ContradictionException contExc) {
            throw new ConfigurationEngineException("Model is inconsistent and thus cannot be configured ");
        }
        catch (Exception e) {
            throw new ConfigurationEngineException("Problems loading model. Location might be wrong or model does not follow SXFM specification");
        }
    }

    void addClauseToSolver(FMReasoningWithSAT reasoner, String decisionVar, int decisionValue) throws Exception {
        Solver satSolver = (Solver)reasoner.getSolver();
        int varIndex = reasoner.getVariableIndex(decisionVar);
        VecInt vectInt = new VecInt(1);
        vectInt.push(decisionValue == 1 ? varIndex : -varIndex);
        satSolver.addClause(vectInt);
    }

    @Override
    protected synchronized ConfigurationStep resetConfiguration() throws ConfigurationEngineException {
        Object newConfStep = null;
        try {
            this.reasoner = this.createSATReasoner(this.model);
            this.createConfigurationStep(this.model.getRoot().getID(), 1, "propagated");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ConfigurationEngineException("Problems reseting configuration", e);
        }
        return this.getLastStep();
    }

    @Override
    public List<ConfigurationStep> undo(int undoStep) throws ConfigurationEngineException {
        try {
            List<ConfigurationStep> undoneSteps = super.undo(undoStep);
            this.reasoner = this.createSATReasoner(this.model);
            return undoneSteps;
        }
        catch (ConfigurationEngineException e1) {
            throw e1;
        }
        catch (Exception e2) {
            throw new ConfigurationEngineException("Problems undoing configuration step " + undoStep, e2);
        }
    }

    protected FMReasoningWithSAT createSATReasoner(FeatureModel model) throws Exception {
        FMReasoningWithSAT satReasoner = new FMReasoningWithSAT("MiniSAT", model, 60000);
        satReasoner.init();
        return satReasoner;
    }

    @Override
    public synchronized ConfigurationStep autoComplete(boolean valueOrder) throws ConfigurationEngineException {
        ConfigurationStep newConfStep = null;
        try {
            long time;
            int curConfStep = this.steps.size() + 1;
            this.model.saveState("state_step" + curConfStep);
            String[] satVarOrder = new String[this.model.countFeatures()];
            FTTraversalNodeSelector selector = new FTTraversalNodeSelector(){

                @Override
                public boolean select(FeatureTreeNode node) {
                    return !(node instanceof FeatureGroup);
                }
            };
            int index = 0;
            for (FeatureTreeNode node : FTTraversals.dfs(this.model.getRoot(), selector)) {
                satVarOrder[index++] = node.getID();
            }
            StaticVariableOrderSAT satOrderObj = new StaticVariableOrderSAT(satVarOrder, valueOrder, this.reasoner.getVarName2IndexMap(), this.reasoner.getVarIndex2NameMap());
            this.reasoner.setVariableOrderObject(satOrderObj);
            Solver satSolver = (Solver)this.reasoner.getSolver();
            if (satSolver.isSatisfiable()) {
                time = System.currentTimeMillis();
                int[] solution = satSolver.model();
                time = System.currentTimeMillis() - time;
                newConfStep = new ConfigurationStep("" + curConfStep);
                for (int value : solution) {
                    String featureId = this.reasoner.getVariableName(Math.abs(value));
                    FeatureTreeNode completedFeature = this.model.getNodeByID(featureId);
                    if (completedFeature.isInstantiated()) continue;
                    this.model.assignValue(completedFeature, value > 0 ? 1 : 0);
                    completedFeature.setProperty("decisionStep", "" + curConfStep);
                    completedFeature.setProperty("decisionType", "auto-completion");
                    newConfStep.addPropagatedFeature(completedFeature);
                }
            } else {
                throw new ConfigurationEngineException("Problems autocompleting configuration: isSatisfiable()");
            }
            newConfStep.addAttribute("step_Stat", "1");
            newConfStep.addAttribute("step_runTime", "" + time);
            ConfigurationStep.computeStepAttributes(newConfStep, this.steps, this.model);
            this.steps.add(newConfStep);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ConfigurationEngineException("Problems autocompleting configuration", e);
        }
        return newConfStep;
    }

    @Override
    protected Map<String, Boolean[]> createConfigurationStep(String featureId, int featureValue, String decisionType) throws Exception {
        Map<String, Boolean[]> domainTable = null;
        this.addClauseToSolver(this.reasoner, featureId, featureValue);
        domainTable = super.createConfigurationStep(featureId, featureValue, decisionType);
        ConfigurationStep newConfStep = this.getLastStep();
        newConfStep.addAttribute("step_Stat", this.satStats.get("sat-checks"));
        newConfStep.addAttribute("step_runTime", this.satStats.get("processing-time"));
        return domainTable;
    }

    @Override
    protected Map<String, Boolean[]> computeValidDomains() throws ConfigurationEngineException {
        try {
            if (this.satStats == null) {
                this.satStats = new HashMap<String, String>();
            } else {
                this.satStats.clear();
            }
            return this.reasoner.allValidDomains(this.satStats);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ConfigurationEngineException("Problems computing valid domains for SAT: " + e.getMessage());
        }
    }

    @Override
    protected String getVariableName(int varIndex) {
        return this.reasoner.getVariableName(varIndex + 1);
    }

    @Override
    protected int getVariableIndex(String varName) {
        return this.reasoner.getVariableIndex(varName);
    }

    @Override
    public synchronized List<FeatureTreeNode> detectConflicts(String featureId) throws ConfigurationEngineException {
        LinkedList<FeatureTreeNode> conflictingFeatures = new LinkedList<FeatureTreeNode>();
        try {
            String[] newDecisionSequenceArray;
            this.model.saveState("detect_conflicts");
            FeatureTreeNode toggleFeatureNode = this.model.getNodeByID(featureId);
            if (!toggleFeatureNode.isInstantiated()) {
                throw new ConfigurationEngineException("Cannot toggle the value of an uninstantiated feature");
            }
            if (toggleFeatureNode.isImmutable()) {
                throw new ConfigurationEngineException("Cannot toggle the value of an immutable feature");
            }
            int toggleFeatureOriginalValue = toggleFeatureNode.getValue();
            int toggleFeatureStep = Integer.valueOf((String)toggleFeatureNode.getProperty("decisionStep"));
            LinkedHashMap<String, Integer> newDecisionSequence = new LinkedHashMap<String, Integer>();
            newDecisionSequence.put(toggleFeatureNode.getID(), 1 - toggleFeatureOriginalValue);
            for (int i = toggleFeatureStep - 1; i < this.steps.size(); ++i) {
                for (FeatureTreeNode manualDecision : ((ConfigurationStep)this.steps.get(i)).getDecisions()) {
                    if (manualDecision.equals(toggleFeatureNode)) continue;
                    newDecisionSequence.put(manualDecision.getID(), manualDecision.getValue());
                }
            }
            this.model.restoreState("state_step" + toggleFeatureStep, false);
            FMReasoningWithSAT tempReasoner = this.createSATReasoner(this.model);
            int index = 0;
            for (String decisionNodeId : newDecisionSequenceArray = newDecisionSequence.keySet().toArray(new String[0])) {
                int decisionNodeValue = (Integer)newDecisionSequence.get(decisionNodeId);
                if (decisionNodeValue != -1) {
                    this.addClauseToSolver(tempReasoner, decisionNodeId, (Integer)newDecisionSequence.get(decisionNodeId));
                    HashMap<String, String> satStats = new HashMap<String, String>();
                    Map<String, Boolean[]> domainTable = tempReasoner.allValidDomains(satStats);
                    for (int i = index + 1; i < newDecisionSequenceArray.length; ++i) {
                        String varName = newDecisionSequenceArray[i];
                        int varValue = (Integer)newDecisionSequence.get(varName);
                        Boolean[] domain = domainTable.get(varName);
                        if (domain.length == 1 && domain[0].booleanValue() && varValue == 0 || domain.length == 1 && !domain[0].booleanValue() && varValue == 1) {
                            newDecisionSequence.put(varName, -1);
                            this.addClauseToSolver(tempReasoner, varName, 1 - varValue);
                            conflictingFeatures.add(this.model.getNodeByID(varName));
                            continue;
                        }
                        if ((domain.length != 1 || !domain[0].booleanValue() || varValue != 1) && (domain.length != 1 || domain[0].booleanValue() || varValue != 0)) continue;
                        newDecisionSequence.put(varName, -1);
                        this.addClauseToSolver(tempReasoner, varName, varValue);
                    }
                }
                ++index;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ConfigurationEngineException("Problems configuring model: " + e.getMessage());
        }
        finally {
            this.model.restoreState("detect_conflicts", true);
        }
        return conflictingFeatures;
    }

    @Override
    public synchronized List<ConfigurationStep> toggleDecision(String featureId) throws ConfigurationEngineException {
        LinkedList<ConfigurationStep> newConfSteps = new LinkedList<ConfigurationStep>();
        try {
            String[] newDecisionSequenceArray;
            this.model.saveState("toggle_decision");
            FeatureTreeNode toggleFeatureNode = this.model.getNodeByID(featureId);
            if (!toggleFeatureNode.isInstantiated()) {
                throw new ConfigurationEngineException("Cannot toggle the value of an uninstantiated feature");
            }
            if (toggleFeatureNode.isImmutable()) {
                throw new ConfigurationEngineException("Cannot toggle the value of an immutable feature");
            }
            int toggleFeatureOriginalValue = toggleFeatureNode.getValue();
            int toggleFeatureStep = Integer.valueOf((String)toggleFeatureNode.getProperty("decisionStep"));
            LinkedHashMap<String, Integer> newDecisionSequence = new LinkedHashMap<String, Integer>();
            newDecisionSequence.put(toggleFeatureNode.getID(), 1 - toggleFeatureOriginalValue);
            int initialStep = toggleFeatureStep - 1;
            while (this.steps.size() > initialStep) {
                for (FeatureTreeNode manualDecision : ((ConfigurationStep)this.steps.get(initialStep)).getDecisions()) {
                    if (manualDecision.equals(toggleFeatureNode)) continue;
                    newDecisionSequence.put(manualDecision.getID(), manualDecision.getValue());
                }
                this.steps.remove(initialStep);
            }
            this.model.restoreState("state_step" + toggleFeatureStep, false);
            this.reasoner = this.createSATReasoner(this.model);
            int index = 0;
            for (String decisionNodeId : newDecisionSequenceArray = newDecisionSequence.keySet().toArray(new String[0])) {
                int decisionNodeValue = (Integer)newDecisionSequence.get(decisionNodeId);
                if (decisionNodeValue != -1) {
                    Map<String, Boolean[]> domainTable = this.createConfigurationStep(decisionNodeId, decisionNodeValue, "manual");
                    ConfigurationStep newConfStep = this.getLastStep();
                    newConfSteps.add(newConfStep);
                    for (int i = index + 1; i < newDecisionSequenceArray.length; ++i) {
                        String varName = newDecisionSequenceArray[i];
                        int varValue = (Integer)newDecisionSequence.get(varName);
                        Boolean[] domain = domainTable.get(varName);
                        if (domain.length == 1 && domain[0].booleanValue() && varValue == 0 || domain.length == 1 && !domain[0].booleanValue() && varValue == 1) {
                            newDecisionSequence.put(varName, -1);
                            continue;
                        }
                        if (domain.length == 1 && domain[0].booleanValue() && varValue == 1 || domain.length == 1 && !domain[0].booleanValue() && varValue == 0) {
                            newDecisionSequence.put(varName, -1);
                            FeatureTreeNode propagatedFeature = this.model.getNodeByID(varName);
                            newConfStep.removePropagatedDecision(propagatedFeature);
                            propagatedFeature.setProperty("decisionType", "manual");
                            newConfStep.addManualDecisionFeature(propagatedFeature);
                            continue;
                        }
                        System.out.println(">> " + varName);
                    }
                }
                ++index;
            }
        }
        catch (Exception e) {
            this.model.restoreState("toggle_decision", true);
            e.printStackTrace();
            throw new ConfigurationEngineException("Problems toggling feature value: " + e.getMessage());
        }
        return newConfSteps;
    }
}

