/*
 * Decompiled with CFR 0.152.
 */
package splar.plugins.reasoners.bdd.javabdd;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import net.sf.javabdd.BDD;

public class BDDTraversal {
    protected Set<String> path = new LinkedHashSet<String>();
    protected byte[] bddPath = null;
    public static final byte DONTCARE = 2;
    public static final byte TRUE = 1;
    public static final byte FALSE = 0;

    public void dfs(BDD bdd2) {
        this.path.clear();
        this.bddPath = new byte[bdd2.getFactory().varNum()];
        Arrays.fill(this.bddPath, (byte)2);
        this.dfsTraversal(bdd2);
        this.onTraversalDone();
    }

    protected byte[] getSolution() {
        return this.bddPath;
    }

    protected Set<String> getPath() {
        return this.path;
    }

    public boolean searchStopped() {
        return false;
    }

    private void dfsTraversal(BDD bdd2) {
        if (!this.searchStopped()) {
            if (bdd2.isOne()) {
                this.onOneTerminalFound(this.path, this.bddPath);
            } else if (bdd2.isZero()) {
                this.onZeroTerminalFound(this.path, this.bddPath);
            } else {
                String pathEntry;
                this.onVisitingNode(bdd2, this.path, this.bddPath);
                BDD firstNode = bdd2.low();
                BDD secondNode = bdd2.high();
                boolean polarity = false;
                if (!this.visitLowNodeFirst(bdd2)) {
                    firstNode = bdd2.high();
                    secondNode = bdd2.low();
                    polarity = true;
                }
                if (!this.searchStopped()) {
                    if (this.canVisitNode(bdd2, polarity)) {
                        pathEntry = bdd2.var() + ":" + polarity;
                        this.path.add(pathEntry);
                        this.bddPath[bdd2.var()] = polarity ? (byte)1 : 0;
                        this.dfsTraversal(firstNode);
                        this.bddPath[bdd2.var()] = 2;
                        this.path.remove(pathEntry);
                    } else {
                        this.onSkippedNode(bdd2, polarity, this.path, this.bddPath);
                    }
                }
                if (!this.searchStopped()) {
                    if (this.canVisitNode(bdd2, !polarity)) {
                        pathEntry = bdd2.var() + ":" + !polarity;
                        this.path.add(pathEntry);
                        this.bddPath[bdd2.var()] = !polarity ? (byte)1 : 0;
                        this.dfsTraversal(secondNode);
                        this.bddPath[bdd2.var()] = 2;
                        this.path.remove(pathEntry);
                    } else {
                        this.onSkippedNode(bdd2, !polarity, this.path, this.bddPath);
                    }
                }
                this.onVisitedNode(bdd2, this.path, this.bddPath);
                bdd2.free();
            }
        }
    }

    public void onVisitingNode(BDD bddNode, Set<String> path, byte[] solution) {
    }

    public void onVisitedNode(BDD bddNode, Set<String> path, byte[] solution) {
    }

    public void onZeroTerminalFound(Set<String> path, byte[] solution) {
    }

    public void onOneTerminalFound(Set<String> path, byte[] solution) {
    }

    public boolean canVisitNode(BDD bddNode, boolean polarity) {
        return true;
    }

    public void onSkippedNode(BDD bdNode, boolean polarity, Set<String> path, byte[] solution) {
    }

    public boolean visitLowNodeFirst(BDD bddNode) {
        return true;
    }

    public void onTraversalDone() {
    }
}

