/*
 * Decompiled with CFR 0.152.
 */
package splar.plugins.reasoners.bdd.javabdd;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDFactory;
import splar.core.constraints.CNFFormula;
import splar.core.fm.FeatureGroup;
import splar.core.fm.FeatureModel;
import splar.core.fm.FeatureTreeNode;
import splar.core.fm.GroupedFeature;
import splar.core.fm.SolitaireFeature;
import splar.core.fm.reasoning.FMReasoningException;
import splar.core.heuristics.VariableOrderingHeuristic;
import splar.plugins.reasoners.bdd.javabdd.BDDExceededBuildingTimeException;
import splar.plugins.reasoners.bdd.javabdd.BDDGenerationStatistics;
import splar.plugins.reasoners.bdd.javabdd.BDDTraversalNodeDFS;
import splar.plugins.reasoners.bdd.javabdd.ReasoningWithBDD;

public class FTReasoningWithBDD
extends ReasoningWithBDD {
    public static final String BEST_VARIABLE_ORDER = "Best-Variable-Order";
    public static final String WORST_VARIABLE_ORDER = "Worst-Variable-Order";
    protected FeatureModel featureModel;
    private BDDGenerationStatistics bddStats;
    private String searchType;
    byte[][] domainTable;
    int unknownDomains;
    boolean debug = false;

    public FTReasoningWithBDD(FeatureModel featureModel, VariableOrderingHeuristic voHeuristic, int nodeNum, int cacheSize, long maxBuildingtime, String orderingFormulasStrategy) {
        this(featureModel, voHeuristic, nodeNum, cacheSize, maxBuildingtime, BDDFactory.REORDER_NONE, orderingFormulasStrategy);
    }

    public FTReasoningWithBDD(FeatureModel featureModel, VariableOrderingHeuristic voHeuristic, int nodeNum, int cacheSize, long maxBuildingtime, BDDFactory.ReorderMethod reorderMethod, String orderingFormulasStrategy) {
        super(voHeuristic, nodeNum, cacheSize, maxBuildingtime, reorderMethod, orderingFormulasStrategy);
        this.featureModel = featureModel;
        this.searchType = null;
        this.bddFactory.setVarNum(this.getFeatureModel().countNodes());
    }

    public FTReasoningWithBDD(FeatureModel featureModel, int nodeNum, int cacheSize, String searchType, long maxBuildingtime, String orderingFormulasStrategy) {
        this(featureModel, nodeNum, cacheSize, searchType, maxBuildingtime, BDDFactory.REORDER_NONE, orderingFormulasStrategy);
    }

    public FTReasoningWithBDD(FeatureModel featureModel, int nodeNum, int cacheSize, String searchType, long maxBuildingtime, BDDFactory.ReorderMethod reorderMethod, String orderingFormulasStrategy) {
        super(null, nodeNum, cacheSize, maxBuildingtime, reorderMethod, orderingFormulasStrategy);
        this.featureModel = featureModel;
        this.searchType = searchType;
    }

    @Override
    public void init() throws Exception {
        super.init();
        long start = System.currentTimeMillis();
        this.setInitialBDDState(start - ((long)this.getHeuristicRunningTime() + this.bddBuildingTime));
        this.bddBuildingTime += System.currentTimeMillis() - start;
    }

    protected void setInitialBDDState(long start) throws Exception {
        this.variables = this.initVars(this.theOriginalBDD.getFactory().varNum());
    }

    @Override
    public void saveState(String stateID) {
        super.saveState(stateID);
        this.featureModel.saveState(stateID);
    }

    @Override
    public void restoreState(String stateID) {
        super.restoreState(stateID);
        this.featureModel.restoreState(stateID);
    }

    @Override
    public void discardState(String stateID) {
        super.discardState(stateID);
        this.featureModel.discardState(stateID);
    }

    @Override
    protected BDD createBDD(BDDFactory bddFactory, String orderingFormulasStrategy) throws Exception {
        if (this.reorderMethod != BDDFactory.REORDER_NONE) {
            super.initBDDReorder(this.getFeatureModel().countNodes());
        }
        BDD bdd2 = null;
        long start = System.currentTimeMillis();
        if (this.searchType != null) {
            if (this.searchType == BEST_VARIABLE_ORDER || this.searchType == WORST_VARIABLE_ORDER) {
                bdd2 = this.createBDDBasedOnStatistics(this.searchType);
                this.heuristicRunningTime = 0L;
            }
        } else if (this.variableOrderingHeuristic != null) {
            this.varIndex2NameMap = this.variableOrderingHeuristic.run(this.toCNF());
            this.varName2IndexMap = VariableOrderingHeuristic.variableOrderingAsHashMap(this.varIndex2NameMap);
            bdd2 = this.createBDDStructure(start - (long)this.getHeuristicRunningTime(), orderingFormulasStrategy);
        }
        bdd2.andWith(bddFactory.ithVar((Integer)this.varName2IndexMap.get(this.featureModel.getRoot().getID())));
        this.bddBuildingTime = System.currentTimeMillis() - start;
        return bdd2;
    }

    protected CNFFormula toCNF() {
        return this.featureModel.FT2CNF();
    }

    protected BDD createBDDBasedOnStatistics(String searchType) throws Exception {
        int countFMNodes = this.getFeatureModel().countNodes();
        this.varName2IndexMap = new HashMap();
        this.varIndex2NameMap = new String[countFMNodes];
        this.generateBDDStatistics();
        int searchTypeIndex = -1;
        if (searchType.compareToIgnoreCase(BEST_VARIABLE_ORDER) == 0) {
            searchTypeIndex = this.bddStats.getBestVariableOrderIndex();
        } else if (searchType.compareToIgnoreCase(WORST_VARIABLE_ORDER) == 0) {
            searchTypeIndex = this.bddStats.getWorstVariableOrderIndex();
        }
        String[] varOrder = this.bddStats.getVariableOrder(searchTypeIndex);
        for (int i = 0; i < varOrder.length; ++i) {
            this.varName2IndexMap.put(varOrder[i], i);
            this.varIndex2NameMap[i] = varOrder[i];
        }
        return this.bddStats.getBDD(searchTypeIndex);
    }

    private void generateBDDStatistics() throws Exception {
        Vector<String> variables = new Vector<String>();
        for (FeatureTreeNode node : this.featureModel.getNodes()) {
            if (node instanceof GroupedFeature) continue;
            variables.add(node.getID());
        }
        this.bddStats = null;
        String[] strVariables = variables.toArray(new String[0]);
        this.genBDDStats(strVariables, null, 0, System.currentTimeMillis());
    }

    private void genBDDStats(String[] theVariables, int[] index, int level, long start) throws Exception {
        int i;
        if (System.currentTimeMillis() - start > this.maxBuildingTime) {
            throw new BDDExceededBuildingTimeException("FTReasoningWithBDD: Maximum time allowed for BDD construction exceeded: " + this.maxBuildingTime + " ms", "");
        }
        if (index == null) {
            index = new int[theVariables.length];
            for (i = 0; i < index.length; ++i) {
                index[i] = -1;
            }
        }
        if (level == theVariables.length) {
            int expandIndex = 0;
            for (int j = 0; j < index.length; ++j) {
                FeatureTreeNode node = this.featureModel.getNodeByID(theVariables[index[j]]);
                if (node instanceof FeatureGroup) {
                    FeatureGroup group = (FeatureGroup)node;
                    int groupChildCount = group.getChildCount();
                    for (int k = 0; k < groupChildCount; ++k) {
                        FeatureTreeNode childNode = (FeatureTreeNode)group.getChildAt(k);
                        this.varName2IndexMap.put(childNode.getID(), expandIndex + j + k);
                        this.varIndex2NameMap[expandIndex + j + k] = childNode.getID();
                    }
                    expandIndex += groupChildCount - 1;
                    continue;
                }
                this.varName2IndexMap.put(theVariables[index[j]], j + expandIndex);
                this.varIndex2NameMap[j + expandIndex] = theVariables[index[j]];
            }
            try {
                this.theWorkingBDD = this.theOriginalBDD = this.createBDDStructure(start, this.orderingFormulasStrategy);
                this.setInitialBDDState(start);
                if (this.bddStats == null) {
                    this.bddStats = new BDDGenerationStatistics(theVariables.length);
                }
                this.bddStats.addStats(this.bddFactory, this.theWorkingBDD, this.varIndex2NameMap);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            for (i = 0; i < theVariables.length; ++i) {
                if (index[i] != -1) continue;
                index[i] = level;
                this.genBDDStats(theVariables, index, level + 1, start);
                index[i] = -1;
            }
        }
    }

    protected BDD createBDDStructure(long startTime, String orderingFormulasStrategy) throws BDDExceededBuildingTimeException {
        if (orderingFormulasStrategy.compareToIgnoreCase("level-order") == 0) {
            return this.levelOrderFormulaOrdering(startTime);
        }
        return this.preOrderFormulaOrdering(startTime);
    }

    protected BDD preOrderFormulaOrdering(long startTime) throws BDDExceededBuildingTimeException {
        return this.preOrderFormulaOrderingRec(this.featureModel.getRoot(), startTime);
    }

    protected BDD preOrderFormulaOrderingRec(FeatureTreeNode curNode, long startTime) throws BDDExceededBuildingTimeException {
        BDD bdd2 = this.bddFactory.one();
        BDD parentNodeBDD = this.bddFactory.ithVar((Integer)this.varName2IndexMap.get(curNode.getID()));
        int count = curNode.getChildCount();
        if (count > 0) {
            BDD childBDD = null;
            for (int i = 0; i < count; ++i) {
                FeatureTreeNode childNode = (FeatureTreeNode)curNode.getChildAt(i);
                if (childNode instanceof SolitaireFeature) {
                    SolitaireFeature solitaireNode = (SolitaireFeature)childNode;
                    childBDD = this.bddFactory.ithVar((Integer)this.varName2IndexMap.get(childNode.getID()));
                    if (solitaireNode.isOptional()) {
                        bdd2.andWith(childBDD.imp(parentNodeBDD.id()));
                    } else {
                        bdd2.andWith(childBDD.biimp(parentNodeBDD.id()));
                    }
                    BDD subtreeBDD = this.preOrderFormulaOrderingRec(childNode, startTime);
                    bdd2.andWith(subtreeBDD);
                    continue;
                }
                if (childNode instanceof FeatureGroup) {
                    FeatureGroup fGroup = (FeatureGroup)childNode;
                    BDD fgBDD = this.createFeatureGroupBDDStructure(parentNodeBDD.id(), fGroup, null, this.bddFactory, startTime);
                    bdd2.andWith(fgBDD);
                    for (int j = 0; j < fGroup.getChildCount(); ++j) {
                        FeatureTreeNode groupedNode = (FeatureTreeNode)fGroup.getChildAt(j);
                        BDD subtreeBDD = this.preOrderFormulaOrderingRec(groupedNode, startTime);
                        bdd2.andWith(subtreeBDD);
                    }
                    continue;
                }
                System.out.println("Error: Other type of node!");
            }
        }
        return bdd2;
    }

    protected BDD levelOrderFormulaOrdering(long startTime) throws BDDExceededBuildingTimeException {
        BDD bdd2 = this.bddFactory.one();
        Vector<FeatureTreeNode> nodes = new Vector<FeatureTreeNode>();
        nodes.add(this.getFeatureModel().getRoot());
        while (nodes.size() > 0) {
            if (System.currentTimeMillis() - startTime > this.maxBuildingTime) {
                throw new BDDExceededBuildingTimeException("PF2BDDParser: Maximum time allowed for BDD construction exceeded: " + this.maxBuildingTime + " ms", "");
            }
            FeatureTreeNode curNode = (FeatureTreeNode)nodes.firstElement();
            nodes.remove(curNode);
            if (curNode == null) continue;
            BDD nodeBDD = null;
            nodeBDD = this.bddFactory.ithVar((Integer)this.varName2IndexMap.get(curNode.getID()));
            int count = curNode.getChildCount();
            if (count <= 0) continue;
            BDD childBDD = null;
            for (int i = 0; i < count; ++i) {
                FeatureTreeNode childNode = (FeatureTreeNode)curNode.getChildAt(i);
                if (childNode instanceof SolitaireFeature) {
                    nodes.add(childNode);
                    SolitaireFeature solitaireNode = (SolitaireFeature)childNode;
                    childBDD = this.bddFactory.ithVar((Integer)this.varName2IndexMap.get(childNode.getID()));
                    if (solitaireNode.isOptional()) {
                        bdd2.andWith(childBDD.imp(nodeBDD.id()));
                        continue;
                    }
                    bdd2.andWith(childBDD.biimp(nodeBDD.id()));
                    continue;
                }
                if (childNode instanceof FeatureGroup) {
                    FeatureGroup fGroup = (FeatureGroup)childNode;
                    bdd2.andWith(this.createFeatureGroupBDDStructure(nodeBDD.id(), fGroup, nodes, this.bddFactory, startTime));
                    continue;
                }
                System.out.println("Error: Other type of node!");
            }
        }
        bdd2.andWith(this.bddFactory.ithVar((Integer)this.varName2IndexMap.get(this.getFeatureModel().getRoot().getID())).id().or(this.bddFactory.zero()));
        return bdd2;
    }

    protected BDD createFeatureGroupBDDStructure(BDD parentBDD, FeatureGroup node, Vector<FeatureTreeNode> nodes, BDDFactory bddFactory, long start) throws BDDExceededBuildingTimeException {
        BDD bdd2 = null;
        int childCount = node.getChildCount();
        if (childCount > 0) {
            int min = node.getMin();
            int max = node.getMax();
            FeatureTreeNode tempNode1 = null;
            FeatureTreeNode tempNode2 = null;
            if (min == 1 && max == -1) {
                tempNode1 = (FeatureTreeNode)node.getChildAt(0);
                bdd2 = bddFactory.ithVar((Integer)this.varName2IndexMap.get(tempNode1.getID()));
                for (int i = 1; i < childCount; ++i) {
                    if (System.currentTimeMillis() - start > this.maxBuildingTime) {
                        throw new BDDExceededBuildingTimeException("PF2BDDParser: Maximum time allowed for BDD construction exceeded: " + this.maxBuildingTime + " ms", "");
                    }
                    tempNode2 = (FeatureTreeNode)node.getChildAt(i);
                    if (nodes != null) {
                        nodes.add(tempNode1);
                    }
                    BDD bdd22 = bddFactory.ithVar((Integer)this.varName2IndexMap.get(tempNode2.getID()));
                    bdd2.orWith(bdd22);
                }
                bdd2.biimpWith(parentBDD);
                if (nodes != null) {
                    nodes.add(tempNode2);
                }
            } else if (min == max && min == 1) {
                bdd2 = bddFactory.one();
                for (int i = 0; i < childCount; ++i) {
                    tempNode1 = (FeatureTreeNode)node.getChildAt(i);
                    if (nodes != null) {
                        nodes.add(tempNode1);
                    }
                    BDD bdd1 = bddFactory.ithVar((Integer)this.varName2IndexMap.get(tempNode1.getID()));
                    BDD bdd23 = bddFactory.zero();
                    for (int j = 0; j < childCount; ++j) {
                        if (System.currentTimeMillis() - start > this.maxBuildingTime) {
                            throw new BDDExceededBuildingTimeException("PF2BDDParser: Maximum time allowed for BDD construction exceeded: " + this.maxBuildingTime + " ms", "");
                        }
                        if (i == j) continue;
                        tempNode2 = (FeatureTreeNode)node.getChildAt(j);
                        bdd23.orWith(bddFactory.ithVar((Integer)this.varName2IndexMap.get(tempNode2.getID())).id());
                    }
                    bdd2.andWith(bdd23.not().and(parentBDD).biimp(bdd1));
                }
            }
        }
        return bdd2;
    }

    public FeatureModel getFeatureModel() {
        return this.featureModel;
    }

    @Override
    public Map<String, Boolean[]> allValidDomains(Map<String, String> stats) throws FMReasoningException {
        try {
            this.domainTable = new byte[this.getFeatureModel().countFeatures()][2];
            this.unknownDomains = this.domainTable.length * 2;
            for (int i = 0; i < this.domainTable.length; ++i) {
                String varName = this.getVariableName(i);
                FeatureTreeNode varNode = this.getFeatureModel().getNodeByID(varName);
                if (varNode != null && varNode.isInstantiated()) {
                    this.domainTable[i][varNode.getValue()] = 2;
                    this.domainTable[i][1 - varNode.getValue()] = 3;
                    this.unknownDomains -= 2;
                    continue;
                }
                this.domainTable[i][0] = 1;
                this.domainTable[i][1] = 1;
            }
            if (this.debug) {
                this.debugDomainTable(false);
            }
            BDDTraversalNodeDFS traversal = new BDDTraversalNodeDFS(){
                int lastLevelChecked = 0;
                int visitedNodes = 0;

                @Override
                public boolean searchStopped() {
                    return FTReasoningWithBDD.this.unknownDomains == 0;
                }

                private String varLabel(BDD bddNode) {
                    if (bddNode.isOne()) {
                        return "1T";
                    }
                    if (bddNode.isZero()) {
                        return "0T";
                    }
                    return "" + bddNode.var();
                }

                private void updateDomainTable(BDDFactory factory, int startLevel, int endLevel) {
                    for (int i = startLevel; i > endLevel; --i) {
                        int varIndex;
                        if (FTReasoningWithBDD.this.debug) {
                            System.out.println("  updating [level=" + i + ",var=" + factory.level2Var(i) + "] name=" + FTReasoningWithBDD.this.getVariableName(factory.level2Var(i)));
                        }
                        if (FTReasoningWithBDD.this.domainTable[varIndex = factory.level2Var(i)][0] == 1) {
                            FTReasoningWithBDD.this.domainTable[varIndex][0] = 2;
                            --FTReasoningWithBDD.this.unknownDomains;
                        }
                        if (FTReasoningWithBDD.this.domainTable[varIndex][1] != 1) continue;
                        FTReasoningWithBDD.this.domainTable[varIndex][1] = 2;
                        --FTReasoningWithBDD.this.unknownDomains;
                    }
                }

                @Override
                public void onOneTerminalFound(Set<String> path, byte[] solution) {
                    this.updateDomainTable(FTReasoningWithBDD.this.getBDDFactory(), FTReasoningWithBDD.this.domainTable.length - 1, this.lastLevelChecked);
                    super.onOneTerminalFound(path, solution);
                }

                @Override
                public void onVisitingNode(BDD bddNode, Set<String> path, byte[] solution) {
                    if (!bddNode.isZero() && !bddNode.isOne()) {
                        BDDFactory factory = bddNode.getFactory();
                        if (FTReasoningWithBDD.this.debug) {
                            System.out.println(++this.visitedNodes + ": visiting- [level=" + factory.var2Level(bddNode.var()) + ",var=" + bddNode.var() + "] " + FTReasoningWithBDD.this.getVariableName(bddNode.var()) + "(" + this.varLabel(bddNode.low()) + "," + this.varLabel(bddNode.high()) + ")");
                        }
                        if (FTReasoningWithBDD.this.debug) {
                            System.out.println("      last visited level: " + this.lastLevelChecked);
                        }
                        int currentVar = bddNode.var();
                        this.updateDomainTable(bddNode.getFactory(), factory.var2Level(currentVar) - 1, this.lastLevelChecked);
                        BDD low = bddNode.low();
                        BDD high = bddNode.high();
                        if (!low.isZero() && FTReasoningWithBDD.this.domainTable[currentVar][0] == 1) {
                            FTReasoningWithBDD.this.domainTable[currentVar][0] = 2;
                            --FTReasoningWithBDD.this.unknownDomains;
                        }
                        if (!high.isZero() && FTReasoningWithBDD.this.domainTable[currentVar][1] == 1) {
                            FTReasoningWithBDD.this.domainTable[currentVar][1] = 2;
                            --FTReasoningWithBDD.this.unknownDomains;
                        }
                        low.free();
                        high.free();
                        if (FTReasoningWithBDD.this.debug) {
                            FTReasoningWithBDD.this.debugDomainTable(false);
                        }
                    }
                }

                @Override
                public boolean canVisitNode(BDD bddNode, boolean polarity) {
                    this.lastLevelChecked = FTReasoningWithBDD.this.getBDDFactory().var2Level(bddNode.var());
                    if (!super.canVisitNode(bddNode, polarity)) {
                        BDD nextNode = polarity ? bddNode.high() : bddNode.low();
                        this.updateDomainTable(FTReasoningWithBDD.this.getBDDFactory(), FTReasoningWithBDD.this.getBDDFactory().var2Level(nextNode.var()) - 1, this.lastLevelChecked);
                        nextNode.free();
                        return false;
                    }
                    return true;
                }

                @Override
                public void onSkippedNode(BDD bddNode, boolean polarity, Set<String> path, byte[] bddPath) {
                }
            };
            traversal.dfs(this.getBDD().id());
            for (int i = 0; i < this.domainTable.length; ++i) {
                if (this.domainTable[i][0] == 1) {
                    this.domainTable[i][0] = 3;
                }
                if (this.domainTable[i][1] != 1) continue;
                this.domainTable[i][1] = 3;
            }
            HashMap<String, Boolean[]> allDomains = new HashMap<String, Boolean[]>();
            for (int i = 0; i < this.domainTable.length; ++i) {
                LinkedList<Boolean> domain = new LinkedList<Boolean>();
                if (this.domainTable[i][0] == 2) {
                    domain.add(false);
                }
                if (this.domainTable[i][1] == 2) {
                    domain.add(true);
                }
                allDomains.put(this.getVariableName(i), domain.toArray(new Boolean[0]));
            }
            return allDomains;
        }
        catch (Exception e) {
            throw new FMReasoningException(e);
        }
    }

    public void debugDomainTable(boolean breakLine) {
        System.out.println("Unknown domains: " + this.unknownDomains);
        System.out.println("Domain Table ---------------------------");
        int varIndex = 0;
        for (byte[] varDomain : this.domainTable) {
            System.out.print(this.getVariableName(varIndex++) + ":[" + (varDomain[0] == 2 ? "0," : "") + (varDomain[1] == 2 ? "1" : "") + "] ");
            if (!breakLine) continue;
            System.out.println();
        }
        System.out.println();
    }
}

