/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.orders;

import java.io.PrintWriter;
import java.util.Random;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.IPhaseSelectionStrategy;
import org.sat4j.minisat.orders.VarOrderHeap;

public class RandomWalkDecorator
implements IOrder {
    private final VarOrderHeap decorated;
    private double p;
    private static final Random rand = new Random();
    private ILits voc;
    private int nbRandomWalks;

    public RandomWalkDecorator(VarOrderHeap varOrderHeap) {
        this(varOrderHeap, 0.01);
    }

    public RandomWalkDecorator(VarOrderHeap varOrderHeap, double d) {
        this.decorated = varOrderHeap;
        this.p = d;
    }

    public void assignLiteral(int n) {
        this.decorated.assignLiteral(n);
    }

    public IPhaseSelectionStrategy getPhaseSelectionStrategy() {
        return this.decorated.getPhaseSelectionStrategy();
    }

    public double getProbability() {
        return this.p;
    }

    public void setProbability(double d) {
        this.p = d;
    }

    public void init() {
        this.decorated.init();
    }

    public void printStat(PrintWriter printWriter, String string) {
        printWriter.println(string + "random walks\t: " + this.nbRandomWalks);
        this.decorated.printStat(printWriter, string);
    }

    public int select() {
        if (rand.nextDouble() < this.p) {
            while (!this.decorated.heap.empty()) {
                int n = this.decorated.heap.size();
                int n2 = this.decorated.heap.get(rand.nextInt(n) + 1);
                int n3 = this.getPhaseSelectionStrategy().select(n2);
                if (!this.voc.isUnassigned(n3)) continue;
                ++this.nbRandomWalks;
                return n3;
            }
        }
        return this.decorated.select();
    }

    public void setLits(ILits iLits) {
        this.decorated.setLits(iLits);
        this.voc = iLits;
        this.nbRandomWalks = 0;
    }

    public void setPhaseSelectionStrategy(IPhaseSelectionStrategy iPhaseSelectionStrategy) {
        this.decorated.setPhaseSelectionStrategy(iPhaseSelectionStrategy);
    }

    public void setVarDecay(double d) {
        this.decorated.setVarDecay(d);
    }

    public void undo(int n) {
        this.decorated.undo(n);
    }

    public void updateVar(int n) {
        this.decorated.updateVar(n);
    }

    public double varActivity(int n) {
        return this.decorated.varActivity(n);
    }

    public void varDecayActivity() {
        this.decorated.varDecayActivity();
    }

    public void updateVarAtDecisionLevel(int n) {
        this.decorated.updateVarAtDecisionLevel(n);
    }

    public String toString() {
        return this.decorated.toString() + " with random walks " + this.p;
    }

    public double[] getVariableHeuristics() {
        return this.decorated.getVariableHeuristics();
    }
}

