
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;

public class ExtractBranchStatements {

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {

        try {
            switch (args[0]) {
                case "branch":
                    for (int i = 1; i <= countLines(args[1]); i++) {
                        Test t = new Test(i);
                        PrintBranchsTestGcov(t, args[2] + "test" + i, i);
                    }
                    break;
                case "statement":
                    for (int i = 1; i <= countLines(args[1]); i++) {
                        Test t = new Test(i);
                        PrintStatementsTestGcov(t, args[2] + "test" + i, i);
                    }
                break;
                default:
                    printUsage();
                    break;
            }
        } catch (Exception ex) {
            printUsage();
            ex.printStackTrace();
        };
    }

    public static void printUsage() {
        System.out.println("java -jar ExtractBranchStatements branch testSuiteFile gcovFilesDir");
        System.out.println("java -jar ExtractBranchStatements statement testSuiteFile gcovFilesDir");
    }

    public static void PrintBranchsTestGcov(Test test, String dir, int testIndex) {
        Set<String> branchCovered = new HashSet<String>();

        File[] files = new File(dir).listFiles();
        if (files.length > 0) {
            for (File f : files) {
                try {

                    String fname = f.getAbsolutePath().substring(f.getAbsolutePath().lastIndexOf("/") + 1);

                    BufferedReader in = new BufferedReader(new FileReader(f));

                    String line;
                    int lineN = 1;
                    while ((line = in.readLine()) != null) {
                        line = line.trim();
                        if (line.startsWith("branch")) {
                            if (line.contains("taken ") && !line.contains("taken 0")) {
                                branchCovered.add(fname + ":branch" + lineN);
                                System.out.println(fname + ":branch" + lineN + " " + testIndex);
                            }

                        }
                        lineN++;
                    }

                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }

        }
        test.setBranch(branchCovered);
    }

    public static void PrintStatementsTestGcov(Test test, String dir, int testIndex) {
        File[] files = new File(dir).listFiles();
        if (files.length > 0) {
            for (File f : files) {
                try {

                    String fname = f.getAbsolutePath().substring(f.getAbsolutePath().lastIndexOf("/") + 1);

                    BufferedReader in = new BufferedReader(new FileReader(f));

                    String line;
                    int lineN = 1;
                    while ((line = in.readLine()) != null) {
                        line = line.trim();
                        if (!line.isEmpty() && !line.startsWith("-") && !line.startsWith("funct") && !line.startsWith("branch") && !line.startsWith("call")) {

                            if (!line.startsWith("#") && !line.startsWith("0")) {
                                System.out.println(fname + ":instr" + lineN + " " + testIndex);
                            }
                        }
                        lineN++;
                    }

                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }

        }
    }

    public static int countLines(String file) {
        int totalNumberOfLines = 0;
        try {

            LineNumberReader lineReader = new LineNumberReader(new FileReader(Paths
                    .get(file).toFile()));
            lineReader.skip(Long.MAX_VALUE);

            totalNumberOfLines = lineReader.getLineNumber();

            lineReader.close();
        } catch (Exception ex) {
            ex.printStackTrace();
        }

        return totalNumberOfLines;
    }

}
