/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.math3.util.ArithmeticUtils;
import org.at4j.comp.bzip2.BZip2EncoderExecutorService;
import org.at4j.comp.bzip2.BZip2OutputStream;
import org.at4j.comp.bzip2.BZip2OutputStreamSettings;

public class Prioritization {
    public static void main(String[] args) {
        try {
            ArrayList<Test> tests = new ArrayList<Test>();
            List<Test> prioritizedTests = null;
            double[][] dist = null;
            switch (args[0]) {
                case "TS": 
                case "AS": 
                case "TB": 
                case "AB": 
                case "TM": 
                case "AM": {
                    for (int i = 1; i <= Prioritization.countLines(args[1]); ++i) {
                        Test t = new Test(i);
                        Prioritization.loadTestGcov(t, args[2] + "test" + i);
                        tests.add(t);
                    }
                    break;
                }
                case "ASS": {
                    List<String> statements = Prioritization.loadSpanningStatements(args[3]);
                    for (int i = 1; i <= Prioritization.countLines(args[1]); ++i) {
                        Test t = new Test(i);
                        Prioritization.loadTestGcovSpanningStatements(t, args[2] + "test" + i, statements);
                        tests.add(t);
                    }
                    break;
                }
                case "ASB": {
                    Test t;
                    List<String> branches = Prioritization.loadSpanningBranches(args[3]);
                    for (int i = 1; i <= Prioritization.countLines(args[1]); ++i) {
                        t = new Test(i);
                        Prioritization.loadTestGcovSpanningBranches(t, args[2] + "test" + i, branches);
                        tests.add(t);
                    }
                    break;
                }
                case "SD": 
                case "BD": {
                    String line;
                    Test t;
                    for (int i = 1; i <= Prioritization.countLines(args[1]); ++i) {
                        t = new Test(i);
                        tests.add(t);
                    }
                    HashSet<String> branchesStatements = new HashSet<String>();
                    ArrayList testBranchesStatements = new ArrayList();
                    int nTests = Prioritization.countLines(args[1]);
                    for (int i = 0; i < nTests; ++i) {
                        testBranchesStatements.add(new HashSet());
                    }
                    BufferedReader in = new BufferedReader(new FileReader(args[2]));
                    while ((line = in.readLine()) != null) {
                        StringTokenizer st = new StringTokenizer(line, " ");
                        String statementBranch = st.nextToken();
                        int ti = Integer.parseInt(st.nextToken());
                        ((Set)testBranchesStatements.get(ti - 1)).add(statementBranch);
                        branchesStatements.add(statementBranch);
                    }
                    in.close();
                    HashMap<String, Integer> branchesStatementsMap = new HashMap<String, Integer>();
                    int k = 1;
                    for (String s : branchesStatements) {
                        branchesStatementsMap.put(s, k);
                        ++k;
                    }
                    ArrayList<Set<Integer>> testsIndices = new ArrayList<Set<Integer>>();
                    for (Set set : testBranchesStatements) {
                        testsIndices.add(Prioritization.testStringtoInt(set, branchesStatements, branchesStatementsMap));
                    }
                    dist = new double[testsIndices.size()][testsIndices.size()];
                    for (int i = 0; i < testsIndices.size(); ++i) {
                        for (int j = 0; j < testsIndices.size(); ++j) {
                            double d;
                            if (j <= i) continue;
                            dist[i][j] = d = Prioritization.getJaccardDistance((Set)testsIndices.get(i), (Set)testsIndices.get(j));
                        }
                    }
                    break;
                }
                case "t-W": {
                    String line;
                    for (int i = 1; i <= Prioritization.countLines(args[1]); ++i) {
                        Test test = new Test(i);
                        tests.add(test);
                    }
                    HashMap<HashSet<Integer>, Integer> mapCasaTests = new HashMap<HashSet<Integer>, Integer>();
                    BufferedReader in = new BufferedReader(new FileReader(args[2]));
                    ArrayList<Set<Integer>> arrayList = new ArrayList<Set<Integer>>();
                    HashSet<HashSet<Integer>> tsets = new HashSet<HashSet<Integer>>();
                    HashMap<HashSet<Integer>, HashSet<HashSet<Integer>>> mapTestTSets = new HashMap<HashSet<Integer>, HashSet<HashSet<Integer>>>();
                    int strength = Integer.parseInt(args[3]);
                    int i = 0;
                    while ((line = in.readLine()) != null) {
                        StringTokenizer st = new StringTokenizer(line, " ");
                        HashSet<Integer> conf = new HashSet<Integer>();
                        while (st.hasMoreTokens()) {
                            conf.add(Integer.parseInt(st.nextToken()));
                        }
                        arrayList.add(conf);
                        mapCasaTests.put(conf, ((Test)tests.get(i)).getId());
                        HashSet<HashSet<Integer>> tsetsConf = Prioritization.getTSets(strength, conf);
                        mapTestTSets.put(conf, tsetsConf);
                        tsets.addAll(tsetsConf);
                        ++i;
                    }
                    in.close();
                    Collections.shuffle(arrayList);
                    ArrayList<Set<Integer>> prio = Prioritization.globalPrioConf(arrayList, tsets, strength, mapTestTSets);
                    prioritizedTests = new ArrayList<Test>();
                    for (Set<Integer> conf : prio) {
                        prioritizedTests.add(new Test((Integer)mapCasaTests.get(conf)));
                    }
                    break;
                }
                case "IMD": {
                    int i;
                    String line;
                    int nTests = Prioritization.countLines(args[1]);
                    for (int n = 1; n <= nTests; ++n) {
                        Test t = new Test(n);
                        tests.add(t);
                    }
                    BufferedReader in = new BufferedReader(new FileReader(args[2]));
                    ArrayList arrayList = new ArrayList();
                    while ((line = in.readLine()) != null) {
                        StringTokenizer st = new StringTokenizer(line, " ");
                        HashSet<Integer> conf = new HashSet<Integer>();
                        while (st.hasMoreTokens()) {
                            conf.add(Integer.parseInt(st.nextToken()));
                        }
                        arrayList.add(conf);
                    }
                    in.close();
                    dist = new double[nTests][nTests];
                    for (i = 0; i < nTests; ++i) {
                        for (int j = 0; j < nTests; ++j) {
                            double d;
                            if (j <= i) continue;
                            dist[i][j] = d = Prioritization.getJaccardDistance((Set)arrayList.get(i), (Set)arrayList.get(j));
                        }
                    }
                    break;
                }
                case "TIMM": 
                case "AIMM": {
                    int i;
                    for (i = 1; i <= Prioritization.countLines(args[1]); ++i) {
                        Test t = new Test(i);
                        Prioritization.loadTestInputModelMutant(t, args[2], i);
                        tests.add(t);
                    }
                    break;
                }
                case "MiOD": 
                case "MaOD": {
                    int i;
                    int nTests = Prioritization.countLines(args[1]);
                    for (int n = 1; n <= nTests; ++n) {
                        Test t = new Test(n);
                        tests.add(t);
                    }
                    ArrayList<String> outputs = new ArrayList<String>();
                    ArrayList<Integer> coutputs = new ArrayList<Integer>();
                    for (i = 1; i <= nTests; ++i) {
                        try {
                            String out = FileUtils.readFileToString(new File(args[2] + "output_v0_" + i));
                            outputs.add(out);
                            coutputs.add(Prioritization.compress(out));
                            continue;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    dist = new double[nTests][nTests];
                    for (i = 0; i < outputs.size(); ++i) {
                        for (int j = 0; j < outputs.size(); ++j) {
                            double d;
                            if (j <= i) continue;
                            dist[i][j] = d = Prioritization.ncd((String)outputs.get(i), (String)outputs.get(j), (Integer)coutputs.get(i), (Integer)coutputs.get(j));
                        }
                    }
                    break;
                }
                case "ID-NCD": {
                    int i;
                    String line;
                    int nTests = Prioritization.countLines(args[1]);
                    for (int n = 1; n <= nTests; ++n) {
                        Test t = new Test(n);
                        tests.add(t);
                    }
                    ArrayList<String> inputs = new ArrayList<String>();
                    ArrayList<Integer> cinputs = new ArrayList<Integer>();
                    BufferedReader in = new BufferedReader(new FileReader(args[1]));
                    while ((line = in.readLine()) != null) {
                        inputs.add(line);
                        cinputs.add(Prioritization.compress(line));
                    }
                    in.close();
                    dist = new double[nTests][nTests];
                    for (i = 0; i < inputs.size(); ++i) {
                        for (int j = 0; j < inputs.size(); ++j) {
                            double d;
                            if (j <= i) continue;
                            dist[i][j] = d = Prioritization.ncd((String)inputs.get(i), (String)inputs.get(j), (Integer)cinputs.get(i), (Integer)cinputs.get(j));
                        }
                    }
                    break;
                }
                case "ID-Lev": {
                    int i;
                    String line;
                    int nTests = Prioritization.countLines(args[1]);
                    for (int n = 1; n <= nTests; ++n) {
                        Test t = new Test(n);
                        tests.add(t);
                    }
                    ArrayList<String> inputs = new ArrayList<String>();
                    ArrayList<Integer> cinputs = new ArrayList<Integer>();
                    BufferedReader in = new BufferedReader(new FileReader(args[1]));
                    while ((line = in.readLine()) != null) {
                        inputs.add(line);
                        cinputs.add(Prioritization.compress(line));
                    }
                    in.close();
                    dist = new double[nTests][nTests];
                    for (i = 0; i < inputs.size(); ++i) {
                        for (int j = 0; j < inputs.size(); ++j) {
                            double d;
                            if (j <= i) continue;
                            dist[i][j] = d = (double)Prioritization.getLevenshteinDistance((String)inputs.get(i), (String)inputs.get(j));
                        }
                    }
                    break;
                }
                case "I-TSD": {
                    String line;
                    int nTests = Prioritization.countLines(args[1]);
                    for (int n = 1; n <= nTests; ++n) {
                        Test t = new Test(n);
                        tests.add(t);
                    }
                    ArrayList<InOut> inputs_ = new ArrayList<InOut>();
                    int i = 1;
                    BufferedReader in = new BufferedReader(new FileReader(args[1]));
                    while ((line = in.readLine()) != null) {
                        inputs_.add(new InOut(i, line, Prioritization.compress(line)));
                        ++i;
                    }
                    in.close();
                    Collections.shuffle(inputs_);
                    List<Integer> prioritized = Prioritization.TSDmPrioritization(inputs_);
                    prioritizedTests = new ArrayList<Test>();
                    for (Integer i_ : prioritized) {
                        prioritizedTests.add(new Test(i_));
                    }
                    break;
                }
                case "O-TSD": {
                    int i;
                    int nTests = Prioritization.countLines(args[1]);
                    for (int n = 1; n <= nTests; ++n) {
                        Test t = new Test(n);
                        tests.add(t);
                    }
                    ArrayList<InOut> outputs_ = new ArrayList<InOut>();
                    for (i = 1; i <= nTests; ++i) {
                        String out = FileUtils.readFileToString(new File(args[2] + "output_v0_" + i));
                        InOut inout = new InOut(i, out, Prioritization.compress(out));
                        outputs_.add(inout);
                    }
                    Collections.shuffle(outputs_);
                    List<Integer> prioritized = Prioritization.TSDmPrioritization(outputs_);
                    prioritizedTests = new ArrayList<Test>();
                    for (Integer i_ : prioritized) {
                        prioritizedTests.add(new Test(i_));
                    }
                    break;
                }
                default: {
                    Prioritization.printUsage();
                }
            }
            Collections.shuffle(tests);
            switch (args[0]) {
                case "TS": {
                    prioritizedTests = Prioritization.prioritizeTotal(tests, "statement");
                    break;
                }
                case "AS": {
                    prioritizedTests = Prioritization.prioritizeAdditional(tests, "statement");
                    break;
                }
                case "TB": {
                    prioritizedTests = Prioritization.prioritizeTotal(tests, "branch");
                    break;
                }
                case "AB": {
                    prioritizedTests = Prioritization.prioritizeAdditional(tests, "branch");
                    break;
                }
                case "TM": {
                    prioritizedTests = Prioritization.prioritizeTotal(tests, "method");
                    break;
                }
                case "AM": {
                    prioritizedTests = Prioritization.prioritizeAdditional(tests, "method");
                    break;
                }
                case "ASS": {
                    prioritizedTests = Prioritization.prioritizeAdditional(tests, "statement");
                    break;
                }
                case "ASB": {
                    prioritizedTests = Prioritization.prioritizeAdditional(tests, "branch");
                    break;
                }
                case "SD": 
                case "BD": {
                    prioritizedTests = Prioritization.globalMaxDist(tests, dist, 1);
                    break;
                }
                case "t-W": 
                case "I-TSD": 
                case "O-TSD": {
                    break;
                }
                case "IMD": {
                    prioritizedTests = Prioritization.globalMaxDist(tests, dist, 1);
                    break;
                }
                case "TIMM": {
                    prioritizedTests = Prioritization.prioritizeAdditional(tests, "mutants");
                    break;
                }
                case "AIMM": {
                    prioritizedTests = Prioritization.prioritizeAdditional(tests, "mutants");
                    break;
                }
                case "MaOD": {
                    prioritizedTests = Prioritization.globalMinDist(tests, dist, 1);
                    break;
                }
                case "MiOD": {
                    prioritizedTests = Prioritization.globalMaxDist(tests, dist, 1);
                    break;
                }
                case "ID-NCD": 
                case "ID-Lev": {
                    prioritizedTests = Prioritization.globalMaxDist(tests, dist, 1);
                    break;
                }
            }
            for (Test test : prioritizedTests) {
                System.out.println(test.getId());
            }
        }
        catch (Exception ex) {
            Prioritization.printUsage();
            System.out.println("");
            ex.printStackTrace();
        }
    }

    public static void printUsage() {
        System.out.println("-----------------------------WB---------------------------------------");
        System.out.println("Usage: java -jar Prioritization.jar TS testSuiteFile gcovFilesDir");
        System.out.println("Usage: java -jar Prioritization.jar AS testSuiteFile gcovFilesDir");
        System.out.println("Usage: java -jar Prioritization.jar TB testSuiteFile gcovFilesDir");
        System.out.println("Usage: java -jar Prioritization.jar AB testSuiteFile gcovFilesDir");
        System.out.println("Usage: java -jar Prioritization.jar TM testSuiteFile gcovFilesDir");
        System.out.println("Usage: java -jar Prioritization.jar AM testSuiteFile gcovFilesDir");
        System.out.println("Usage: java -jar Prioritization.jar ASS testSuiteFile gcovFilesDir spanningStatementsFile");
        System.out.println("Usage: java -jar Prioritization.jar ASB testSuiteFile gcovFilesDir spanningBranchesFile");
        System.out.println("Usage: java -jar Prioritization.jar SD testSuiteFile statementMatrixFile");
        System.out.println("Usage: java -jar Prioritization.jar BD testSuiteFile branchMatrixFile");
        System.out.println("-----------------------------BB---------------------------------------");
        System.out.println("Usage: java -jar Prioritization.jar t-W testSuiteFile casaTestSuiteFile t");
        System.out.println("Usage: java -jar Prioritization.jar IMD testSuiteFile modelMutantsMatrixFile");
        System.out.println("Usage: java -jar Prioritization.jar TIMM testSuiteFile modelMutantsMatrixFile");
        System.out.println("Usage: java -jar Prioritization.jar AIMM testSuiteFile modelMutantsMatrixFile");
        System.out.println("Usage: java -jar Prioritization.jar MiOD testSuiteFile outputDir");
        System.out.println("Usage: java -jar Prioritization.jar MaOD testSuiteFile outputDir");
        System.out.println("Usage: java -jar Prioritization.jar ID-NCD testSuiteFile");
        System.out.println("Usage: java -jar Prioritization.jar ID-Lev testSuiteFile");
        System.out.println("Usage: java -jar Prioritization.jar I-TSD testSuiteFile");
        System.out.println("Usage: java -jar Prioritization.jar O-TSD testSuiteFile outputDir");
    }

    public static void loadTestGcov(Test test, String dir) {
        HashSet<String> methodsCovered = new HashSet<String>();
        HashSet<String> instrCovered = new HashSet<String>();
        HashSet<String> branchCovered = new HashSet<String>();
        File[] files = new File(dir).listFiles();
        if (files.length > 0) {
            for (File f : files) {
                try {
                    String line;
                    String fname = f.getAbsolutePath().substring(f.getAbsolutePath().lastIndexOf("/") + 1);
                    BufferedReader in = new BufferedReader(new FileReader(f));
                    int lineN = 1;
                    while ((line = in.readLine()) != null) {
                        if ((line = line.trim()).startsWith("branch")) {
                            if (line.contains("taken ") && !line.contains("taken 0")) {
                                branchCovered.add(fname + ":branch" + lineN);
                            }
                        } else if (line.startsWith("function")) {
                            if (!line.contains("called 0")) {
                                methodsCovered.add(fname + ":method" + lineN);
                            }
                        } else if (!(line.isEmpty() || line.startsWith("-") || line.startsWith("funct") || line.startsWith("branch") || line.startsWith("call") || line.startsWith("#") || line.startsWith("0"))) {
                            instrCovered.add(fname + ":instr" + lineN);
                        }
                        ++lineN;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        test.setMethods(methodsCovered);
        test.setBranch(branchCovered);
        test.setStatements(instrCovered);
    }

    public static List<Test> prioritizeAdditional(List<Test> tests, String type) {
        ArrayList<Test> prioritized = new ArrayList<Test>();
        ArrayList<Test> testsCopy = new ArrayList<Test>(tests);
        HashSet<String> covered = new HashSet<String>();
        while (!testsCopy.isEmpty()) {
            int max = -1;
            int toAdd = -1;
            for (int i = 0; i < testsCopy.size(); ++i) {
                HashSet<String> coveredcp = new HashSet<String>(covered);
                switch (type) {
                    case "branch": {
                        coveredcp.addAll(((Test)testsCopy.get(i)).getBranch());
                        break;
                    }
                    case "statement": {
                        coveredcp.addAll(((Test)testsCopy.get(i)).getStatements());
                        break;
                    }
                    case "method": 
                    case "mutants": {
                        coveredcp.addAll(((Test)testsCopy.get(i)).getMethods());
                        break;
                    }
                }
                if (coveredcp.size() <= max) continue;
                toAdd = i;
                max = coveredcp.size();
            }
            switch (type) {
                case "branch": {
                    covered.addAll(((Test)testsCopy.get(toAdd)).getBranch());
                    break;
                }
                case "statement": {
                    covered.addAll(((Test)testsCopy.get(toAdd)).getStatements());
                    break;
                }
                case "method": {
                    covered.addAll(((Test)testsCopy.get(toAdd)).getMethods());
                    break;
                }
            }
            prioritized.add((Test)testsCopy.get(toAdd));
            testsCopy.remove(toAdd);
        }
        return prioritized;
    }

    public static List<Test> prioritizeTotal(List<Test> tests, String type) {
        ArrayList<Test> prioritized = new ArrayList<Test>();
        ArrayList<Test> testsCopy = new ArrayList<Test>(tests);
        while (!testsCopy.isEmpty()) {
            int max = -1;
            int toAdd = -1;
            for (int i = 0; i < testsCopy.size(); ++i) {
                int size = -1;
                switch (type) {
                    case "branch": {
                        size = ((Test)testsCopy.get(i)).getBranch().size();
                        break;
                    }
                    case "statement": {
                        size = ((Test)testsCopy.get(i)).getStatements().size();
                        break;
                    }
                    case "method": {
                        size = ((Test)testsCopy.get(i)).getMethods().size();
                        break;
                    }
                }
                if (size <= max) continue;
                max = size;
                toAdd = i;
            }
            prioritized.add((Test)testsCopy.get(toAdd));
            testsCopy.remove(toAdd);
        }
        return prioritized;
    }

    public static int countLines(String file) {
        int totalNumberOfLines = 0;
        try {
            LineNumberReader lineReader = new LineNumberReader(new FileReader(Paths.get(file, new String[0]).toFile()));
            lineReader.skip(Long.MAX_VALUE);
            totalNumberOfLines = lineReader.getLineNumber();
            lineReader.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return totalNumberOfLines;
    }

    private static List<String> loadSpanningBranches(String file) {
        BufferedReader in = null;
        ArrayList<String> branches = new ArrayList<String>();
        try {
            String line;
            in = new BufferedReader(new FileReader(new File(file)));
            while ((line = in.readLine()) != null) {
                branches.add(line.trim());
            }
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return branches;
    }

    private static List<String> loadSpanningStatements(String file) {
        BufferedReader in = null;
        ArrayList<String> statements = new ArrayList<String>();
        try {
            String line;
            in = new BufferedReader(new FileReader(new File(file)));
            while ((line = in.readLine()) != null) {
                statements.add(line.trim());
            }
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return statements;
    }

    public static void loadTestGcovSpanningBranches(Test test, String dir, List<String> branches) {
        HashSet<String> branchCovered = new HashSet<String>();
        File[] files = new File(dir).listFiles();
        if (files.length > 0) {
            for (File f : files) {
                try {
                    String line;
                    String fname = f.getAbsolutePath().substring(f.getAbsolutePath().lastIndexOf("/") + 1);
                    BufferedReader in = new BufferedReader(new FileReader(f));
                    int lineN = 1;
                    while ((line = in.readLine()) != null) {
                        String b;
                        if ((line = line.trim()).startsWith("branch") && line.contains("taken ") && !line.contains("taken 0") && branches.contains(b = fname + ":branch" + lineN)) {
                            branchCovered.add(b);
                        }
                        ++lineN;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        test.setBranch(branchCovered);
    }

    public static void loadTestGcovSpanningStatements(Test test, String dir, List<String> statements) {
        HashSet<String> instrCovered = new HashSet<String>();
        File[] files = new File(dir).listFiles();
        if (files.length > 0) {
            for (File f : files) {
                try {
                    String line;
                    String fname = f.getAbsolutePath().substring(f.getAbsolutePath().lastIndexOf("/") + 1);
                    BufferedReader in = new BufferedReader(new FileReader(f));
                    int lineN = 1;
                    while ((line = in.readLine()) != null) {
                        String s;
                        if (!((line = line.trim()).isEmpty() || line.startsWith("-") || line.startsWith("funct") || line.startsWith("branch") || line.startsWith("call") || line.startsWith("#") || line.startsWith("0") || !statements.contains(s = fname + ":instr" + lineN))) {
                            instrCovered.add(s);
                        }
                        ++lineN;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        test.setStatements(instrCovered);
    }

    public static Set<Integer> testStringtoInt(Set<String> test, Set<String> allbs, Map<String, Integer> bsmap) {
        HashSet<Integer> testi = new HashSet<Integer>();
        for (String s : allbs) {
            if (!test.contains(s)) {
                testi.add(bsmap.get(s));
                continue;
            }
            testi.add(-bsmap.get(s).intValue());
        }
        return testi;
    }

    public static double getSetBasedDistance(Set<Integer> p1, Set<Integer> p2, double weight) {
        HashSet<Integer> intersection = new HashSet<Integer>(p1);
        HashSet<Integer> union = new HashSet<Integer>(p1);
        intersection.retainAll(p2);
        union.addAll(p2);
        double intersectionSize = intersection.size();
        double unionSize = union.size();
        return 1.0 - intersectionSize / (intersectionSize + weight * (unionSize - intersectionSize));
    }

    public static double getJaccardDistance(Set<Integer> p1, Set<Integer> p2) {
        return Prioritization.getSetBasedDistance(p1, p2, 1.0);
    }

    public static List<Test> globalMaxDist(List<Test> tests, double[][] distancesMatrix, int offset) {
        Random rand = new Random();
        ArrayList<Integer> possibleIndices = new ArrayList<Integer>();
        ArrayList<Integer> doneIndices = new ArrayList<Integer>();
        ArrayList<Test> prioritizedTests = new ArrayList<Test>();
        for (int i = 0; i < tests.size(); ++i) {
            possibleIndices.add(i);
        }
        int size = tests.size();
        double maxDistance = -1.0;
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                double d;
                if (j <= i || !((d = distancesMatrix[tests.get(i).getId() - offset][tests.get(j).getId() - offset]) > maxDistance)) continue;
                maxDistance = d;
            }
        }
        ArrayList<Integer> candidateIndicesI = new ArrayList<Integer>();
        ArrayList<Integer> candidateIndicesJ = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                double d;
                if (j <= i || (d = distancesMatrix[tests.get(i).getId() - offset][tests.get(j).getId() - offset]) != maxDistance) continue;
                candidateIndicesI.add(i);
                candidateIndicesJ.add(j);
            }
        }
        int r = rand.nextInt(candidateIndicesI.size());
        int toAddIIndex = (Integer)candidateIndicesI.get(r);
        int toAddJIndex = (Integer)candidateIndicesJ.get(r);
        Test test1 = tests.get(toAddIIndex);
        Test test2 = tests.get(toAddJIndex);
        prioritizedTests.add(test1);
        prioritizedTests.add(test2);
        possibleIndices.remove((Object)toAddIIndex);
        possibleIndices.remove((Object)toAddJIndex);
        doneIndices.add(toAddIIndex);
        doneIndices.add(toAddJIndex);
        while (!possibleIndices.isEmpty()) {
            if (possibleIndices.size() > 1) {
                double maxDist = -1.0;
                HashMap mapDistIndices = new HashMap();
                for (Integer i : possibleIndices) {
                    double distance = 0.0;
                    for (Integer j : doneIndices) {
                        distance += distancesMatrix[tests.get(i).getId() - offset][tests.get(j).getId() - offset];
                    }
                    if (mapDistIndices.get(distance) == null) {
                        mapDistIndices.put(distance, new ArrayList());
                    }
                    ((ArrayList)mapDistIndices.get(distance)).add(i);
                    if (!(distance > maxDist)) continue;
                    maxDist = distance;
                }
                int toAdd = (Integer)((ArrayList)mapDistIndices.get(maxDist)).get(rand.nextInt(((ArrayList)mapDistIndices.get(maxDist)).size()));
                Test test = tests.get(toAdd);
                prioritizedTests.add(test);
                possibleIndices.remove((Object)toAdd);
                doneIndices.add(toAdd);
                continue;
            }
            prioritizedTests.add(tests.get((Integer)possibleIndices.get(0)));
            possibleIndices.clear();
        }
        return prioritizedTests;
    }

    public static HashSet<HashSet<Integer>> getTSets(int t, HashSet<Integer> conf) {
        HashSet<HashSet<Integer>> tsets = new HashSet<HashSet<Integer>>();
        ArrayList<Integer> a = new ArrayList<Integer>(conf);
        int size = a.size();
        double total = Prioritization.getBinomCoeff(size, t);
        int i = 0;
        while ((double)i < total) {
            tsets.add(Prioritization.getITSet(size, t, i, a, total));
            ++i;
        }
        return tsets;
    }

    public static double getBinomCoeff(int n, int k) {
        if (k > n) {
            return 0.0;
        }
        if (n == k || k == 0) {
            return 1.0;
        }
        return ArithmeticUtils.binomialCoefficient(n, k);
    }

    public static HashSet getITSet(int n, int k, double m, List<Integer> featuresList, double total) {
        if (m >= total) {
            m = total - 1.0;
        }
        HashSet<Integer> tSet = new HashSet<Integer>();
        int a = n;
        int b = k;
        double x = total - 1.0 - m;
        for (int i = 0; i < k; ++i) {
            a = Prioritization.largestV(a, b, x);
            x -= Prioritization.getBinomCoeff(a, b);
            --b;
            tSet.add(featuresList.get(n - 1 - a));
        }
        return tSet;
    }

    public static int largestV(int a, int b, double x) {
        int v = a - 1;
        while (Prioritization.getBinomCoeff(v, b) > x) {
            --v;
        }
        return v;
    }

    public static ArrayList<Set<Integer>> globalPrioConf(ArrayList<Set<Integer>> confs, HashSet<HashSet<Integer>> tsets, int t, HashMap<HashSet<Integer>, HashSet<HashSet<Integer>>> mapTestTSets) {
        Random rand = new Random();
        int size = confs.size();
        ArrayList<Set<Integer>> prioritizedConfs = new ArrayList<Set<Integer>>(size);
        ArrayList<Integer> possibleIndices = new ArrayList<Integer>();
        ArrayList<Integer> doneIndices = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            possibleIndices.add(i);
        }
        int toAddIndex = (Integer)possibleIndices.get(rand.nextInt(possibleIndices.size()));
        Set<Integer> conf = confs.get(toAddIndex);
        prioritizedConfs.add(conf);
        tsets.removeAll((Collection)mapTestTSets.get(conf));
        possibleIndices.remove((Object)toAddIndex);
        doneIndices.add(toAddIndex);
        while (!possibleIndices.isEmpty()) {
            if (possibleIndices.size() > 1) {
                double maxCovered = -1.0;
                HashMap mapCoveredIndices = new HashMap();
                int toAdd = -1;
                for (Integer i : possibleIndices) {
                    HashSet<HashSet<Integer>> tsetsCopy = new HashSet<HashSet<Integer>>(tsets);
                    int prevSize = tsetsCopy.size();
                    double covered = 0.0;
                    Set<Integer> c = confs.get(i);
                    tsetsCopy.removeAll((Collection)mapTestTSets.get(c));
                    covered = prevSize - tsetsCopy.size();
                    if (mapCoveredIndices.get(covered) == null) {
                        mapCoveredIndices.put(covered, new ArrayList());
                    }
                    ((ArrayList)mapCoveredIndices.get(covered)).add(i);
                    if (!(covered > maxCovered)) continue;
                    maxCovered = covered;
                }
                toAdd = (Integer)((ArrayList)mapCoveredIndices.get(maxCovered)).get(rand.nextInt(((ArrayList)mapCoveredIndices.get(maxCovered)).size()));
                Set<Integer> c = confs.get(toAdd);
                prioritizedConfs.add(c);
                tsets.removeAll((Collection)mapTestTSets.get(c));
                possibleIndices.remove((Object)toAdd);
                doneIndices.add(toAdd);
                continue;
            }
            prioritizedConfs.add(confs.get((Integer)possibleIndices.get(0)));
            possibleIndices.clear();
        }
        return prioritizedConfs;
    }

    public static void loadTestInputModelMutant(Test t, String file, int i) {
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(new File(file)));
            while ((line = in.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line, " ");
                String m = st.nextToken();
                int test = Integer.parseInt(st.nextToken());
                if (test != i) continue;
                t.addMutant(m);
            }
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static int compress(String str) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        BZip2CompressorOutputStream os = new BZip2CompressorOutputStream((OutputStream)bout);
        os.write(str.getBytes());
        os.finish();
        byte[] compressed = bout.toByteArray();
        return compressed.length;
    }

    public static double ncd(String x, String y, int cx, int cy) throws Exception {
        if (x.equals(y)) {
            return 0.0;
        }
        int cxy = Prioritization.compress(x + y);
        return ((double)cxy - (double)Math.min(cx, cy)) / (double)Math.max(cx, cy);
    }

    public static List<Test> globalMinDist(List<Test> tests, double[][] distancesMatrix, int offset) {
        Random rand = new Random();
        ArrayList<Integer> possibleIndices = new ArrayList<Integer>();
        ArrayList<Integer> doneIndices = new ArrayList<Integer>();
        ArrayList<Test> prioritizedTests = new ArrayList<Test>();
        for (int i = 0; i < tests.size(); ++i) {
            possibleIndices.add(i);
        }
        int size = tests.size();
        double minDistance = Double.MAX_VALUE;
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                double d;
                if (j <= i || !((d = distancesMatrix[tests.get(i).getId() - offset][tests.get(j).getId() - offset]) < minDistance)) continue;
                minDistance = d;
            }
        }
        ArrayList<Integer> candidateIndicesI = new ArrayList<Integer>();
        ArrayList<Integer> candidateIndicesJ = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                double d;
                if (j <= i || (d = distancesMatrix[tests.get(i).getId() - offset][tests.get(j).getId() - offset]) != minDistance) continue;
                candidateIndicesI.add(i);
                candidateIndicesJ.add(j);
            }
        }
        int r = rand.nextInt(candidateIndicesI.size());
        int toAddIIndex = (Integer)candidateIndicesI.get(r);
        int toAddJIndex = (Integer)candidateIndicesJ.get(r);
        Test test1 = tests.get(toAddIIndex);
        Test test2 = tests.get(toAddJIndex);
        prioritizedTests.add(test1);
        prioritizedTests.add(test2);
        possibleIndices.remove((Object)toAddIIndex);
        possibleIndices.remove((Object)toAddJIndex);
        doneIndices.add(toAddIIndex);
        doneIndices.add(toAddJIndex);
        while (!possibleIndices.isEmpty()) {
            if (possibleIndices.size() > 1) {
                double minDist = Double.MAX_VALUE;
                HashMap mapDistIndices = new HashMap();
                for (Integer i : possibleIndices) {
                    double distance = 0.0;
                    for (Integer j : doneIndices) {
                        distance += distancesMatrix[tests.get(i).getId() - offset][tests.get(j).getId() - offset];
                    }
                    if (mapDistIndices.get(distance) == null) {
                        mapDistIndices.put(distance, new ArrayList());
                    }
                    ((ArrayList)mapDistIndices.get(distance)).add(i);
                    if (!(distance < minDist)) continue;
                    minDist = distance;
                }
                int toAdd = (Integer)((ArrayList)mapDistIndices.get(minDist)).get(rand.nextInt(((ArrayList)mapDistIndices.get(minDist)).size()));
                Test test = tests.get(toAdd);
                prioritizedTests.add(test);
                possibleIndices.remove((Object)toAdd);
                doneIndices.add(toAdd);
                continue;
            }
            prioritizedTests.add(tests.get((Integer)possibleIndices.get(0)));
            possibleIndices.clear();
        }
        return prioritizedTests;
    }

    public static int getLevenshteinDistance(String a, String b) {
        a = a.toLowerCase();
        b = b.toLowerCase();
        int[] costs = new int[b.length() + 1];
        for (int j = 0; j < costs.length; ++j) {
            costs[j] = j;
        }
        for (int i = 1; i <= a.length(); ++i) {
            costs[0] = i;
            int nw = i - 1;
            for (int j = 1; j <= b.length(); ++j) {
                int cj = Math.min(1 + Math.min(costs[j], costs[j - 1]), a.charAt(i - 1) == b.charAt(j - 1) ? nw : nw + 1);
                nw = costs[j];
                costs[j] = cj;
            }
        }
        return costs[b.length()];
    }

    public static List<Integer> TSDmPrioritization(List<InOut> inouts) throws Exception {
        ArrayList<Integer> prioritized = new ArrayList<Integer>();
        ArrayList<InOut> inoutsCp = new ArrayList<InOut>(inouts);
        BZip2EncoderExecutorService executor = BZip2OutputStream.createExecutorService((int)8);
        BZip2OutputStreamSettings settings = new BZip2OutputStreamSettings().setExecutorService(executor);
        while (!inoutsCp.isEmpty()) {
            int maxIndex = 0;
            int maxCompress = 0;
            for (int i = 0; i < inoutsCp.size(); ++i) {
                int c = Prioritization.compressExcept(inoutsCp, i, settings);
                if (c <= maxCompress) continue;
                maxCompress = c;
                maxIndex = i;
            }
            prioritized.add(((InOut)inoutsCp.get(maxIndex)).getId());
            inoutsCp.remove(maxIndex);
        }
        executor.shutdown();
        return prioritized;
    }

    public static int compressExcept(List<InOut> inouts, int except, BZip2OutputStreamSettings settings) throws Exception {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (InOut inout : inouts) {
            if (i != except) {
                sb.append(inout.getInout());
            }
            ++i;
        }
        return Prioritization.compress(sb.toString(), settings);
    }

    public static int compress(String str, BZip2OutputStreamSettings settings) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        BZip2OutputStream bzos = new BZip2OutputStream((OutputStream)bout, settings);
        byte[] b = str.getBytes();
        bzos.write(b);
        bzos.close();
        return bout.size();
    }
}

