/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.archive;

import org.at4j.archive.ArchiveDirectoryEntry;
import org.at4j.archive.ArchiveEntry;
import org.at4j.archive.ArchiveEntryCollaborator;
import org.entityfs.el.AbsoluteLocation;
import org.entityfs.exception.LockTimeoutException;
import org.entityfs.lock.DummyLock;
import org.entityfs.lock.EntityLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractArchiveEntry<T extends ArchiveEntry<T, U>, U extends ArchiveDirectoryEntry<T, U>>
implements ArchiveEntry<T, U> {
    private final AbsoluteLocation m_location;
    private final ArchiveEntryCollaborator<T, U> m_collaborator;

    protected AbstractArchiveEntry(AbsoluteLocation absoluteLocation, ArchiveEntryCollaborator<T, U> archiveEntryCollaborator) {
        absoluteLocation.getClass();
        archiveEntryCollaborator.getClass();
        this.m_location = absoluteLocation;
        this.m_collaborator = archiveEntryCollaborator;
    }

    @Override
    public AbsoluteLocation getLocation() {
        return this.m_location;
    }

    protected ArchiveEntryCollaborator<T, U> getCollaborator() {
        return this.m_collaborator;
    }

    public EntityLock getReadLock() {
        return DummyLock.INSTANCE;
    }

    public boolean isReadLockedByCurrentThread() throws IllegalStateException {
        return true;
    }

    public EntityLock lockForReading() throws LockTimeoutException {
        return DummyLock.INSTANCE;
    }

    public String getName() {
        return this.m_location.getName();
    }

    @Override
    public U getParent() {
        if (this.getLocation().equals((Object)AbsoluteLocation.ROOT_DIR)) {
            return null;
        }
        return (U)((ArchiveDirectoryEntry)this.m_collaborator.getEntry(this.getLocation().getParentLocation()));
    }
}

