/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.archive;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.at4j.archive.ArchiveDirectoryEntry;
import org.at4j.archive.ArchiveEntry;
import org.entityfs.RandomAccess;
import org.entityfs.RandomAccessCloseObserver;
import org.entityfs.RandomlyAccessibleFile;
import org.entityfs.el.AbsoluteLocation;
import org.entityfs.support.io.RandomAccessMode;
import org.entityfs.util.io.RangeInputStream;
import org.entityfs.util.io.RangeRandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArchiveEntryCollaborator<T extends ArchiveEntry<T, U>, U extends ArchiveDirectoryEntry<T, U>>
implements RandomAccessCloseObserver {
    private final RandomlyAccessibleFile m_archiveFile;
    private final Map<AbsoluteLocation, T> m_entryMap;
    private final Set<RandomAccess> m_openStreams = new HashSet<RandomAccess>();
    private boolean m_closed = false;

    protected ArchiveEntryCollaborator(RandomlyAccessibleFile randomlyAccessibleFile, Map<AbsoluteLocation, T> map) {
        randomlyAccessibleFile.getClass();
        map.getClass();
        this.m_archiveFile = randomlyAccessibleFile;
        this.m_entryMap = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RandomAccess createRandomAccess() {
        RandomAccess randomAccess = this.m_archiveFile.openForRandomAccess(RandomAccessMode.READ_ONLY);
        randomAccess.addCloseObserver((RandomAccessCloseObserver)this);
        Set<RandomAccess> set = this.m_openStreams;
        synchronized (set) {
            this.m_openStreams.add(randomAccess);
        }
        return randomAccess;
    }

    public InputStream openStream(long l, long l2) {
        return new RangeInputStream(this.createRandomAccess(), l, l2);
    }

    public RandomAccess openRandomAccess(long l, long l2) {
        return new RangeRandomAccess(this.createRandomAccess(), l, l2);
    }

    public T getEntry(AbsoluteLocation absoluteLocation) {
        return (T)((ArchiveEntry)this.m_entryMap.get(absoluteLocation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyClosed(RandomAccess randomAccess) {
        Set<RandomAccess> set = this.m_openStreams;
        synchronized (set) {
            this.m_openStreams.remove(randomAccess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.m_closed) {
            this.m_closed = true;
            Set<RandomAccess> set = this.m_openStreams;
            synchronized (set) {
                for (RandomAccess randomAccess : new ArrayList<RandomAccess>(this.m_openStreams)) {
                    randomAccess.close();
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

