/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.archive.builder;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.at4j.archive.builder.ArchiveBuilder;
import org.at4j.archive.builder.ArchiveEntryAddException;
import org.at4j.archive.builder.ArchiveEntrySettings;
import org.at4j.archive.builder.ArchiveEntrySettingsRule;
import org.at4j.archive.builder.EntryToArchive;
import org.entityfs.DirectoryView;
import org.entityfs.EFile;
import org.entityfs.ETDirectory;
import org.entityfs.ETFile;
import org.entityfs.EntityType;
import org.entityfs.EntityView;
import org.entityfs.FileSystem;
import org.entityfs.NamedReadableFile;
import org.entityfs.ReadableFile;
import org.entityfs.el.AbsoluteLocation;
import org.entityfs.exception.EntityNotFoundException;
import org.entityfs.fs.FSROFileSystemBuilder;
import org.entityfs.lock.EntityLock;
import org.entityfs.support.exception.WrappedIOException;
import org.entityfs.support.filter.Filter;
import org.entityfs.util.io.ReadWritableFileAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractArchiveBuilder<U extends AbstractArchiveBuilder<U, V>, V extends ArchiveEntrySettings<V>>
implements ArchiveBuilder<U, V> {
    private static final ArchiveEntrySettingsRule<?>[] NO_RULES = new ArchiveEntrySettingsRule[0];
    private V m_defaultFileEntrySettings;
    private V m_defaultDirectoryEntrySettings;
    private final List<ArchiveEntrySettingsRule<? extends V>> m_rules = new ArrayList<ArchiveEntrySettingsRule<? extends V>>(2);

    protected AbstractArchiveBuilder(V v, V v2) {
        v.getClass();
        v2.getClass();
        this.m_defaultFileEntrySettings = v;
        this.m_defaultDirectoryEntrySettings = v2;
    }

    protected abstract void assertNotClosed() throws IllegalStateException;

    protected abstract V getDefaultDefaultFileEntrySettings();

    protected abstract V getDefaultDefaultDirectoryEntrySettings();

    protected U getThis() {
        return (U)this;
    }

    @Override
    public U setDefaultFileEntrySettings(V v) throws IllegalStateException {
        this.assertNotClosed();
        v.getClass();
        this.m_defaultFileEntrySettings = this.getDefaultDefaultFileEntrySettings().combineWith(v);
        return this.getThis();
    }

    @Override
    public V getDefaultFileEntrySettings() throws IllegalStateException {
        this.assertNotClosed();
        return (V)this.m_defaultFileEntrySettings.clone();
    }

    @Override
    public U setDefaultDirectoryEntrySettings(V v) throws IllegalStateException {
        this.assertNotClosed();
        v.getClass();
        this.m_defaultDirectoryEntrySettings = this.getDefaultDefaultDirectoryEntrySettings().combineWith(v);
        return this.getThis();
    }

    @Override
    public V getDefaultDirectoryEntrySettings() throws IllegalStateException {
        this.assertNotClosed();
        return (V)this.m_defaultDirectoryEntrySettings.clone();
    }

    @Override
    public U addRule(ArchiveEntrySettingsRule<? extends V> archiveEntrySettingsRule) throws IllegalStateException {
        this.assertNotClosed();
        this.m_rules.add(archiveEntrySettingsRule);
        return this.getThis();
    }

    @Override
    public U addRules(Collection<? extends ArchiveEntrySettingsRule<? extends V>> collection) throws IllegalStateException {
        this.assertNotClosed();
        for (ArchiveEntrySettingsRule<V> archiveEntrySettingsRule : collection) {
            archiveEntrySettingsRule.getClass();
        }
        this.m_rules.addAll(collection);
        return this.getThis();
    }

    @Override
    public boolean removeRule(ArchiveEntrySettingsRule<? extends V> archiveEntrySettingsRule) throws IllegalStateException {
        this.assertNotClosed();
        return this.m_rules.remove(archiveEntrySettingsRule);
    }

    @Override
    public List<ArchiveEntrySettingsRule<? extends V>> getRules() throws IllegalStateException {
        this.assertNotClosed();
        return new ArrayList<ArchiveEntrySettingsRule<? extends V>>(this.m_rules);
    }

    protected V getEffectiveSettingsForFile(Object object, AbsoluteLocation absoluteLocation, V v) {
        V v2 = this.m_defaultFileEntrySettings;
        EntryToArchive entryToArchive = new EntryToArchive(absoluteLocation, (EntityType)ETFile.TYPE, object);
        for (ArchiveEntrySettingsRule<V> archiveEntrySettingsRule : this.m_rules) {
            if (!archiveEntrySettingsRule.getFilter().matches((Object)entryToArchive)) continue;
            v2 = v2.combineWith(archiveEntrySettingsRule.getSettings());
        }
        return v != null ? v2.combineWith(v) : v2;
    }

    protected V getEffectiveSettingsForFile(Object object, AbsoluteLocation absoluteLocation, ArchiveEntrySettingsRule<? extends V>[] archiveEntrySettingsRuleArray) {
        V v = this.m_defaultFileEntrySettings;
        EntryToArchive entryToArchive = new EntryToArchive(absoluteLocation, (EntityType)ETFile.TYPE, object);
        for (ArchiveEntrySettingsRule<V> archiveEntrySettingsRule : this.m_rules) {
            if (!archiveEntrySettingsRule.getFilter().matches((Object)entryToArchive)) continue;
            v = v.combineWith(archiveEntrySettingsRule.getSettings());
        }
        if (archiveEntrySettingsRuleArray != null) {
            for (ArchiveEntrySettingsRule<V> archiveEntrySettingsRule : archiveEntrySettingsRuleArray) {
                if (!archiveEntrySettingsRule.getFilter().matches((Object)entryToArchive)) continue;
                v = v.combineWith(archiveEntrySettingsRule.getSettings());
            }
        }
        return v;
    }

    protected V getEffectiveSettingsForDirectory(Object object, AbsoluteLocation absoluteLocation, V v) {
        V v2 = this.m_defaultDirectoryEntrySettings;
        EntryToArchive entryToArchive = new EntryToArchive(absoluteLocation, (EntityType)ETDirectory.TYPE, object);
        for (ArchiveEntrySettingsRule<V> archiveEntrySettingsRule : this.m_rules) {
            if (!archiveEntrySettingsRule.getFilter().matches((Object)entryToArchive)) continue;
            v2 = v2.combineWith(archiveEntrySettingsRule.getSettings());
        }
        return v != null ? v2.combineWith(v) : v2;
    }

    protected V getEffectiveSettingsForDirectory(Object object, AbsoluteLocation absoluteLocation, ArchiveEntrySettingsRule<? extends V>[] archiveEntrySettingsRuleArray) {
        V v = this.m_defaultDirectoryEntrySettings;
        EntryToArchive entryToArchive = new EntryToArchive(absoluteLocation, (EntityType)ETDirectory.TYPE, object);
        for (ArchiveEntrySettingsRule<V> archiveEntrySettingsRule : this.m_rules) {
            if (!archiveEntrySettingsRule.getFilter().matches((Object)entryToArchive)) continue;
            v = v.combineWith(archiveEntrySettingsRule.getSettings());
        }
        if (archiveEntrySettingsRuleArray != null) {
            for (ArchiveEntrySettingsRule<V> archiveEntrySettingsRule : archiveEntrySettingsRuleArray) {
                if (!archiveEntrySettingsRule.getFilter().matches((Object)entryToArchive)) continue;
                v = v.combineWith(archiveEntrySettingsRule.getSettings());
            }
        }
        return v;
    }

    protected abstract void addDirectoryCallback(AbsoluteLocation var1, Object var2, V var3, Date var4) throws WrappedIOException, ArchiveEntryAddException;

    protected abstract void addFileCallback(AbsoluteLocation var1, ReadableFile var2, V var3, Date var4) throws WrappedIOException, ArchiveEntryAddException;

    @Override
    public U add(NamedReadableFile namedReadableFile) throws IllegalStateException, WrappedIOException {
        return (U)this.add(namedReadableFile, AbsoluteLocation.ROOT_DIR, null);
    }

    @Override
    public U add(NamedReadableFile namedReadableFile, AbsoluteLocation absoluteLocation) throws IllegalStateException, WrappedIOException {
        return (U)this.add(namedReadableFile, absoluteLocation, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public U add(NamedReadableFile namedReadableFile, AbsoluteLocation absoluteLocation, V v) throws IllegalStateException, WrappedIOException {
        this.assertNotClosed();
        EntityLock entityLock = namedReadableFile.lockForReading();
        try {
            AbsoluteLocation absoluteLocation2 = absoluteLocation.getChildLocation(namedReadableFile.getName());
            V v2 = this.getEffectiveSettingsForFile((Object)namedReadableFile, absoluteLocation2, v);
            Date date = namedReadableFile instanceof EntityView ? new Date(((EntityView)namedReadableFile).getLastModified()) : new Date();
            this.addFileCallback(absoluteLocation2, (ReadableFile)namedReadableFile, v2, date);
        }
        finally {
            entityLock.unlock();
        }
        return this.getThis();
    }

    @Override
    public U add(DirectoryView directoryView) throws IllegalStateException, WrappedIOException {
        return (U)this.add(directoryView, AbsoluteLocation.ROOT_DIR, null);
    }

    @Override
    public U add(DirectoryView directoryView, AbsoluteLocation absoluteLocation) throws IllegalStateException, WrappedIOException {
        return (U)this.add(directoryView, absoluteLocation, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public U add(DirectoryView directoryView, AbsoluteLocation absoluteLocation, V v) throws IllegalStateException, WrappedIOException {
        this.assertNotClosed();
        EntityLock entityLock = directoryView.lockForReading();
        try {
            AbsoluteLocation absoluteLocation2 = absoluteLocation.getChildLocation(directoryView.getName());
            V v2 = this.getEffectiveSettingsForDirectory((Object)directoryView, absoluteLocation2, v);
            this.addDirectoryCallback(absoluteLocation2, directoryView, v2, new Date(directoryView.getLastModified()));
        }
        finally {
            entityLock.unlock();
        }
        return this.getThis();
    }

    @Override
    public U add(File file) throws IllegalStateException, WrappedIOException, EntityNotFoundException {
        return (U)this.add(file, AbsoluteLocation.ROOT_DIR, null);
    }

    @Override
    public U add(File file, AbsoluteLocation absoluteLocation) throws IllegalStateException, WrappedIOException, EntityNotFoundException {
        return (U)this.add(file, absoluteLocation, null);
    }

    @Override
    public U add(File file, AbsoluteLocation absoluteLocation, V v) throws IllegalStateException, WrappedIOException, EntityNotFoundException {
        this.assertNotClosed();
        if (!file.exists()) {
            throw new EntityNotFoundException(file + " not found");
        }
        if (file.isFile()) {
            this.add((NamedReadableFile)new ReadWritableFileAdapter(file), absoluteLocation, (ArchiveEntrySettings)v);
        } else if (file.isDirectory()) {
            AbsoluteLocation absoluteLocation2 = absoluteLocation.getChildLocation(file.getName());
            V v2 = this.getEffectiveSettingsForDirectory((Object)file, absoluteLocation2, v);
            this.addDirectoryCallback(absoluteLocation2, file, v2, new Date(file.lastModified()));
        } else {
            throw new RuntimeException("Unknown file type " + file);
        }
        return this.getThis();
    }

    @Override
    public U addRecursively(DirectoryView directoryView, AbsoluteLocation absoluteLocation) throws IllegalStateException, WrappedIOException {
        return (U)this.addRecursively(directoryView, absoluteLocation, (Filter)null, NO_RULES);
    }

    @Override
    public U addRecursively(DirectoryView directoryView, AbsoluteLocation absoluteLocation, Filter<? super EntityView> filter) throws IllegalStateException, WrappedIOException {
        return (U)this.addRecursively(directoryView, absoluteLocation, (Filter)filter, NO_RULES);
    }

    @Override
    public U addRecursively(File file, AbsoluteLocation absoluteLocation) throws IllegalStateException, WrappedIOException, EntityNotFoundException {
        return (U)this.addRecursively(file, absoluteLocation, NO_RULES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRecursivelyInternal(DirectoryView directoryView, AbsoluteLocation absoluteLocation, Filter<? super EntityView> filter, ArchiveEntrySettingsRule<? extends V>[] archiveEntrySettingsRuleArray, Lock lock) throws WrappedIOException, ArchiveEntryAddException {
        Set set;
        try {
            set = directoryView.listEntities();
            if ((filter == null || filter.matches((Object)directoryView)) && !absoluteLocation.isRootDir()) {
                V v = this.getEffectiveSettingsForDirectory((Object)directoryView, absoluteLocation, archiveEntrySettingsRuleArray);
                this.addDirectoryCallback(absoluteLocation, directoryView, v, new Date(directoryView.getLastModified()));
            }
        }
        finally {
            lock.unlock();
        }
        for (EntityView entityView : set) {
            EntityLock entityLock;
            if (entityView.getType() == ETDirectory.TYPE) {
                entityLock = entityView.lockForReading();
                this.addRecursivelyInternal((DirectoryView)entityView, absoluteLocation.getChildLocation(entityView.getName()), filter, archiveEntrySettingsRuleArray, (Lock)entityLock);
                continue;
            }
            if (entityView.getType() == ETFile.TYPE) {
                entityLock = (EFile)entityView;
                EntityLock entityLock2 = entityLock.lockForReading();
                try {
                    if (filter != null && !filter.matches((Object)entityLock)) continue;
                    AbsoluteLocation absoluteLocation2 = absoluteLocation.getChildLocation(entityLock.getName());
                    V v = this.getEffectiveSettingsForFile((Object)entityLock, absoluteLocation2, archiveEntrySettingsRuleArray);
                    this.addFileCallback(absoluteLocation2, (ReadableFile)entityLock, v, new Date(entityLock.getLastModified()));
                    continue;
                }
                finally {
                    entityLock2.unlock();
                    continue;
                }
            }
            throw new ArchiveEntryAddException("Don't know how to add the entry " + entityView + " to the archive. Unsupported entity type " + entityView.getType());
        }
    }

    @Override
    public U addRecursively(DirectoryView directoryView, AbsoluteLocation absoluteLocation, Filter<? super EntityView> filter, ArchiveEntrySettingsRule<? extends V> ... archiveEntrySettingsRuleArray) throws IllegalStateException, WrappedIOException {
        this.assertNotClosed();
        this.addRecursivelyInternal(directoryView, absoluteLocation, filter, archiveEntrySettingsRuleArray, (Lock)directoryView.lockForReading());
        return this.getThis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public U addRecursively(File file, AbsoluteLocation absoluteLocation, ArchiveEntrySettingsRule<? extends V> ... archiveEntrySettingsRuleArray) throws IllegalStateException, WrappedIOException, EntityNotFoundException {
        this.assertNotClosed();
        if (!file.exists()) {
            throw new EntityNotFoundException(file + " not found");
        }
        if (file.isFile()) {
            AbsoluteLocation absoluteLocation2 = absoluteLocation.getChildLocation(file.getName());
            V v = this.getEffectiveSettingsForFile((Object)file, absoluteLocation2, archiveEntrySettingsRuleArray);
            this.addFileCallback(absoluteLocation2, (ReadableFile)new ReadWritableFileAdapter(file), v, new Date(file.lastModified()));
        } else if (file.isDirectory()) {
            FileSystem fileSystem = ((FSROFileSystemBuilder)((FSROFileSystemBuilder)new FSROFileSystemBuilder().setRoot(file)).disableEntityValidityControls()).create();
            try {
                this.addRecursively((DirectoryView)fileSystem.getRootDirectory(), absoluteLocation, (Filter)null, (ArchiveEntrySettingsRule[])archiveEntrySettingsRuleArray);
            }
            finally {
                fileSystem.close();
            }
        } else {
            throw new RuntimeException("Unknown file type " + file);
        }
        return this.getThis();
    }
}

