/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.bzip2;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.at4j.comp.bzip2.BZip2EncoderExecutorService;
import org.at4j.comp.bzip2.BlockEncoderRunnable;
import org.at4j.comp.bzip2.EncodingThreadFactory;
import org.at4j.comp.bzip2.ErrorState;

final class BZip2EncoderExecutorServiceImpl
implements BZip2EncoderExecutorService {
    private final ThreadPoolExecutor m_executor;
    private final ErrorState m_errorState;

    BZip2EncoderExecutorServiceImpl(int n, ErrorState errorState) {
        this.m_executor = new ThreadPoolExecutor(n, n, 100L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1), new EncodingThreadFactory(errorState), ShoehornInJobRejectedExecutionHandler.INSTANCE);
        this.m_errorState = errorState;
    }

    ErrorState getErrorState() {
        return this.m_errorState;
    }

    void execute(BlockEncoderRunnable blockEncoderRunnable) {
        this.m_executor.execute(blockEncoderRunnable);
    }

    public void shutdown() {
        this.m_executor.shutdown();
    }

    private static class ShoehornInJobRejectedExecutionHandler
    implements RejectedExecutionHandler {
        private static final ShoehornInJobRejectedExecutionHandler INSTANCE = new ShoehornInJobRejectedExecutionHandler();

        private ShoehornInJobRejectedExecutionHandler() {
        }

        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            try {
                threadPoolExecutor.getQueue().put(runnable);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
    }
}

