/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.bzip2;

import java.io.IOException;
import java.io.InputStream;
import org.at4j.comp.bzip2.BZip2InputStreamSettings;
import org.at4j.comp.bzip2.Block;
import org.at4j.comp.bzip2.BlockDecoder;
import org.at4j.comp.bzip2.CRC;
import org.at4j.comp.bzip2.CompressedDataBlock;
import org.at4j.comp.bzip2.EosBlock;
import org.at4j.support.io.LittleEndianBitInputStream;
import org.entityfs.support.log.LogAdapter;

public class BZip2InputStream
extends InputStream {
    private final LittleEndianBitInputStream m_in;
    private final LogAdapter m_logAdapter;
    private final int m_blockSize;
    private final BlockDecoder m_blockDecoder;
    private int m_fileChecksum = 0;
    private int m_curBlockNo = 0;
    private int m_curBlockChecksumExpected;
    private CRC m_curBlockChecksumCalculated = new CRC();
    private boolean m_atEof = false;
    private boolean m_closed = false;
    private InputStream m_curBlock;

    private static int readFileHeader(LittleEndianBitInputStream littleEndianBitInputStream, LogAdapter logAdapter) throws IOException {
        int n;
        int n2;
        byte[] byArray = new byte[2];
        int n3 = littleEndianBitInputStream.read(byArray, 0, 2);
        if (n3 != 2) {
            throw new IOException("Wanted to read two bytes. Got " + n3);
        }
        if (byArray[0] != 66 || byArray[1] != 90) {
            throw new IOException("The stream does not start with the magic bytes BZ. Got " + (char)byArray[0] + (char)byArray[1]);
        }
        if (logAdapter != null) {
            logAdapter.logTrace((Object)"Read bzip2 stream header OK");
        }
        if ((n2 = littleEndianBitInputStream.read()) != 104) {
            throw new IOException("Unsupported bzip2 stream version " + n2 + ". The only version supported is 'h' (104)");
        }
        if (logAdapter != null) {
            logAdapter.logTrace((Object)"Read bzip2 stream version OK");
        }
        if (!Character.isDigit(n = littleEndianBitInputStream.read())) {
            throw new IOException("Invalid block size " + n + ". Expected a character in the range 1..9");
        }
        int n4 = n - 48;
        if (n4 < 1 || n4 > 9) {
            throw new IOException("Invalid block size " + n + ". Expected a character in the range 1..9");
        }
        if (logAdapter != null) {
            logAdapter.logTrace((Object)("Read bzip2 block size " + n4 + " * 100kb"));
        }
        return n4 * 100 * 1000;
    }

    public BZip2InputStream(InputStream inputStream) throws IOException {
        this(inputStream, null);
    }

    public BZip2InputStream(InputStream inputStream, BZip2InputStreamSettings bZip2InputStreamSettings) throws IOException {
        inputStream.getClass();
        this.m_in = new LittleEndianBitInputStream(inputStream);
        this.m_logAdapter = bZip2InputStreamSettings != null ? bZip2InputStreamSettings.getLogAdapter() : null;
        this.m_blockSize = BZip2InputStream.readFileHeader(this.m_in, this.m_logAdapter);
        this.m_blockDecoder = new BlockDecoder(this.m_in, this.m_blockSize, this.m_logAdapter);
    }

    private InputStream readNewBlock() throws IOException {
        Block block = this.m_blockDecoder.getNextBlock();
        if (block instanceof CompressedDataBlock) {
            ++this.m_curBlockNo;
            this.m_curBlockChecksumCalculated = new CRC();
            this.m_curBlockChecksumExpected = ((CompressedDataBlock)block).getBlockChecksum();
            return ((CompressedDataBlock)block).getStream();
        }
        if (block instanceof EosBlock) {
            if ((long)this.m_fileChecksum != ((EosBlock)block).getReadCrc()) {
                throw new IOException("Invalid file checksum " + this.m_fileChecksum + ". Expected " + ((EosBlock)block).getReadCrc());
            }
            this.m_atEof = true;
            return null;
        }
        throw new RuntimeException("Unknown bzip2 block type " + block + ". This is a bug");
    }

    private void assertNotClosed() throws IOException {
        if (this.m_closed) {
            throw new IOException("This stream is closed");
        }
    }

    private void verifyBlockChecksum() throws IOException {
        if (this.m_curBlockChecksumCalculated.getValue() != this.m_curBlockChecksumExpected) {
            throw new IOException("Invalid checksum for bzip2 block no " + this.m_curBlockNo + ". Was " + this.m_curBlockChecksumCalculated.getValue() + ". Expected " + this.m_curBlockChecksumExpected);
        }
    }

    private void updateFileChecksum() {
        this.m_fileChecksum = this.m_fileChecksum << 1 | this.m_fileChecksum >>> 31;
        this.m_fileChecksum ^= this.m_curBlockChecksumExpected;
    }

    public int read() throws IOException {
        int n;
        this.assertNotClosed();
        if (this.m_curBlock == null) {
            if (this.m_atEof) {
                return -1;
            }
            this.m_curBlock = this.readNewBlock();
            if (this.m_atEof) {
                return -1;
            }
        }
        if ((n = this.m_curBlock.read()) == -1) {
            this.verifyBlockChecksum();
            this.updateFileChecksum();
            this.m_curBlock = null;
            return this.read();
        }
        this.m_curBlockChecksumCalculated.update(n);
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException, IndexOutOfBoundsException {
        this.assertNotClosed();
        if (n < 0) {
            throw new IndexOutOfBoundsException("Off: " + n);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Len: " + n2);
        }
        if (n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException("Off: " + n + " + Len: " + n2 + " > length of array: " + byArray.length);
        }
        int n3 = 0;
        while (n2 > 0) {
            int n4;
            if (this.m_curBlock == null) {
                if (this.m_atEof) {
                    return n3 == 0 ? -1 : n3;
                }
                this.m_curBlock = this.readNewBlock();
                if (this.m_atEof) {
                    return n3 == 0 ? -1 : n3;
                }
            }
            if ((n4 = this.m_curBlock.read(byArray, n, n2)) > 0) {
                for (int i = n; i < n + n4; ++i) {
                    this.m_curBlockChecksumCalculated.update(byArray[i] & 0xFF);
                }
                n += n4;
            }
            if (n4 < n2) {
                this.verifyBlockChecksum();
                this.updateFileChecksum();
                this.m_curBlock = null;
            }
            n3 += n4;
            n2 -= n4;
        }
        return n3;
    }

    public void close() throws IOException {
        if (!this.m_closed) {
            this.m_in.close();
            this.m_closed = true;
            super.close();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

