/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.bzip2;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.at4j.comp.bzip2.BZip2EncoderExecutorService;
import org.at4j.comp.bzip2.BZip2EncoderExecutorServiceImpl;
import org.at4j.comp.bzip2.BZip2OutputStreamSettings;
import org.at4j.comp.bzip2.BlockOutputStream;
import org.at4j.comp.bzip2.EncodedBlockWriter;
import org.at4j.comp.bzip2.EncodingScratchpad;
import org.at4j.comp.bzip2.MultipleObserverErrorState;
import org.at4j.comp.bzip2.SingleObserverErrorState;
import org.at4j.support.io.LittleEndianBitOutputStream;
import org.entityfs.support.log.LogAdapter;

public class BZip2OutputStream
extends OutputStream {
    private static final byte[] EOS_MAGIC = new byte[]{23, 114, 69, 56, 80, -112};
    private static final AtomicInteger HASH_CODE_GENERATOR = new AtomicInteger(0);
    private final LittleEndianBitOutputStream m_wrapped;
    private final int m_blockSize;
    private final LogAdapter m_logAdapter;
    private final BlockOutputStream m_blockOutputStream;
    private final EncodedBlockWriter m_encodedBlockWriter;
    private final BZip2EncoderExecutorServiceImpl m_executorService;
    private final boolean m_iCreatedExecutor;
    private final int m_hashCode = HASH_CODE_GENERATOR.getAndIncrement();
    private boolean m_closed;
    private long m_pos = 0L;

    private static void writeFileHeader(OutputStream outputStream, int n) throws IOException {
        outputStream.write(66);
        outputStream.write(90);
        outputStream.write(104);
        outputStream.write(n + 48);
    }

    public BZip2OutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, new BZip2OutputStreamSettings());
    }

    public BZip2OutputStream(OutputStream outputStream, BZip2OutputStreamSettings bZip2OutputStreamSettings) throws IOException {
        EncodingScratchpad encodingScratchpad;
        outputStream.getClass();
        bZip2OutputStreamSettings.getClass();
        this.m_wrapped = new LittleEndianBitOutputStream(outputStream);
        this.m_blockSize = bZip2OutputStreamSettings.getBlockSize() * 100 * 1000;
        this.m_logAdapter = bZip2OutputStreamSettings.getLogAdapter();
        BZip2OutputStream.writeFileHeader(outputStream, bZip2OutputStreamSettings.getBlockSize());
        if (bZip2OutputStreamSettings.getExecutorService() != null) {
            this.m_executorService = (BZip2EncoderExecutorServiceImpl)bZip2OutputStreamSettings.getExecutorService();
            this.m_iCreatedExecutor = false;
            this.m_encodedBlockWriter = new EncodedBlockWriter(this.m_wrapped, this.m_logAdapter);
            encodingScratchpad = null;
        } else if (bZip2OutputStreamSettings.getNumberOfEncoderThreads() > 0) {
            this.m_executorService = new BZip2EncoderExecutorServiceImpl(bZip2OutputStreamSettings.getNumberOfEncoderThreads(), new SingleObserverErrorState());
            this.m_iCreatedExecutor = true;
            this.m_encodedBlockWriter = new EncodedBlockWriter(this.m_wrapped, this.m_logAdapter);
            encodingScratchpad = null;
        } else {
            this.m_executorService = null;
            this.m_iCreatedExecutor = false;
            encodingScratchpad = new EncodingScratchpad();
            this.m_encodedBlockWriter = null;
        }
        this.m_blockOutputStream = new BlockOutputStream(this.m_wrapped, this.m_blockSize, bZip2OutputStreamSettings.getNumberOfHuffmanTreeRefinementIterations(), this.m_logAdapter, this.m_executorService, this, this.m_encodedBlockWriter, encodingScratchpad);
    }

    private void assertNotClosed() throws IOException {
        if (this.m_closed) {
            throw new IOException("This stream is closed");
        }
    }

    private void checkErrorState() throws IOException, RuntimeException {
        if (this.m_executorService != null) {
            this.m_executorService.getErrorState().checkAndClearErrors(this);
        }
    }

    private void debug(String string) {
        if (this.m_logAdapter != null) {
            this.m_logAdapter.logDebug((Object)string);
        }
    }

    private void writeEosBlock() throws IOException {
        for (int i = 0; i < EOS_MAGIC.length; ++i) {
            this.m_wrapped.writeBitsLittleEndian(EOS_MAGIC[i] & 0xFF, 8);
        }
        this.m_wrapped.writeBitsLittleEndian(this.m_blockOutputStream.getFileChecksum(), 32);
        this.m_wrapped.padToByteBoundary();
    }

    public void write(int n) throws IOException {
        this.assertNotClosed();
        this.checkErrorState();
        ++this.m_pos;
        this.m_blockOutputStream.write(n & 0xFF);
    }

    public void write(byte[] byArray) throws IOException {
        this.assertNotClosed();
        this.checkErrorState();
        this.m_pos += (long)byArray.length;
        this.m_blockOutputStream.write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException, IndexOutOfBoundsException {
        this.assertNotClosed();
        this.checkErrorState();
        if (n < 0) {
            throw new IndexOutOfBoundsException("Offset: " + n);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Length: " + n2);
        }
        if (n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException("Offset: " + n + " + Length: " + n2 + " > length of data: " + byArray.length);
        }
        this.m_pos += (long)n2;
        this.m_blockOutputStream.write(byArray, n, n2);
    }

    public void close() throws IOException {
        this.checkErrorState();
        if (!this.m_closed) {
            this.m_blockOutputStream.close();
            if (this.m_pos > 0L && this.m_encodedBlockWriter != null) {
                try {
                    this.m_encodedBlockWriter.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException("Interrupted. The output file is most likely corrupted.");
                }
                this.checkErrorState();
            }
            this.writeEosBlock();
            this.m_wrapped.close();
            this.debug("Original size: " + this.m_pos + ", compressed size: " + this.m_wrapped.getNumberOfBytesWritten());
            if (this.m_iCreatedExecutor && this.m_executorService != null) {
                this.m_executorService.shutdown();
            }
            this.m_closed = true;
            super.close();
        }
    }

    public int hashCode() {
        return this.m_hashCode;
    }

    public boolean equals(Object object) {
        return this == object;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public static BZip2EncoderExecutorService createExecutorService(int n) {
        return new BZip2EncoderExecutorServiceImpl(n, new MultipleObserverErrorState());
    }

    public static BZip2EncoderExecutorService createExecutorService() {
        return BZip2OutputStream.createExecutorService(Runtime.getRuntime().availableProcessors());
    }
}

