/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.bzip2;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.at4j.comp.bzip2.BZip2InputStream;
import org.at4j.comp.bzip2.BZip2ReadableFileSettings;
import org.entityfs.ReadableFile;
import org.entityfs.exception.LockTimeoutException;
import org.entityfs.lock.EntityLock;
import org.entityfs.lock.ReadLockRequiredException;
import org.entityfs.security.AccessDeniedException;
import org.entityfs.support.exception.WrappedIOException;
import org.entityfs.support.io.StreamUtil;

public class BZip2ReadableFile
implements ReadableFile {
    static final int BUFFER_SIZE_NOT_SET = -1;
    private final ReadableFile m_adapted;
    private final BZip2ReadableFileSettings m_settings;

    public BZip2ReadableFile(ReadableFile readableFile) {
        this(readableFile, new BZip2ReadableFileSettings());
    }

    @Deprecated
    public BZip2ReadableFile(ReadableFile readableFile, boolean bl) {
        this(readableFile, bl, -1);
    }

    @Deprecated
    public BZip2ReadableFile(ReadableFile readableFile, boolean bl, int n) {
        if (!bl) {
            throw new IllegalArgumentException("This class can no longer handle bzip2 streams that don't start with the magic bytes 'BZ'");
        }
        readableFile.getClass();
        this.m_adapted = readableFile;
        this.m_settings = new BZip2ReadableFileSettings();
        this.m_settings.setBufferSize(n);
    }

    public BZip2ReadableFile(ReadableFile readableFile, BZip2ReadableFileSettings bZip2ReadableFileSettings) {
        readableFile.getClass();
        this.m_adapted = readableFile;
        this.m_settings = bZip2ReadableFileSettings.clone();
    }

    public ReadableByteChannel openChannelForRead() throws ReadLockRequiredException, AccessDeniedException {
        return Channels.newChannel(this.openForRead());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream openForRead() throws ReadLockRequiredException, AccessDeniedException {
        Object object;
        block6: {
            boolean bl = false;
            BufferedInputStream bufferedInputStream = this.m_settings.getBufferSize() == -1 ? new BufferedInputStream(this.m_adapted.openForRead()) : new BufferedInputStream(this.m_adapted.openForRead(), this.m_settings.getBufferSize());
            try {
                Object object2 = this.m_settings.isUseCommonsCompress() ? new BZip2CompressorInputStream((InputStream)bufferedInputStream) : new BZip2InputStream(bufferedInputStream, this.m_settings.getInputStreamSettings());
                bl = true;
                object = object2;
                if (bl) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (!bl) {
                        ((InputStream)bufferedInputStream).close();
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new WrappedIOException(iOException);
                }
            }
            ((InputStream)bufferedInputStream).close();
        }
        return object;
    }

    public EntityLock getReadLock() {
        return this.m_adapted.getReadLock();
    }

    public boolean isReadLockedByCurrentThread() throws IllegalStateException {
        return this.m_adapted.isReadLockedByCurrentThread();
    }

    public EntityLock lockForReading() throws LockTimeoutException {
        return this.m_adapted.lockForReading();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDataSize() throws ReadLockRequiredException, AccessDeniedException {
        long l;
        InputStream inputStream = this.openForRead();
        try {
            l = StreamUtil.getSizeOfDataInStream((InputStream)inputStream, (int)8192) - 2L;
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new WrappedIOException(iOException);
            }
        }
        inputStream.close();
        return l;
    }

    public long getSize() throws ReadLockRequiredException, AccessDeniedException {
        return this.m_adapted.getSize();
    }
}

