/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.bzip2;

import org.at4j.comp.bzip2.BZip2InputStreamSettings;
import org.at4j.support.lang.At4JException;
import org.entityfs.support.log.LogAdapter;

public class BZip2ReadableFileSettings
implements Cloneable {
    private int m_bufferSize = -1;
    private boolean m_useCommonsCompress;
    private LogAdapter m_logAdapter;

    public BZip2ReadableFileSettings setBufferSize(int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid buffer size " + n + ". It must be a positive integer");
        }
        this.m_bufferSize = n;
        return this;
    }

    public int getBufferSize() {
        return this.m_bufferSize;
    }

    public BZip2ReadableFileSettings setUseCommonsCompress(boolean bl) {
        this.m_useCommonsCompress = bl;
        return this;
    }

    public boolean isUseCommonsCompress() {
        return this.m_useCommonsCompress;
    }

    public BZip2ReadableFileSettings setLogAdapter(LogAdapter logAdapter) {
        this.m_logAdapter = logAdapter;
        return this;
    }

    public LogAdapter getLogAdapter() {
        return this.m_logAdapter;
    }

    public BZip2InputStreamSettings getInputStreamSettings() {
        BZip2InputStreamSettings bZip2InputStreamSettings = new BZip2InputStreamSettings();
        bZip2InputStreamSettings.setLogAdapter(this.m_logAdapter);
        return bZip2InputStreamSettings;
    }

    public BZip2ReadableFileSettings clone() {
        try {
            return (BZip2ReadableFileSettings)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new At4JException("Bug", cloneNotSupportedException);
        }
    }
}

