/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.bzip2;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.at4j.comp.CompressionLevel;
import org.at4j.comp.bzip2.BZip2OutputStream;
import org.at4j.comp.bzip2.BZip2WritableFileSettings;
import org.entityfs.WritableFile;
import org.entityfs.exception.LockTimeoutException;
import org.entityfs.exception.ReadOnlyException;
import org.entityfs.lock.EntityLock;
import org.entityfs.lock.WriteLockRequiredException;
import org.entityfs.security.AccessDeniedException;
import org.entityfs.support.exception.WrappedIOException;

public class BZip2WritableFile
implements WritableFile {
    static final int BUFFER_SIZE_NOT_SET = -1;
    private final WritableFile m_adapted;
    private final BZip2WritableFileSettings m_settings;

    private static int getBlockSize(CompressionLevel compressionLevel) {
        switch (compressionLevel) {
            case BEST: {
                return 9;
            }
            case DEFAULT: {
                return 9;
            }
            case FASTEST: {
                return 1;
            }
        }
        throw new RuntimeException("Unknown compression level. This is a bug.");
    }

    public BZip2WritableFile(WritableFile writableFile) {
        this(writableFile, new BZip2WritableFileSettings());
    }

    public BZip2WritableFile(WritableFile writableFile, CompressionLevel compressionLevel) {
        this(writableFile, new BZip2WritableFileSettings().setBlockSize(BZip2WritableFile.getBlockSize(compressionLevel)));
    }

    @Deprecated
    public BZip2WritableFile(WritableFile writableFile, CompressionLevel compressionLevel, boolean bl) {
        this(writableFile, BZip2WritableFile.getBlockSize(compressionLevel), bl, -1);
    }

    @Deprecated
    public BZip2WritableFile(WritableFile writableFile, int n, boolean bl, int n2) throws IllegalArgumentException {
        if (!bl) {
            throw new IllegalArgumentException("Starting with At4J version 1.1, the bzip2 stream header bytes 'BZ' must be written");
        }
        writableFile.getClass();
        if (n < 1 || n > 9) {
            throw new IllegalArgumentException("Invalid block size " + n + ". It must be 1 <= blockSize <= 9");
        }
        if (n2 < 1 && n2 != -1) {
            throw new IllegalArgumentException("Invalid buffer size " + n2 + ". It must be > 0");
        }
        this.m_adapted = writableFile;
        this.m_settings = new BZip2WritableFileSettings();
        this.m_settings.setBlockSize(n);
        this.m_settings.setBufferSize(n2);
    }

    public BZip2WritableFile(WritableFile writableFile, BZip2WritableFileSettings bZip2WritableFileSettings) throws IllegalArgumentException {
        writableFile.getClass();
        bZip2WritableFileSettings.getClass();
        this.m_adapted = writableFile;
        this.m_settings = bZip2WritableFileSettings.clone();
    }

    public WritableByteChannel openChannelForAppend() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Appending to bzip2 compressed files is not supported");
    }

    public WritableByteChannel openChannelForWrite() throws WriteLockRequiredException, AccessDeniedException, ReadOnlyException {
        return Channels.newChannel(this.openForWrite());
    }

    public OutputStream openForAppend() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Appending to bzip2 compressed files is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream openForWrite() throws WriteLockRequiredException, AccessDeniedException, ReadOnlyException {
        Object object;
        block6: {
            OutputStream outputStream = this.m_settings.getBufferSize() == -1 ? this.m_adapted.openForWrite() : new BufferedOutputStream(this.m_adapted.openForWrite(), this.m_settings.getBufferSize());
            boolean bl = false;
            try {
                Object object2 = this.m_settings.isUseCommonsCompress() ? new BZip2CompressorOutputStream(outputStream, this.m_settings.getBlockSize()) : new BZip2OutputStream(outputStream, this.m_settings.getOutputStreamSettings());
                bl = true;
                object = object2;
                if (bl) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (!bl) {
                        outputStream.close();
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new WrappedIOException(iOException);
                }
            }
            outputStream.close();
        }
        return object;
    }

    public EntityLock getWriteLock() {
        return this.m_adapted.getWriteLock();
    }

    public boolean isWriteLockedByCurrentThread() {
        return this.m_adapted.isWriteLockedByCurrentThread();
    }

    public EntityLock lockForWriting() throws LockTimeoutException {
        return this.m_adapted.lockForWriting();
    }
}

