/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.bzip2;

import org.at4j.comp.bzip2.BZip2EncoderExecutorService;
import org.at4j.comp.bzip2.BZip2OutputStreamSettings;
import org.at4j.support.lang.At4JException;
import org.entityfs.support.log.LogAdapter;

public class BZip2WritableFileSettings
implements Cloneable {
    private int m_blockSize = 9;
    private int m_bufferSize = -1;
    private boolean m_useCommonsCompress;
    private LogAdapter m_logAdapter;
    private int m_numberOfEncoderThreads = 0;
    private BZip2EncoderExecutorService m_executorService;
    private int m_numberOfHuffmanTreeRefinementIterations = 5;

    public BZip2WritableFileSettings setBlockSize(int n) throws IllegalArgumentException {
        if (n < 1 || n > 9) {
            throw new IllegalArgumentException("" + n);
        }
        this.m_blockSize = n;
        return this;
    }

    public int getBlockSize() {
        return this.m_blockSize;
    }

    public BZip2WritableFileSettings setBufferSize(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("" + n);
        }
        this.m_bufferSize = n;
        return this;
    }

    public int getBufferSize() {
        return this.m_bufferSize;
    }

    public BZip2WritableFileSettings setUseCommonsCompress(boolean bl) {
        this.m_useCommonsCompress = bl;
        return this;
    }

    public boolean isUseCommonsCompress() {
        return this.m_useCommonsCompress;
    }

    public BZip2WritableFileSettings setLogAdapter(LogAdapter logAdapter) {
        this.m_logAdapter = logAdapter;
        return this;
    }

    public LogAdapter getLogAdapter() {
        return this.m_logAdapter;
    }

    public BZip2WritableFileSettings setNumberOfEncoderThreads(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("" + n);
        }
        this.m_numberOfEncoderThreads = n;
        return this;
    }

    public int getNumberOfEncoderThreads() {
        return this.m_numberOfEncoderThreads;
    }

    public BZip2WritableFileSettings setExecutorService(BZip2EncoderExecutorService bZip2EncoderExecutorService) {
        this.m_executorService = bZip2EncoderExecutorService;
        return this;
    }

    public BZip2EncoderExecutorService getExcutorService() {
        return this.m_executorService;
    }

    public BZip2WritableFileSettings setNumberOfHuffmanTreeRefinementIterations(int n) throws IllegalArgumentException {
        if (n < 1) {
            throw new IllegalArgumentException("Invalid value " + n + ". It must be greater than zero");
        }
        this.m_numberOfHuffmanTreeRefinementIterations = n;
        return this;
    }

    public int getNumberOfHuffmanTreeRefinementIterations() {
        return this.m_numberOfHuffmanTreeRefinementIterations;
    }

    public BZip2OutputStreamSettings getOutputStreamSettings() {
        BZip2OutputStreamSettings bZip2OutputStreamSettings = new BZip2OutputStreamSettings();
        bZip2OutputStreamSettings.setBlockSize(this.m_blockSize);
        bZip2OutputStreamSettings.setExecutorService(this.m_executorService);
        bZip2OutputStreamSettings.setLogAdapter(this.m_logAdapter);
        bZip2OutputStreamSettings.setNumberOfEncoderThreads(this.m_numberOfEncoderThreads);
        bZip2OutputStreamSettings.setNumberOfHuffmanTreeRefinementIterations(this.m_numberOfHuffmanTreeRefinementIterations);
        return bZip2OutputStreamSettings;
    }

    public BZip2WritableFileSettings clone() {
        try {
            return (BZip2WritableFileSettings)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new At4JException("Bug", cloneNotSupportedException);
        }
    }
}

