/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.bzip2;

import java.io.IOException;
import java.util.Arrays;
import org.at4j.comp.bzip2.Block;
import org.at4j.comp.bzip2.BurrowsWheelerDecoder;
import org.at4j.comp.bzip2.CompressedDataBlock;
import org.at4j.comp.bzip2.EosBlock;
import org.at4j.comp.bzip2.HighValueBranchHuffmanTree;
import org.at4j.comp.bzip2.RLEDecodingInputStream;
import org.at4j.support.comp.ByteMoveToFront;
import org.at4j.support.comp.IntMoveToFront;
import org.at4j.support.io.LittleEndianBitInputStream;
import org.at4j.support.lang.At4JException;
import org.at4j.support.lang.UnsignedInteger;
import org.entityfs.support.log.LogAdapter;

final class BlockDecoder {
    private static final byte[] COMPRESSED_BLOCK_MAGIC = new byte[]{49, 65, 89, 38, 83, 89};
    private static final byte[] EOS_BLOCK_MAGIC = new byte[]{23, 114, 69, 56, 80, -112};
    private static final int SYMBOLS_TO_READ_FROM_EACH_TREE = 50;
    private static final int RUNA_SYMBOL = 0;
    private static final int RUNB_SYMBOL = 1;
    private static final int MAX_NO_OF_MTF_SYMBOLS = 258;
    private static final byte[] INITIAL_MOVE_TO_FRONT_ALPHABET = new byte[258];
    private final LittleEndianBitInputStream m_in;
    private final int m_blockSize;
    private final LogAdapter m_logAdapter;
    private int m_readBlockChecksum;
    private int m_originalDataPointer;
    private HighValueBranchHuffmanTree[] m_huffmanTrees;
    private int m_endOfBlockSymbol;
    private int m_numberOfTimesHuffmanTreesAreSwitched;
    private int[] m_treeUse;
    private byte[] m_symbolSequenceNos;
    private int[] m_byteFrequencies;
    private HighValueBranchHuffmanTree m_curTree;
    private int m_symbolsLeftToReadFromCurTree;
    private int m_switchNo;
    private int m_noBytesDecoded;
    private ByteMoveToFront m_mtfTransformer;
    private final byte[] m_decoded;

    BlockDecoder(LittleEndianBitInputStream littleEndianBitInputStream, int n, LogAdapter logAdapter) {
        this.m_in = littleEndianBitInputStream;
        this.m_blockSize = n;
        this.m_logAdapter = logAdapter;
        this.m_decoded = new byte[n];
    }

    private void throwIOException(String string) throws IOException {
        throw new IOException(string + ". Position in input stream: " + this.m_in.getNumberOfBytesRead());
    }

    private void checkInterrupted() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    private void trace(String string) {
        if (this.m_logAdapter != null) {
            this.m_logAdapter.logTrace((Object)string);
        }
    }

    static HighValueBranchHuffmanTree decodeHuffmanTree(int n, LittleEndianBitInputStream littleEndianBitInputStream) throws IOException {
        int[] nArray = new int[n];
        int n2 = littleEndianBitInputStream.readBits(5);
        if (n2 > 20) {
            throw new IOException("Invalid starting bit length for Huffman deltas: " + n2 + ". Must be <= 20");
        }
        int n3 = 20;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            while (littleEndianBitInputStream.readBit()) {
                if ((n2 += littleEndianBitInputStream.readBit() ? -1 : 1) >= 1 && n2 <= 20) continue;
                throw new IOException("Invalid bit length " + n2);
            }
            nArray[i] = n2;
            if (n2 < n3) {
                n3 = n2;
            }
            if (n2 <= n4) continue;
            n4 = n2;
        }
        return new HighValueBranchHuffmanTree(nArray, n3, n4, false);
    }

    private void readCompressedBlockHeader() throws IOException {
        int n;
        int n2;
        int n3;
        byte[] byArray = new byte[4];
        this.m_readBlockChecksum = (int)UnsignedInteger.fromLittleEndianByteArrayToLong(this.m_in.readBytes(byArray, 0, 4), 0);
        if (this.m_in.readBit()) {
            this.throwIOException("Randomized block mode is not supported");
        }
        this.m_in.readBytes(byArray, 1, 3);
        byArray[0] = 0;
        this.m_originalDataPointer = (int)UnsignedInteger.fromLittleEndianByteArrayToLong(byArray, 0);
        if (this.m_originalDataPointer > this.m_blockSize) {
            throw new IOException("Invalid starting pointer " + this.m_originalDataPointer + ". It must be less than the block size " + this.m_blockSize);
        }
        boolean[] blArray = new boolean[256];
        int n4 = 0;
        boolean[] blArray2 = new boolean[16];
        for (n3 = 0; n3 < 16; ++n3) {
            blArray2[n3] = this.m_in.readBit();
        }
        for (n3 = 0; n3 < 16; ++n3) {
            if (!blArray2[n3]) continue;
            for (n2 = 0; n2 < 16; ++n2) {
                if (!this.m_in.readBit()) continue;
                blArray[n3 * 16 + n2] = true;
                ++n4;
            }
        }
        if (n4 == 0) {
            this.throwIOException("No symbols used in table");
        }
        this.m_symbolSequenceNos = new byte[n4];
        n3 = 0;
        for (n2 = 0; n2 < 256; ++n2) {
            if (!blArray[n2]) continue;
            this.m_symbolSequenceNos[n3++] = (byte)(n2 & 0xFF);
        }
        assert (n3 == n4);
        this.m_byteFrequencies = new int[256];
        n2 = this.m_in.readBits(3);
        if (n2 < 2 || n2 > 6) {
            this.throwIOException("Invalid number of Huffman trees " + n2 + ". Must be between 2 and 6 (inclusive)");
        }
        this.m_numberOfTimesHuffmanTreesAreSwitched = this.m_in.readBitsLittleEndian(15);
        if (this.m_numberOfTimesHuffmanTreesAreSwitched < 1) {
            this.throwIOException("Invalid number of times the Huffman trees are switched in the input: " + this.m_numberOfTimesHuffmanTreesAreSwitched);
        }
        int[] nArray = new int[this.m_numberOfTimesHuffmanTreesAreSwitched];
        for (int i = 0; i < this.m_numberOfTimesHuffmanTreesAreSwitched; ++i) {
            nArray[i] = 0;
            while (this.m_in.readBit()) {
                int n5 = i;
                nArray[n5] = nArray[n5] + 1;
            }
            if (nArray[i] <= n2) continue;
            this.throwIOException("Invalid Huffman tree use MTF " + nArray[i] + ". Must be less than the number of Huffman trees, " + n2);
        }
        this.m_treeUse = new int[this.m_numberOfTimesHuffmanTreesAreSwitched];
        int[] nArray2 = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray2[n] = n;
        }
        new IntMoveToFront(nArray2).decode(nArray, this.m_treeUse);
        n = n4 + 2;
        this.m_huffmanTrees = new HighValueBranchHuffmanTree[n2];
        for (int i = 0; i < n2; ++i) {
            this.m_huffmanTrees[i] = BlockDecoder.decodeHuffmanTree(n, this.m_in);
        }
        this.m_endOfBlockSymbol = n - 1;
    }

    private void selectNewHuffmanTree() throws IOException {
        if (this.m_switchNo >= this.m_numberOfTimesHuffmanTreesAreSwitched) {
            this.throwIOException("One Huffman tree switch too many: " + this.m_switchNo);
        }
        this.m_symbolsLeftToReadFromCurTree = 50;
        this.m_curTree = this.m_huffmanTrees[this.m_treeUse[this.m_switchNo]];
        ++this.m_switchNo;
    }

    private int readSymbol() throws IOException {
        if (this.m_symbolsLeftToReadFromCurTree == 0) {
            this.selectNewHuffmanTree();
        }
        int n = this.m_curTree.readNext(this.m_in);
        --this.m_symbolsLeftToReadFromCurTree;
        return n;
    }

    private void decodeSingleByte(int n) throws IOException {
        int n2 = this.m_mtfTransformer.decode(n - 1) & 0xFF;
        byte by = this.m_symbolSequenceNos[n2];
        this.m_decoded[this.m_noBytesDecoded++] = by;
        int n3 = by & 0xFF;
        this.m_byteFrequencies[n3] = this.m_byteFrequencies[n3] + 1;
    }

    private int handleRunaAndRunb(int n) throws IOException {
        int n2 = 1;
        int n3 = 0;
        while (n == 0 || n == 1) {
            n3 = n == 0 ? (n3 += n2) : (n3 += 2 * n2);
            n2 <<= 1;
            n = this.readSymbol();
        }
        int n4 = this.m_mtfTransformer.decode(0) & 0xFF;
        byte by = this.m_symbolSequenceNos[n4];
        if (n3 == 1) {
            this.m_decoded[this.m_noBytesDecoded++] = by;
            int n5 = by & 0xFF;
            this.m_byteFrequencies[n5] = this.m_byteFrequencies[n5] + 1;
        } else {
            Arrays.fill(this.m_decoded, this.m_noBytesDecoded, this.m_noBytesDecoded + n3, by);
            this.m_noBytesDecoded += n3;
            int n6 = by & 0xFF;
            this.m_byteFrequencies[n6] = this.m_byteFrequencies[n6] + n3;
        }
        return n;
    }

    CompressedDataBlock readCompressedDataBlock() throws IOException, InterruptedException {
        this.readCompressedBlockHeader();
        int n = this.readSymbol();
        while (true) {
            this.checkInterrupted();
            if (n == 0 || n == 1) {
                n = this.handleRunaAndRunb(n);
                continue;
            }
            if (n == this.m_endOfBlockSymbol) {
                BurrowsWheelerDecoder burrowsWheelerDecoder = new BurrowsWheelerDecoder(this.m_decoded, this.m_noBytesDecoded, this.m_byteFrequencies, this.m_originalDataPointer);
                return new CompressedDataBlock(new RLEDecodingInputStream(burrowsWheelerDecoder.decode(), this.m_readBlockChecksum), this.m_readBlockChecksum);
            }
            this.decodeSingleByte(n);
            n = this.readSymbol();
        }
    }

    private void initDecoderState() {
        byte[] byArray = new byte[258];
        System.arraycopy(INITIAL_MOVE_TO_FRONT_ALPHABET, 0, byArray, 0, 258);
        this.m_mtfTransformer = new ByteMoveToFront(byArray);
        this.m_curTree = null;
        this.m_symbolsLeftToReadFromCurTree = 0;
        this.m_switchNo = 0;
        this.m_noBytesDecoded = 0;
    }

    Block getNextBlock() throws IOException {
        this.initDecoderState();
        byte[] byArray = new byte[6];
        this.m_in.readBytes(byArray, 0, 6);
        if (Arrays.equals(COMPRESSED_BLOCK_MAGIC, byArray)) {
            this.trace("Found block of compressed data");
            try {
                return this.readCompressedDataBlock();
            }
            catch (InterruptedException interruptedException) {
                throw new At4JException(interruptedException);
            }
        }
        if (Arrays.equals(EOS_BLOCK_MAGIC, byArray)) {
            this.trace("Found end of stream block");
            this.m_in.readBytes(byArray, 0, 4);
            int n = (int)UnsignedInteger.fromLittleEndianByteArrayToLong(byArray, 0);
            return new EosBlock(n);
        }
        this.throwIOException("Invalid block header " + Arrays.toString(byArray) + ". Expected compressed data block or end of stream block");
        return null;
    }

    static {
        for (int i = 0; i < 258; ++i) {
            BlockDecoder.INITIAL_MOVE_TO_FRONT_ALPHABET[i] = (byte)i;
        }
    }
}

