/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.bzip2;

import java.io.IOException;
import java.util.Arrays;
import org.at4j.comp.bzip2.BlockEncodedCallback;
import org.at4j.comp.bzip2.BurrowsWheelerEncoder;
import org.at4j.comp.bzip2.EncodingScratchpad;
import org.at4j.comp.bzip2.HighValueBranchHuffmanTree;
import org.at4j.support.comp.IntMoveToFront;
import org.at4j.support.io.BitOutput;
import org.entityfs.support.log.LogAdapter;

final class BlockEncoder {
    private static final byte[] BLOCK_MAGIC = new byte[]{49, 65, 89, 38, 83, 89};
    private static final int MAX_HUFFMAN_BIT_LENGTH = 17;
    private static final int RUNA_SYMBOL = 0;
    private static final int RUNB_SYMBOL = 1;
    private static final int MIN_NO_OF_HUFFMAN_TREES = 2;
    static final int MAX_NO_OF_HUFFMAN_TREES = 6;
    static final int MAX_NO_OF_MTF_SYMBOLS = 258;
    static final int NO_OF_SYMBOLS_PER_SEGMENT = 50;
    static final int[][] CATEGORY_PER_NO_OF_TREES_AND_PERCENTAGE = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5}};
    private static final byte[] INITIAL_MTF_ALPHABET = new byte[258];
    private final byte[] m_block;
    private final int m_blockNo;
    private final int m_blockSize;
    private final int m_blockChecksum;
    private final boolean[] m_seenDifferentBytes;
    private final int m_numberOfSeenDifferentBytes;
    private final int m_numberOfHuffmanTreeRefinementIterations;
    private final LogAdapter m_logAdapter;
    private final BitOutput m_out;
    private final BlockEncodedCallback m_blockEncoderCallback;
    private EncodingScratchpad m_scratchpad;

    BlockEncoder(byte[] byArray, int n, int n2, int n3, boolean[] blArray, int n4, int n5, BitOutput bitOutput, BlockEncodedCallback blockEncodedCallback, LogAdapter logAdapter) {
        this.m_block = byArray;
        this.m_blockNo = n;
        this.m_blockSize = n2;
        this.m_blockChecksum = n3;
        this.m_seenDifferentBytes = blArray;
        this.m_numberOfSeenDifferentBytes = n4;
        this.m_numberOfHuffmanTreeRefinementIterations = n5;
        this.m_logAdapter = logAdapter;
        this.m_out = bitOutput;
        this.m_blockEncoderCallback = blockEncodedCallback;
    }

    void setScratchpad(EncodingScratchpad encodingScratchpad) {
        this.m_scratchpad = encodingScratchpad;
    }

    private byte[] getSeenByteValues() {
        byte[] byArray = new byte[this.m_numberOfSeenDifferentBytes];
        int n = 0;
        for (int i = 0; i < 256; ++i) {
            if (!this.m_seenDifferentBytes[i]) continue;
            byArray[n++] = (byte)(i & 0xFF);
        }
        assert (n == this.m_numberOfSeenDifferentBytes);
        return byArray;
    }

    static int addRunaAndRunb(int[] nArray, int n, int n2) {
        int n3 = 0;
        while (n2 > 0) {
            switch (n2 % 2) {
                case 1: {
                    nArray[n + n3++] = 0;
                    --n2;
                    break;
                }
                case 0: {
                    nArray[n + n3++] = 1;
                    n2 -= 2;
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            n2 >>>= 1;
        }
        return n3;
    }

    private byte[] createSequenceMap(byte[] byArray) {
        byte[] byArray2 = this.m_scratchpad.m_sequenceMap;
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            int n2 = n;
            n = (byte)(n + 1);
            byArray2[byArray[i] & 0xFF] = n2;
        }
        return byArray2;
    }

    private MTFAndRLEResult moveToFrontAndRunLengthEncode(byte[] byArray, int n, byte[] byArray2) {
        boolean[] blArray = new boolean[259];
        blArray[0] = true;
        blArray[1] = true;
        int n2 = 2;
        byte[] byArray3 = this.m_scratchpad.m_mtfAlphabet;
        System.arraycopy(INITIAL_MTF_ALPHABET, 0, byArray3, 0, byArray3.length);
        int[] nArray = this.m_scratchpad.m_encodedData;
        byte[] byArray4 = this.createSequenceMap(byArray2);
        byte by = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            int n5;
            byte by2 = byArray4[byArray[i] & 0xFF];
            if (by2 == by) {
                ++n4;
                continue;
            }
            if (n4 > 0) {
                n3 += BlockEncoder.addRunaAndRunb(this.m_scratchpad.m_encodedData, n3, n4);
                n4 = 0;
            }
            int n6 = 0;
            int n7 = byArray3[0];
            while (byArray3[++n6] != by2) {
                n5 = byArray3[n6];
                byArray3[n6] = n7;
                n7 = n5;
            }
            byArray3[n6] = n7;
            byArray3[0] = by2;
            n5 = n6 + 1;
            nArray[n3++] = n5;
            if (!blArray[n5]) {
                blArray[n5] = true;
                ++n2;
            }
            by = by2;
        }
        if (n4 > 0) {
            n3 += BlockEncoder.addRunaAndRunb(nArray, n3, n4);
        }
        return new MTFAndRLEResult(nArray, n3, n2);
    }

    private void encodeAllSegmentsWithAllTrees(int[] nArray, int n, int[][] nArray2, int n2, int n3, EncodeAllSegmentsResult encodeAllSegmentsResult) throws IOException {
        int n4 = nArray2.length;
        int[][] nArray3 = this.m_scratchpad.m_encodingResults;
        int[] nArray4 = new int[n2];
        int n5 = Integer.MAX_VALUE;
        int n6 = 0;
        for (int i = 0; i < n2; ++i) {
            int n7 = Integer.MAX_VALUE;
            int n8 = 0;
            int[] nArray5 = new int[n4];
            int n9 = i * 50;
            int n10 = Math.min(n9 + 50, n);
            for (int j = 0; j < n4; ++j) {
                int[] nArray6 = nArray2[j];
                int n11 = 0;
                for (int k = n9; k < n10; ++k) {
                    n11 += nArray6[nArray[k]];
                }
                if (j == 0) {
                    n7 = n11;
                } else if (n11 < n7) {
                    n7 = n11;
                    n8 = j;
                }
                nArray5[j] = n11;
            }
            if (i == 0) {
                n5 = n6 = n7;
            } else if (i < n2 - 1 && n7 < n5) {
                n5 = n7;
            } else if (n7 > n6) {
                n6 = n7;
            }
            nArray3[i] = nArray5;
            nArray4[i] = n8;
        }
        EncodeAllSegmentsResult.access$102(encodeAllSegmentsResult, nArray3);
        encodeAllSegmentsResult.m_longestLength = n6;
        encodeAllSegmentsResult.m_shortestLength = n5;
        EncodeAllSegmentsResult.access$402(encodeAllSegmentsResult, nArray4);
    }

    private int[][] createNewTrees(int[] nArray, int n, int n2, int n3, int n4, EncodeAllSegmentsResult encodeAllSegmentsResult, int[] nArray2) {
        int n5;
        int n6;
        int n7;
        int n8;
        int[][] nArray3 = this.m_scratchpad.m_frequencies2d;
        for (n8 = 0; n8 < n3; ++n8) {
            Arrays.fill(nArray3[n8], 0);
        }
        n8 = encodeAllSegmentsResult.m_longestLength - encodeAllSegmentsResult.m_shortestLength;
        if (n8 == 0) {
            return new int[][]{nArray2};
        }
        int n9 = n3;
        int[] nArray4 = this.m_scratchpad.m_categoriesPerSegment;
        int[] nArray5 = new int[n9];
        int[] nArray6 = CATEGORY_PER_NO_OF_TREES_AND_PERCENTAGE[n3 - 2];
        for (n7 = 0; n7 < n4 - 1; ++n7) {
            int n10;
            n6 = encodeAllSegmentsResult.m_encodingResults[n7][encodeAllSegmentsResult.m_treesUsed[n7]];
            n5 = 100 * (n6 - encodeAllSegmentsResult.m_shortestLength) / n8;
            assert (n5 >= 0);
            assert (n5 <= 100);
            int n11 = n10 = nArray6[n5];
            nArray5[n11] = nArray5[n11] + 1;
            nArray4[n7] = n10;
        }
        for (n7 = 0; n7 < n4; ++n7) {
            n6 = n7 * 50;
            n5 = Math.min(n6 + 50, n);
            int[] nArray7 = nArray3[nArray4[n7]];
            for (int i = n6; i < n5; ++i) {
                int n12 = nArray[i];
                nArray7[n12] = nArray7[n12] + 1;
            }
        }
        n7 = 0;
        for (n6 = 0; n6 < n9; ++n6) {
            if (nArray5[n6] <= 0) continue;
            ++n7;
        }
        assert (n7 > 0);
        int[][] nArrayArray = new int[n7][];
        n5 = 0;
        for (int i = 0; i < n9; ++i) {
            if (nArray5[i] <= 0) continue;
            nArrayArray[n5++] = HighValueBranchHuffmanTree.createCodeLengths(nArray3[i], n2 + 1, 17, this.m_scratchpad);
        }
        return nArrayArray;
    }

    private int[][] refineTreesBasedOnEncodingResults(int[] nArray, int n, int[][] nArray2, EncodeAllSegmentsResult encodeAllSegmentsResult, int n2) {
        int n3;
        int n4;
        int[][] nArray3 = this.m_scratchpad.m_frequencies2d;
        for (n4 = 0; n4 < nArray2.length; ++n4) {
            Arrays.fill(nArray3[n4], 0);
        }
        n4 = 0;
        int n5 = 0;
        int n6 = encodeAllSegmentsResult.m_treesUsed[n4];
        for (int i = 0; i < n; ++i) {
            n3 = nArray[i];
            int[] nArray4 = nArray3[n6];
            int n7 = n3;
            nArray4[n7] = nArray4[n7] + 1;
            if (++n5 != 50) continue;
            if (++n4 < encodeAllSegmentsResult.m_treesUsed.length) {
                n6 = encodeAllSegmentsResult.m_treesUsed[n4];
            }
            n5 = 0;
        }
        int[][] nArrayArray = new int[nArray2.length][];
        for (n3 = 0; n3 < nArray2.length; ++n3) {
            nArrayArray[n3] = HighValueBranchHuffmanTree.createCodeLengths(nArray3[n3], n2 + 1, 17, this.m_scratchpad);
        }
        return nArrayArray;
    }

    private byte getNumberOfHuffmanTrees(int n) {
        if (n < 200) {
            return 2;
        }
        if (n < 600) {
            return 3;
        }
        if (n < 1200) {
            return 4;
        }
        if (n < 2400) {
            return 5;
        }
        return 6;
    }

    private int[] getMinAndMaxCodeLengths(int[] nArray) {
        int n = nArray[0];
        int n2 = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] < n) {
                n = nArray[i];
                continue;
            }
            if (nArray[i] <= n2) continue;
            n2 = nArray[i];
        }
        return new int[]{n, n2};
    }

    private HuffmanTreesAndUsage createHuffmanTrees(int[] nArray, int n, int n2) throws IOException {
        int n3;
        HuffmanTreesAndUsage huffmanTreesAndUsage = new HuffmanTreesAndUsage();
        huffmanTreesAndUsage.m_noHuffmanSegments = (n - 1 + 1) / 50 + 1;
        int[] nArray2 = this.m_scratchpad.m_frequencies;
        Arrays.fill(nArray2, 0);
        int n4 = 1;
        for (n3 = 0; n3 < n; ++n3) {
            int n5;
            int n6 = n5 = nArray[n3];
            nArray2[n6] = nArray2[n6] + 1;
            if (n5 <= n4) continue;
            n4 = n5;
        }
        huffmanTreesAndUsage.m_eobSymbol = n4 + 1;
        nArray2[((HuffmanTreesAndUsage)huffmanTreesAndUsage).m_eobSymbol] = 1;
        nArray[n] = huffmanTreesAndUsage.m_eobSymbol;
        n3 = n + 1;
        if (huffmanTreesAndUsage.m_noHuffmanSegments < 2) {
            HuffmanTreesAndUsage.access$802(huffmanTreesAndUsage, new HighValueBranchHuffmanTree[2]);
            int[] nArray3 = HighValueBranchHuffmanTree.createCodeLengths(nArray2, huffmanTreesAndUsage.m_eobSymbol + 1, 17, this.m_scratchpad);
            int[] nArray4 = this.getMinAndMaxCodeLengths(nArray3);
            HighValueBranchHuffmanTree highValueBranchHuffmanTree = new HighValueBranchHuffmanTree(nArray3, nArray4[0], nArray4[1], true);
            for (int i = 0; i < 2; ++i) {
                ((HuffmanTreesAndUsage)huffmanTreesAndUsage).m_trees[i] = highValueBranchHuffmanTree;
            }
            HuffmanTreesAndUsage.access$902(huffmanTreesAndUsage, new int[huffmanTreesAndUsage.m_noHuffmanSegments]);
        } else {
            int n7;
            int n8;
            int n9;
            int[][][] nArrayArray = new int[this.m_numberOfHuffmanTreeRefinementIterations + 1][][];
            int[] nArray5 = HighValueBranchHuffmanTree.createCodeLengths(nArray2, huffmanTreesAndUsage.m_eobSymbol + 1, 17, this.m_scratchpad);
            EncodeAllSegmentsResult encodeAllSegmentsResult = new EncodeAllSegmentsResult();
            this.encodeAllSegmentsWithAllTrees(nArray, n, new int[][]{nArray5}, huffmanTreesAndUsage.m_noHuffmanSegments, huffmanTreesAndUsage.m_eobSymbol + 1, encodeAllSegmentsResult);
            nArrayArray[0] = this.createNewTrees(nArray, n, huffmanTreesAndUsage.m_eobSymbol, this.getNumberOfHuffmanTrees(huffmanTreesAndUsage.m_noHuffmanSegments), huffmanTreesAndUsage.m_noHuffmanSegments, encodeAllSegmentsResult, nArray5);
            int n10 = -1;
            int n11 = Integer.MAX_VALUE;
            int[] nArray6 = null;
            for (n9 = 0; n9 < nArrayArray.length; ++n9) {
                if (n9 > 0) {
                    nArrayArray[n9] = this.refineTreesBasedOnEncodingResults(nArray, n3, nArrayArray[n9 - 1], encodeAllSegmentsResult, huffmanTreesAndUsage.m_eobSymbol);
                }
                this.encodeAllSegmentsWithAllTrees(nArray, n3, nArrayArray[n9], huffmanTreesAndUsage.m_noHuffmanSegments, huffmanTreesAndUsage.m_eobSymbol + 1, encodeAllSegmentsResult);
                n8 = 0;
                for (n7 = 0; n7 < encodeAllSegmentsResult.m_treesUsed.length; ++n7) {
                    n8 += encodeAllSegmentsResult.m_encodingResults[n7][encodeAllSegmentsResult.m_treesUsed[n7]];
                }
                if (this.m_logAdapter != null) {
                    this.m_logAdapter.logTrace((Object)("Block " + this.m_blockNo + ", pass: " + n9 + ", length: " + n8));
                }
                if (n8 >= n11) continue;
                n10 = n9;
                n11 = n8;
                nArray6 = encodeAllSegmentsResult.m_treesUsed;
            }
            if (this.m_logAdapter != null) {
                this.m_logAdapter.logTrace((Object)("Block " + this.m_blockNo + ", best length: " + n11));
            }
            if ((n9 = nArrayArray[n10].length) < 2) {
                HuffmanTreesAndUsage.access$802(huffmanTreesAndUsage, new HighValueBranchHuffmanTree[2]);
                int[] nArray7 = this.getMinAndMaxCodeLengths(nArrayArray[n10][0]);
                for (n7 = 0; n7 < 2; ++n7) {
                    ((HuffmanTreesAndUsage)huffmanTreesAndUsage).m_trees[n7] = new HighValueBranchHuffmanTree(nArrayArray[n10][0], nArray7[0], nArray7[1], true);
                }
            } else {
                HuffmanTreesAndUsage.access$802(huffmanTreesAndUsage, new HighValueBranchHuffmanTree[nArrayArray[n10].length]);
                for (n8 = 0; n8 < nArrayArray[n10].length; ++n8) {
                    int[] nArray8 = this.getMinAndMaxCodeLengths(nArrayArray[n10][n8]);
                    ((HuffmanTreesAndUsage)huffmanTreesAndUsage).m_trees[n8] = new HighValueBranchHuffmanTree(nArrayArray[n10][n8], nArray8[0], nArray8[1], true);
                }
            }
            HuffmanTreesAndUsage.access$902(huffmanTreesAndUsage, nArray6);
        }
        return huffmanTreesAndUsage;
    }

    static void encodeHuffmanTree(HighValueBranchHuffmanTree highValueBranchHuffmanTree, int n, BitOutput bitOutput) throws IOException {
        int n2 = highValueBranchHuffmanTree.getBitLength(0);
        bitOutput.writeBitsLittleEndian(n2, 5);
        for (int i = 0; i < n; ++i) {
            int n3 = n2;
            n2 = highValueBranchHuffmanTree.getBitLength(i);
            while (n2 != n3) {
                bitOutput.writeBit(true);
                if (n3 < n2) {
                    bitOutput.writeBit(false);
                    ++n3;
                    continue;
                }
                bitOutput.writeBit(true);
                --n3;
            }
            bitOutput.writeBit(false);
        }
    }

    private void writeBlockHeader(int n, int n2, boolean[] blArray, MTFAndRLEResult mTFAndRLEResult, HuffmanTreesAndUsage huffmanTreesAndUsage) throws IOException {
        int n3;
        int n4;
        int n5;
        for (int i = 0; i < BLOCK_MAGIC.length; ++i) {
            this.m_out.writeBitsLittleEndian(BLOCK_MAGIC[i] & 0xFF, 8);
        }
        this.m_out.writeBitsLittleEndian(n, 32);
        this.m_out.writeBit(false);
        this.m_out.writeBitsLittleEndian(n2, 24);
        boolean[] blArray2 = new boolean[16];
        boolean[][] blArray3 = new boolean[16][16];
        for (n5 = 0; n5 < 256; ++n5) {
            if (!blArray[n5]) continue;
            blArray2[n5 / 16] = true;
            blArray3[n5 / 16][n5 % 16] = true;
        }
        for (n5 = 0; n5 < 16; ++n5) {
            this.m_out.writeBit(blArray2[n5]);
        }
        for (n5 = 0; n5 < 16; ++n5) {
            if (!blArray2[n5]) continue;
            for (n4 = 0; n4 < 16; ++n4) {
                this.m_out.writeBit(blArray3[n5][n4]);
            }
        }
        this.m_out.writeBits(huffmanTreesAndUsage.m_trees.length, 3);
        this.m_out.writeBitsLittleEndian(huffmanTreesAndUsage.m_noHuffmanSegments, 15);
        int[] nArray = new int[huffmanTreesAndUsage.m_trees.length];
        for (n4 = 0; n4 < huffmanTreesAndUsage.m_trees.length; ++n4) {
            nArray[n4] = n4;
        }
        int[] nArray2 = new int[huffmanTreesAndUsage.m_noHuffmanSegments];
        new IntMoveToFront(nArray).encode(huffmanTreesAndUsage.m_treeUsage, nArray2);
        for (n3 = 0; n3 < huffmanTreesAndUsage.m_noHuffmanSegments; ++n3) {
            for (int i = 0; i < nArray2[n3]; ++i) {
                this.m_out.writeBit(true);
            }
            this.m_out.writeBit(false);
        }
        for (n3 = 0; n3 < huffmanTreesAndUsage.m_trees.length; ++n3) {
            BlockEncoder.encodeHuffmanTree(huffmanTreesAndUsage.m_trees[n3], huffmanTreesAndUsage.m_eobSymbol + 1, this.m_out);
        }
    }

    void encode() throws IOException {
        int n;
        for (int i = 0; i < 20; i += n) {
            n = Math.min(20 - i, this.m_blockSize);
            System.arraycopy(this.m_block, 0, this.m_block, this.m_blockSize + i, n);
        }
        BurrowsWheelerEncoder.BurrowsWheelerEncodingResult burrowsWheelerEncodingResult = new BurrowsWheelerEncoder(this.m_block, this.m_blockSize, this.m_scratchpad).encode();
        MTFAndRLEResult mTFAndRLEResult = this.moveToFrontAndRunLengthEncode(burrowsWheelerEncodingResult.m_lastColumn, this.m_blockSize, this.getSeenByteValues());
        int[] nArray = mTFAndRLEResult.m_encodedData;
        HuffmanTreesAndUsage huffmanTreesAndUsage = this.createHuffmanTrees(mTFAndRLEResult.m_encodedData, mTFAndRLEResult.m_dataLen, mTFAndRLEResult.m_noSeenDifferentSymbols);
        this.writeBlockHeader(this.m_blockChecksum, burrowsWheelerEncodingResult.m_firstPointer, this.m_seenDifferentBytes, mTFAndRLEResult, huffmanTreesAndUsage);
        int n2 = 0;
        int n3 = 1;
        HighValueBranchHuffmanTree highValueBranchHuffmanTree = null;
        for (int i = 0; i < mTFAndRLEResult.m_dataLen + 1; ++i) {
            if (--n3 == 0) {
                highValueBranchHuffmanTree = huffmanTreesAndUsage.m_trees[huffmanTreesAndUsage.m_treeUsage[n2++]];
                n3 = 50;
            }
            highValueBranchHuffmanTree.write(this.m_out, nArray[i]);
        }
        assert (n2 == huffmanTreesAndUsage.m_noHuffmanSegments);
        if (this.m_blockEncoderCallback != null) {
            this.m_blockEncoderCallback.reportBlockDone();
        }
    }

    static {
        for (int i = 0; i < INITIAL_MTF_ALPHABET.length; ++i) {
            BlockEncoder.INITIAL_MTF_ALPHABET[i] = (byte)(i & 0xFF);
        }
    }

    private static class HuffmanTreesAndUsage {
        private HighValueBranchHuffmanTree[] m_trees;
        private int m_noHuffmanSegments;
        private int[] m_treeUsage;
        private int m_eobSymbol;

        private HuffmanTreesAndUsage() {
        }

        static /* synthetic */ HighValueBranchHuffmanTree[] access$802(HuffmanTreesAndUsage huffmanTreesAndUsage, HighValueBranchHuffmanTree[] highValueBranchHuffmanTreeArray) {
            huffmanTreesAndUsage.m_trees = highValueBranchHuffmanTreeArray;
            return highValueBranchHuffmanTreeArray;
        }

        static /* synthetic */ int[] access$902(HuffmanTreesAndUsage huffmanTreesAndUsage, int[] nArray) {
            huffmanTreesAndUsage.m_treeUsage = nArray;
            return nArray;
        }
    }

    private static class EncodeAllSegmentsResult {
        private int m_shortestLength;
        private int m_longestLength;
        private int[][] m_encodingResults;
        private int[] m_treesUsed;

        private EncodeAllSegmentsResult() {
        }

        static /* synthetic */ int[][] access$102(EncodeAllSegmentsResult encodeAllSegmentsResult, int[][] nArray) {
            encodeAllSegmentsResult.m_encodingResults = nArray;
            return nArray;
        }

        static /* synthetic */ int[] access$402(EncodeAllSegmentsResult encodeAllSegmentsResult, int[] nArray) {
            encodeAllSegmentsResult.m_treesUsed = nArray;
            return nArray;
        }
    }

    private static class MTFAndRLEResult {
        private final int[] m_encodedData;
        private final int m_dataLen;
        private final int m_noSeenDifferentSymbols;

        private MTFAndRLEResult(int[] nArray, int n, int n2) {
            this.m_encodedData = nArray;
            this.m_dataLen = n;
            this.m_noSeenDifferentSymbols = n2;
        }
    }
}

