/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.bzip2;

import java.io.IOException;
import org.at4j.comp.bzip2.BlockEncoder;
import org.at4j.comp.bzip2.EncodingThread;
import org.entityfs.support.log.LogAdapter;

final class BlockEncoderRunnable
implements Runnable {
    private final BlockEncoder m_encoder;
    private final Object m_errorOwner;
    private final LogAdapter m_logAdapter;

    BlockEncoderRunnable(BlockEncoder blockEncoder, Object object, LogAdapter logAdapter) {
        this.m_encoder = blockEncoder;
        this.m_errorOwner = object;
        this.m_logAdapter = logAdapter;
    }

    public void run() {
        try {
            this.m_encoder.setScratchpad(((EncodingThread)Thread.currentThread()).getScratchpad());
            this.m_encoder.encode();
        }
        catch (IOException iOException) {
            if (this.m_logAdapter != null) {
                this.m_logAdapter.logError((Throwable)iOException);
            }
            ((EncodingThread)Thread.currentThread()).getErrorState().registerError(iOException, this.m_errorOwner);
        }
        catch (RuntimeException runtimeException) {
            if (this.m_logAdapter != null) {
                this.m_logAdapter.logError((Throwable)runtimeException);
            }
            ((EncodingThread)Thread.currentThread()).getErrorState().registerError(runtimeException, this.m_errorOwner);
        }
        catch (Error error) {
            if (this.m_logAdapter != null) {
                this.m_logAdapter.logError((Throwable)error);
            }
            ((EncodingThread)Thread.currentThread()).getErrorState().registerError(error, this.m_errorOwner);
        }
    }
}

