/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.bzip2;

import java.io.IOException;
import java.io.InputStream;

final class BurrowsWheelerDecoder {
    private final byte[] m_decoded;
    private final int m_noBytesDecoded;
    private final int[] m_byteFrequencies;
    private final int m_originalDataPointer;

    BurrowsWheelerDecoder(byte[] byArray, int n, int[] nArray, int n2) throws IOException {
        if (n2 > n) {
            throw new IOException("Invalid pointer to original data in block header " + n2 + ". It is larger than the size of data in the block " + n);
        }
        this.m_decoded = byArray;
        this.m_noBytesDecoded = n;
        this.m_byteFrequencies = nArray;
        this.m_originalDataPointer = n2;
    }

    InputStream decode() {
        int[] nArray = new int[256];
        nArray[0] = 0;
        for (int i = 1; i < 256; ++i) {
            nArray[i] = nArray[i - 1] + this.m_byteFrequencies[i - 1];
        }
        int[] nArray2 = new int[this.m_noBytesDecoded];
        int n = 0;
        while (n < this.m_noBytesDecoded) {
            int n2;
            int n3 = n2 = this.m_decoded[n] & 0xFF;
            nArray[n3] = nArray[n3] + 1;
            nArray2[var5_6] = n++;
        }
        return new BWInputStream(this.m_decoded, nArray2, this.m_originalDataPointer);
    }

    static class BWInputStream
    extends InputStream {
        private final byte[] m_decoded;
        private final int[] m_ptr;
        private int m_curPointer;
        private boolean m_eof;
        private int m_noLeftToRead;

        BWInputStream(byte[] byArray, int[] nArray, int n) {
            this.m_decoded = byArray;
            this.m_ptr = nArray;
            this.m_curPointer = nArray[n];
            this.m_noLeftToRead = nArray.length;
        }

        public int read() throws IOException {
            if (this.m_eof) {
                return -1;
            }
            int n = this.m_decoded[this.m_curPointer] & 0xFF;
            this.m_eof = --this.m_noLeftToRead == 0;
            this.m_curPointer = this.m_ptr[this.m_curPointer];
            return n;
        }
    }
}

