/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.bzip2;

import org.at4j.comp.bzip2.EncodingScratchpad;
import org.at4j.comp.bzip2.ThreeWayRadixQuicksort;

final class BurrowsWheelerEncoder {
    private static int MIN_QUICKSORT_LENGTH = 18;
    private final byte[] m_data;
    private final int m_length;
    private final EncodingScratchpad m_scratchpad;

    BurrowsWheelerEncoder(byte[] byArray, int n, EncodingScratchpad encodingScratchpad) {
        if (n > byArray.length) {
            throw new IllegalArgumentException("Invalid data length " + n + ". It must be <= the length of the data array (" + byArray.length + ")");
        }
        this.m_data = byArray;
        this.m_length = n;
        this.m_scratchpad = encodingScratchpad;
    }

    BurrowsWheelerEncodingResult encode() {
        int[] nArray = new ThreeWayRadixQuicksort(this.m_data, this.m_length, MIN_QUICKSORT_LENGTH, this.m_scratchpad).sort();
        byte[] byArray = this.m_scratchpad.m_lastColumn;
        int n = -1;
        for (int i = 0; i < this.m_length; ++i) {
            int n2 = nArray[i] - 1;
            if (n2 < 0) {
                n2 += this.m_length;
                n = i;
            }
            byArray[i] = this.m_data[n2];
        }
        return new BurrowsWheelerEncodingResult(byArray, n);
    }

    static class BurrowsWheelerEncodingResult {
        final byte[] m_lastColumn;
        final int m_firstPointer;

        private BurrowsWheelerEncodingResult(byte[] byArray, int n) {
            this.m_lastColumn = byArray;
            this.m_firstPointer = n;
        }
    }
}

