/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.bzip2;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.at4j.comp.bzip2.EncodedBlockData;
import org.at4j.support.io.BitOutput;
import org.entityfs.support.log.LogAdapter;

final class EncodedBlockWriter {
    private final BitOutput m_out;
    private final Map<Integer, EncodedBlockData> m_savedBlocks = new HashMap<Integer, EncodedBlockData>();
    private final LogAdapter m_logAdapter;
    private final CountDownLatch m_doneLatch = new CountDownLatch(1);
    private int m_nextBlockToWrite = 0;
    private boolean m_hasError;

    EncodedBlockWriter(BitOutput bitOutput, LogAdapter logAdapter) {
        this.m_out = bitOutput;
        this.m_logAdapter = logAdapter;
    }

    private void writeEncodedBlockData(EncodedBlockData encodedBlockData) throws IOException {
        this.m_out.writeBytes(encodedBlockData.m_bytes, 0, encodedBlockData.m_bytes.length);
        if (encodedBlockData.m_noBits > 0) {
            this.m_out.writeBits(encodedBlockData.m_bitValue, encodedBlockData.m_noBits);
        }
    }

    private void writeBlockInternal(int n, EncodedBlockData encodedBlockData) throws IOException {
        if (encodedBlockData == null) {
            if (this.m_logAdapter != null) {
                this.m_logAdapter.logDebug((Object)"Reached the end of the encoded data");
            }
            this.m_doneLatch.countDown();
        } else {
            if (this.m_logAdapter != null) {
                this.m_logAdapter.logDebug((Object)("Writing block #" + n));
            }
            this.writeEncodedBlockData(encodedBlockData);
            while (this.m_savedBlocks.containsKey(++this.m_nextBlockToWrite)) {
                EncodedBlockData encodedBlockData2 = this.m_savedBlocks.get(this.m_nextBlockToWrite);
                if (encodedBlockData2 != null) {
                    if (this.m_logAdapter != null) {
                        this.m_logAdapter.logDebug((Object)("Writing (stored) block #" + this.m_nextBlockToWrite));
                    }
                    this.writeEncodedBlockData(encodedBlockData2);
                    continue;
                }
                if (this.m_logAdapter != null) {
                    this.m_logAdapter.logDebug((Object)"Reached the end of the encoded data (stored).");
                }
                this.m_doneLatch.countDown();
                break;
            }
        }
    }

    private void saveBlock(int n, EncodedBlockData encodedBlockData) {
        this.m_savedBlocks.put(n, encodedBlockData);
    }

    synchronized void writeBlock(int n, EncodedBlockData encodedBlockData) throws IOException {
        if (this.m_hasError) {
            return;
        }
        try {
            if (n == this.m_nextBlockToWrite) {
                this.writeBlockInternal(n, encodedBlockData);
            } else {
                this.saveBlock(n, encodedBlockData);
            }
        }
        catch (Error error) {
            this.m_hasError = true;
            this.m_doneLatch.countDown();
            throw error;
        }
        catch (RuntimeException runtimeException) {
            this.m_hasError = true;
            this.m_doneLatch.countDown();
            throw runtimeException;
        }
        catch (IOException iOException) {
            this.m_hasError = true;
            this.m_doneLatch.countDown();
            throw iOException;
        }
    }

    void waitFor() throws InterruptedException {
        this.m_doneLatch.await();
    }
}

