/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.bzip2;

import java.io.IOException;
import java.util.Arrays;
import org.at4j.comp.bzip2.EncodingScratchpad;
import org.at4j.support.io.BitInput;
import org.at4j.support.io.BitOutput;

final class HighValueBranchHuffmanTree {
    private static final int MAX_NO_OF_SYMBOLS = 258;
    private final int m_minLength;
    private final int m_maxLength;
    final int m_numberOfLengths;
    final int[] m_limitsPerLength;
    final int[] m_baseValuesPerLength;
    final int[] m_symbolOffsetPerLength;
    final int[] m_symbolSequenceNos;
    final int[][] m_huffmanCodesAndLengthsPerSymbol;

    private int[] getCodeAndLengthForSymbol(int n, int n2, int[] nArray) {
        int n3;
        for (n3 = 0; n3 < this.m_numberOfLengths - 1 && n2 >= this.m_symbolOffsetPerLength[n3 + 1]; ++n3) {
        }
        nArray[0] = this.m_baseValuesPerLength[n3] + (n2 - this.m_symbolOffsetPerLength[n3]);
        nArray[1] = this.m_minLength + n3;
        return nArray;
    }

    HighValueBranchHuffmanTree(int[] nArray, int n, int n2, boolean bl) throws IllegalArgumentException {
        int n3;
        int n4;
        if (n < 0 || n2 < n) {
            throw new IllegalArgumentException("Illegal min or max length, min: " + n + ", max: " + n2);
        }
        int n5 = nArray.length;
        int n6 = n2 - n + 1;
        this.m_symbolSequenceNos = new int[n5];
        int[] nArray2 = new int[n6];
        int n7 = 0;
        for (n4 = n; n4 <= n2; ++n4) {
            nArray2[n4 - n] = 0;
            for (n3 = 0; n3 < n5; ++n3) {
                if (nArray[n3] != n4) continue;
                this.m_symbolSequenceNos[n7++] = n3;
                int n8 = n4 - n;
                nArray2[n8] = nArray2[n8] + 1;
            }
        }
        this.m_symbolOffsetPerLength = new int[n6];
        this.m_symbolOffsetPerLength[0] = 0;
        for (n4 = 0; n4 < n6 - 1; ++n4) {
            this.m_symbolOffsetPerLength[n4 + 1] = this.m_symbolOffsetPerLength[n4] + nArray2[n4];
        }
        this.m_limitsPerLength = new int[n6 - 1];
        this.m_baseValuesPerLength = new int[n6];
        n4 = 0;
        for (n3 = n; n3 <= n2; ++n3) {
            n7 = n3 - n;
            this.m_baseValuesPerLength[n7] = n4 << 1;
            if (n3 >= n2) continue;
            n4 = this.m_baseValuesPerLength[n7] + nArray2[n7];
            this.m_limitsPerLength[n7] = n4 - 1;
        }
        this.m_minLength = n;
        this.m_maxLength = n2;
        this.m_numberOfLengths = (byte)(n2 - n + 1);
        if (bl) {
            int[] nArray3 = new int[nArray.length];
            Arrays.fill(nArray3, -1);
            for (int i = 0; i < this.m_symbolSequenceNos.length; ++i) {
                nArray3[this.m_symbolSequenceNos[i]] = i;
            }
            this.m_huffmanCodesAndLengthsPerSymbol = new int[nArray.length][2];
            int[] nArray4 = new int[2];
            for (int i = 0; i < nArray.length; ++i) {
                nArray4 = this.getCodeAndLengthForSymbol(i, nArray3[i], nArray4);
                this.m_huffmanCodesAndLengthsPerSymbol[i][0] = nArray4[0];
                this.m_huffmanCodesAndLengthsPerSymbol[i][1] = nArray4[1];
            }
        } else {
            this.m_huffmanCodesAndLengthsPerSymbol = null;
        }
    }

    private static void upHeap(int[] nArray, int[] nArray2, int n) {
        int n2 = nArray[n];
        while (nArray2[n2] < nArray2[nArray[n >> 1]]) {
            nArray[n] = nArray[n >>> 1];
            n >>>= 1;
        }
        nArray[n] = n2;
    }

    private static void downHeap(int[] nArray, int[] nArray2, int n, int n2) {
        int n3;
        int n4 = nArray[n2];
        while ((n3 = n2 << 1) <= n) {
            if (n3 < n && nArray2[nArray[n3 + 1]] < nArray2[nArray[n3]]) {
                ++n3;
            }
            if (nArray2[n4] < nArray2[nArray[n3]]) break;
            nArray[n2] = nArray[n3];
            n2 = n3;
        }
        nArray[n2] = n4;
    }

    private static int addWeights(int n, int n2) {
        int n3 = n & 0xFF;
        int n4 = n2 & 0xFF;
        int n5 = n & 0xFFFFFF00;
        int n6 = n2 & 0xFFFFFF00;
        return n5 + n6 | 1 + (n3 > n4 ? n3 : n4);
    }

    int getMinLength() {
        return this.m_minLength;
    }

    int getMaxLength() {
        return this.m_maxLength;
    }

    int[][] getSortedSymbolSequenceNosAndCodeLengths() {
        int[][] nArray = new int[this.m_symbolSequenceNos.length][2];
        int n = this.m_minLength;
        for (int i = 0; i < this.m_symbolSequenceNos.length; ++i) {
            while (n < this.m_maxLength && i >= this.m_symbolOffsetPerLength[n - this.m_minLength + 1]) {
                ++n;
            }
            nArray[i][0] = this.m_symbolSequenceNos[i];
            nArray[i][1] = n;
        }
        return nArray;
    }

    int readNext(BitInput bitInput) throws IOException {
        int n = bitInput.readBits(this.m_minLength);
        if (this.m_limitsPerLength.length == 0 || n <= this.m_limitsPerLength[0]) {
            return this.m_symbolSequenceNos[n];
        }
        int n2 = this.m_minLength;
        int n3 = 1;
        while (true) {
            n = n << 1 | (bitInput.readBit() ? 1 : 0);
            if (++n2 == this.m_maxLength || n <= this.m_limitsPerLength[n3]) {
                return this.m_symbolSequenceNos[this.m_symbolOffsetPerLength[n3] + (n - this.m_baseValuesPerLength[n3])];
            }
            ++n3;
        }
    }

    void write(BitOutput bitOutput, int n) throws IOException {
        bitOutput.writeBitsLittleEndian(this.m_huffmanCodesAndLengthsPerSymbol[n][0], this.m_huffmanCodesAndLengthsPerSymbol[n][1]);
    }

    int getBitLength(int n) {
        return this.m_huffmanCodesAndLengthsPerSymbol[n][1];
    }

    static int[] createCodeLengths(int[] nArray, int n, int n2, EncodingScratchpad encodingScratchpad) {
        int n3;
        int[] nArray2 = encodingScratchpad.m_htHeap;
        int[] nArray3 = encodingScratchpad.m_htWeight;
        int[] nArray4 = encodingScratchpad.m_htParent;
        int[] nArray5 = new int[n];
        int n4 = -1;
        int n5 = Integer.MAX_VALUE;
        for (n3 = 0; n3 < n; ++n3) {
            nArray3[n3 + 1] = (nArray[n3] == 0 ? 1 : nArray[n3]) << 8;
        }
        block1: while (true) {
            int n6;
            int n7;
            n3 = n;
            int n8 = 0;
            nArray2[0] = 0;
            nArray3[0] = 0;
            nArray4[0] = -2;
            int n9 = 1;
            while (n9 <= n) {
                nArray4[n9] = -1;
                nArray2[++n8] = n9++;
                HighValueBranchHuffmanTree.upHeap(nArray2, nArray3, n8);
            }
            assert (n8 < 260);
            while (n8 > 1) {
                n9 = nArray2[1];
                nArray2[1] = nArray2[n8];
                HighValueBranchHuffmanTree.downHeap(nArray2, nArray3, --n8, 1);
                n7 = nArray2[1];
                nArray2[1] = nArray2[n8];
                HighValueBranchHuffmanTree.downHeap(nArray2, nArray3, --n8, 1);
                nArray4[n9] = nArray4[n7] = ++n3;
                nArray3[n3] = HighValueBranchHuffmanTree.addWeights(nArray3[n9], nArray3[n7]);
                nArray4[n3] = -1;
                nArray2[++n8] = n3;
                HighValueBranchHuffmanTree.upHeap(nArray2, nArray3, n8);
            }
            assert (n3 < 516);
            n9 = 0;
            for (n7 = 1; n7 <= n; ++n7) {
                n6 = 0;
                int n10 = n7;
                while (nArray4[n10] >= 0) {
                    n10 = nArray4[n10];
                    ++n6;
                }
                nArray5[n7 - 1] = n6;
                if (n6 > n2) {
                    n9 = 1;
                    break;
                }
                if (n6 > n4) {
                    n4 = n6;
                }
                if (n6 >= n5) continue;
                n5 = n6;
            }
            if (n9 == 0) break;
            n7 = 1;
            while (true) {
                if (n7 > n) continue block1;
                n6 = nArray3[n7] >> 8;
                n6 = 1 + n6 / 2;
                nArray3[n7] = n6 << 8;
                ++n7;
            }
            break;
        }
        return nArray5;
    }
}

