/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.bzip2;

import java.io.IOException;
import java.io.InputStream;
import org.at4j.comp.bzip2.CRC;

final class RLEDecodingInputStream
extends InputStream {
    private final CRC m_blockChecksum = new CRC();
    private final InputStream m_wrapped;
    private final long m_readChecksum;
    private RLEState m_state;
    private int m_noLeftToRepeat;
    private int m_last;
    private int m_numberOfSimilar;

    RLEDecodingInputStream(InputStream inputStream, long l) {
        this.m_wrapped = inputStream;
        this.m_readChecksum = l;
        this.m_state = RLEState.READING;
        this.m_numberOfSimilar = 0;
        this.m_last = -1;
    }

    private void handleEof() throws IOException {
        if ((long)this.m_blockChecksum.getValue() != this.m_readChecksum) {
            throw new IOException("Invalid block checksum. Was " + this.m_blockChecksum.getValue() + ", expected " + this.m_readChecksum);
        }
    }

    public int read() throws IOException {
        switch (this.m_state) {
            case EOF: {
                return -1;
            }
            case READING: {
                int n = this.m_wrapped.read();
                if (n == -1) {
                    this.m_state = RLEState.EOF;
                    this.handleEof();
                    return -1;
                }
                if (n == this.m_last) {
                    ++this.m_numberOfSimilar;
                    if (this.m_numberOfSimilar == 4) {
                        this.m_state = RLEState.ABOUT_TO_READ_HOW_MANY_TO_REPEAT;
                        this.m_numberOfSimilar = 0;
                    }
                } else {
                    this.m_numberOfSimilar = 1;
                    this.m_last = n;
                }
                this.m_blockChecksum.update(n);
                return n;
            }
            case ABOUT_TO_READ_HOW_MANY_TO_REPEAT: {
                this.m_noLeftToRepeat = this.m_wrapped.read();
                if (this.m_noLeftToRepeat == -1) {
                    this.m_state = RLEState.EOF;
                    this.handleEof();
                    return -1;
                }
                if (this.m_noLeftToRepeat == 0) {
                    this.m_state = RLEState.READING;
                    return this.read();
                }
                this.m_state = RLEState.REPEATING;
                --this.m_noLeftToRepeat;
                if (this.m_noLeftToRepeat == 0) {
                    this.m_state = RLEState.READING;
                }
                this.m_blockChecksum.update(this.m_last);
                return this.m_last;
            }
            case REPEATING: {
                --this.m_noLeftToRepeat;
                if (this.m_noLeftToRepeat == 0) {
                    this.m_state = RLEState.READING;
                }
                this.m_blockChecksum.update(this.m_last);
                return this.m_last;
            }
        }
        throw new RuntimeException("Unknown state " + (Object)((Object)this.m_state) + ". This is a bug");
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            int n3 = this.read();
            if (n3 < 0) {
                return i > 0 ? i : -1;
            }
            byArray[n + i] = (byte)(n3 & 0xFF);
        }
        return n2;
    }

    public void close() throws IOException {
        this.m_wrapped.close();
        super.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RLEState {
        READING,
        REPEATING,
        ABOUT_TO_READ_HOW_MANY_TO_REPEAT,
        EOF;

    }
}

