/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.bzip2;

import java.util.Arrays;
import org.at4j.comp.bzip2.EncodingScratchpad;

final class ThreeWayRadixQuicksort {
    static final int DATA_OVERSHOOT = 20;
    private static final int QUICKSORT_DEPTH_THRESHOLD = 18;
    static final int SORT_STACK_SIZE = 100;
    private static final int[] SHELL_SORT_INCREMENTS = new int[]{1, 4, 13, 40, 121, 364, 1093, 3280, 9841, 29524, 88573, 265720, 797161, 2391484};
    private final byte[] m_data;
    private final int m_length;
    private final int m_minLengthForQuicksort;
    private final EncodingScratchpad m_scratchpad;
    private final int[] m_sortCache;
    private final QuickSortRangeInfo[] m_sortStack;
    private int m_sortStackPointer = -1;
    final int[] m_ptr;

    ThreeWayRadixQuicksort(byte[] byArray, int n, int n2, EncodingScratchpad encodingScratchpad) throws IllegalArgumentException {
        assert (byArray.length >= n + 20);
        if (n > byArray.length) {
            throw new IllegalArgumentException("Invalid data length " + n + ". It must be <= the length of the data array (" + byArray.length + ")");
        }
        if (n2 < 3) {
            throw new IllegalArgumentException("Invalid minimum length for Quicksort " + n2 + ". It must be >= 3");
        }
        this.m_data = byArray;
        this.m_length = n;
        this.m_minLengthForQuicksort = n2;
        this.m_scratchpad = encodingScratchpad;
        this.m_sortStack = this.m_scratchpad.m_sortStack;
        this.m_sortCache = this.m_scratchpad.m_sortCache;
        Arrays.fill(this.m_sortCache, 0);
        this.m_ptr = this.m_scratchpad.m_ptrs;
    }

    private int getDataAt(int n) {
        return this.m_data[n] & 0xFF;
    }

    int[] radixSort() {
        int n;
        int[] nArray = this.m_scratchpad.m_twoByteFrequencies;
        Arrays.fill(nArray, 0);
        int n2 = this.getDataAt(0) << 8;
        for (n = this.m_length - 1; n >= 0; --n) {
            int n3 = n2 = n2 >>> 8 | this.getDataAt(n) << 8;
            nArray[n3] = nArray[n3] + 1;
        }
        for (n = 1; n < 65536; ++n) {
            int n4 = n;
            nArray[n4] = nArray[n4] + nArray[n - 1];
        }
        n2 = this.getDataAt(0) << 8;
        n = this.m_length - 1;
        while (n >= 0) {
            int n5 = n2 = n2 >>> 8 | this.getDataAt(n) << 8;
            int n6 = nArray[n5] - 1;
            nArray[n5] = n6;
            int n7 = n6;
            this.m_ptr[n7] = n--;
        }
        return nArray;
    }

    private int med3(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = this.getDataAt(this.m_ptr[n] + n4);
        if (n6 == (n5 = this.getDataAt(this.m_ptr[n2] + n4))) {
            return n;
        }
        int n7 = this.getDataAt(this.m_ptr[n3] + n4);
        if (n7 == n6 || n7 == n5) {
            return n3;
        }
        return n6 < n5 ? (n5 < n7 ? n2 : (n6 < n7 ? n3 : n)) : (n5 > n7 ? n2 : (n6 < n7 ? n : n3));
    }

    private int selectPivot(QuickSortRangeInfo quickSortRangeInfo) {
        int n = quickSortRangeInfo.m_bucketStartPos;
        int n2 = n + quickSortRangeInfo.m_bucketLen - 1;
        int n3 = (n + n2) / 2;
        if (quickSortRangeInfo.m_bucketLen > 500) {
            int n4 = quickSortRangeInfo.m_bucketLen / 8;
            n = this.med3(n, n + n4, n + 2 * n4, quickSortRangeInfo.m_depth);
            n3 = this.med3(n3 - n4, n3, n3 + n4, quickSortRangeInfo.m_depth);
            n2 = this.med3(n2 - 2 * n4, n2 - n4, n2, quickSortRangeInfo.m_depth);
        }
        return this.med3(n, n3, n2, quickSortRangeInfo.m_depth);
    }

    private void swap(int n, int n2) {
        int n3 = this.m_ptr[n];
        this.m_ptr[n] = this.m_ptr[n2];
        this.m_ptr[n2] = n3;
    }

    void shellSortRange(QuickSortRangeInfo quickSortRangeInfo) {
        int n = quickSortRangeInfo.m_bucketLen;
        int n2 = quickSortRangeInfo.m_depth;
        int n3 = quickSortRangeInfo.m_bucketStartPos;
        int n4 = n3 + n;
        int n5 = 1;
        while (SHELL_SORT_INCREMENTS[n5] < n) {
            ++n5;
        }
        for (int i = n5 - 1; i >= 0; --i) {
            int n6;
            int n7 = SHELL_SORT_INCREMENTS[i];
            block2: for (int j = n6 = n3 + n7; j < n4; ++j) {
                for (int k = j; k >= n6; k -= n7) {
                    int n8;
                    int n9;
                    block7: {
                        block8: {
                            block9: {
                                block10: {
                                    block11: {
                                        block12: {
                                            block13: {
                                                block14: {
                                                    block15: {
                                                        block16: {
                                                            block17: {
                                                                block18: {
                                                                    block19: {
                                                                        block20: {
                                                                            block21: {
                                                                                block22: {
                                                                                    int n10 = n2;
                                                                                    n9 = this.m_ptr[k - n7] + n2 - 1;
                                                                                    n8 = this.m_ptr[k] + n2 - 1;
                                                                                    while (true) {
                                                                                        if (n9 >= this.m_length) {
                                                                                            n9 -= this.m_length;
                                                                                            continue;
                                                                                        }
                                                                                        while (n8 >= this.m_length) {
                                                                                            n8 -= this.m_length;
                                                                                        }
                                                                                        if (this.getDataAt(++n9) != this.getDataAt(++n8)) break block7;
                                                                                        if (this.m_sortCache[n9] != this.m_sortCache[n8]) break block8;
                                                                                        if (this.getDataAt(++n9) != this.getDataAt(++n8)) break block9;
                                                                                        if (this.m_sortCache[n9] != this.m_sortCache[n8]) break block10;
                                                                                        if (this.getDataAt(++n9) != this.getDataAt(++n8)) break block11;
                                                                                        if (this.m_sortCache[n9] != this.m_sortCache[n8]) break block12;
                                                                                        if (this.getDataAt(++n9) != this.getDataAt(++n8)) break block13;
                                                                                        if (this.m_sortCache[n9] != this.m_sortCache[n8]) break block14;
                                                                                        if (this.getDataAt(++n9) != this.getDataAt(++n8)) break block15;
                                                                                        if (this.m_sortCache[n9] != this.m_sortCache[n8]) break block16;
                                                                                        if (this.getDataAt(++n9) != this.getDataAt(++n8)) break block17;
                                                                                        if (this.m_sortCache[n9] != this.m_sortCache[n8]) break block18;
                                                                                        if (this.getDataAt(++n9) != this.getDataAt(++n8)) break block19;
                                                                                        if (this.m_sortCache[n9] != this.m_sortCache[n8]) break block20;
                                                                                        if (this.getDataAt(++n9) != this.getDataAt(++n8)) break block21;
                                                                                        if (this.m_sortCache[n9] != this.m_sortCache[n8]) break block22;
                                                                                        if ((n10 += 8) >= this.m_length) break;
                                                                                    }
                                                                                    continue block2;
                                                                                }
                                                                                if (this.m_sortCache[n9] < this.m_sortCache[n8]) continue block2;
                                                                                this.swap(k - n7, k);
                                                                                continue;
                                                                            }
                                                                            if (this.getDataAt(n9) < this.getDataAt(n8)) continue block2;
                                                                            this.swap(k - n7, k);
                                                                            continue;
                                                                        }
                                                                        if (this.m_sortCache[n9] < this.m_sortCache[n8]) continue block2;
                                                                        this.swap(k - n7, k);
                                                                        continue;
                                                                    }
                                                                    if (this.getDataAt(n9) < this.getDataAt(n8)) continue block2;
                                                                    this.swap(k - n7, k);
                                                                    continue;
                                                                }
                                                                if (this.m_sortCache[n9] < this.m_sortCache[n8]) continue block2;
                                                                this.swap(k - n7, k);
                                                                continue;
                                                            }
                                                            if (this.getDataAt(n9) < this.getDataAt(n8)) continue block2;
                                                            this.swap(k - n7, k);
                                                            continue;
                                                        }
                                                        if (this.m_sortCache[n9] < this.m_sortCache[n8]) continue block2;
                                                        this.swap(k - n7, k);
                                                        continue;
                                                    }
                                                    if (this.getDataAt(n9) < this.getDataAt(n8)) continue block2;
                                                    this.swap(k - n7, k);
                                                    continue;
                                                }
                                                if (this.m_sortCache[n9] < this.m_sortCache[n8]) continue block2;
                                                this.swap(k - n7, k);
                                                continue;
                                            }
                                            if (this.getDataAt(n9) < this.getDataAt(n8)) continue block2;
                                            this.swap(k - n7, k);
                                            continue;
                                        }
                                        if (this.m_sortCache[n9] < this.m_sortCache[n8]) continue block2;
                                        this.swap(k - n7, k);
                                        continue;
                                    }
                                    if (this.getDataAt(n9) < this.getDataAt(n8)) continue block2;
                                    this.swap(k - n7, k);
                                    continue;
                                }
                                if (this.m_sortCache[n9] < this.m_sortCache[n8]) continue block2;
                                this.swap(k - n7, k);
                                continue;
                            }
                            if (this.getDataAt(n9) < this.getDataAt(n8)) continue block2;
                            this.swap(k - n7, k);
                            continue;
                        }
                        if (this.m_sortCache[n9] < this.m_sortCache[n8]) continue block2;
                        this.swap(k - n7, k);
                        continue;
                    }
                    if (this.getDataAt(n9) < this.getDataAt(n8)) continue block2;
                    this.swap(k - n7, k);
                }
            }
        }
    }

    private int getPositionOfFirstDifferingValue(int n, int n2, int n3) {
        assert (n3 <= 20);
        int n4 = this.getDataAt(this.m_ptr[n] + n3);
        int n5 = n + n2;
        for (int i = n + 1; i < n5; ++i) {
            if (this.getDataAt(this.m_ptr[i] + n3) == n4) continue;
            return i;
        }
        return -1;
    }

    private void swapRanges(int n, int n2, int n3) {
        assert (n + n3 <= n2);
        if (this.m_scratchpad.m_tempArea.length < n3) {
            this.m_scratchpad.m_tempArea = new int[n3 + 100];
        }
        System.arraycopy(this.m_ptr, n, this.m_scratchpad.m_tempArea, 0, n3);
        System.arraycopy(this.m_ptr, n2, this.m_ptr, n, n3);
        System.arraycopy(this.m_scratchpad.m_tempArea, 0, this.m_ptr, n2, n3);
    }

    private void addRangeToStack(int n, int n2, int n3) {
        if (n2 < 2) {
            return;
        }
        this.m_sortStack[++this.m_sortStackPointer] = new QuickSortRangeInfo(n, n2, n3);
    }

    void quickSortRange(QuickSortRangeInfo quickSortRangeInfo) {
        int n;
        int n2;
        int n3 = this.selectPivot(quickSortRangeInfo);
        this.swap(quickSortRangeInfo.m_bucketStartPos, n3);
        int n4 = quickSortRangeInfo.m_depth;
        assert (n4 < 20);
        int n5 = this.getPositionOfFirstDifferingValue(quickSortRangeInfo.m_bucketStartPos, quickSortRangeInfo.m_bucketLen, n4);
        while (n5 == -1) {
            if (n4 == this.m_length) {
                return;
            }
            if (++n4 < 18) {
                n5 = this.getPositionOfFirstDifferingValue(quickSortRangeInfo.m_bucketStartPos, quickSortRangeInfo.m_bucketLen, n4);
                continue;
            }
            this.shellSortRange(quickSortRangeInfo);
            return;
        }
        int n6 = n5;
        int n7 = n5;
        int n8 = n2 = quickSortRangeInfo.m_bucketStartPos + quickSortRangeInfo.m_bucketLen - 1;
        int n9 = this.getDataAt(this.m_ptr[quickSortRangeInfo.m_bucketStartPos] + n4);
        while (true) {
            if (n6 <= n2 && (n = this.getDataAt(this.m_ptr[n6] + n4)) <= n9) {
                if (n == n9) {
                    this.swap(n6, n7++);
                }
                ++n6;
                continue;
            }
            while (n6 <= n2 && (n = this.getDataAt(this.m_ptr[n2] + n4)) >= n9) {
                if (n == n9) {
                    this.swap(n2, n8--);
                }
                --n2;
            }
            if (n6 > n2) break;
            this.swap(n6++, n2--);
        }
        n = n6 - n7;
        int n10 = Math.min(n7 - quickSortRangeInfo.m_bucketStartPos, n);
        if (n10 > 0) {
            this.swapRanges(quickSortRangeInfo.m_bucketStartPos, n6 - n10, n10);
        }
        int n11 = n8 - n2;
        n10 = Math.min(quickSortRangeInfo.m_bucketStartPos + quickSortRangeInfo.m_bucketLen - n8 - 1, n11);
        if (n10 > 0) {
            this.swapRanges(n6, quickSortRangeInfo.m_bucketStartPos + quickSortRangeInfo.m_bucketLen - n10, n10);
        }
        int n12 = quickSortRangeInfo.m_bucketLen - n - n11;
        this.addRangeToStack(quickSortRangeInfo.m_bucketStartPos, n, n4);
        this.addRangeToStack(quickSortRangeInfo.m_bucketStartPos + n, n12, n4 + 1);
        this.addRangeToStack(quickSortRangeInfo.m_bucketStartPos + n + n12, n11, n4);
    }

    void sortBucket(int n, int n2, int n3) {
        if (n2 < 2) {
            return;
        }
        assert (this.m_sortStackPointer == -1);
        this.m_sortStack[++this.m_sortStackPointer] = new QuickSortRangeInfo(n, n2, n3);
        while (this.m_sortStackPointer >= 0) {
            QuickSortRangeInfo quickSortRangeInfo;
            if ((quickSortRangeInfo = this.m_sortStack[this.m_sortStackPointer--]).m_bucketLen < this.m_minLengthForQuicksort || quickSortRangeInfo.m_depth > 18) {
                this.shellSortRange(quickSortRangeInfo);
                continue;
            }
            this.quickSortRange(quickSortRangeInfo);
        }
    }

    private int[] establishSortOrder(int[] nArray) {
        int n;
        int[] nArray2 = this.m_scratchpad.m_sortOrder;
        for (n = 0; n < 256; ++n) {
            nArray2[n] = n;
        }
        for (n = 4; n >= 0; --n) {
            int n2;
            for (int i = n2 = SHELL_SORT_INCREMENTS[n]; i < nArray2.length; ++i) {
                int n3;
                int n4;
                for (int j = i; j >= n2 && nArray[(n4 = nArray2[j - n2]) * 256 + 255] - nArray[n4 * 256] > nArray[(n3 = nArray2[j]) * 256 + 255] - nArray[n3 * 256]; j -= n2) {
                    nArray2[j] = n4;
                    nArray2[j - n2] = n3;
                }
            }
        }
        return nArray2;
    }

    int[] sort() {
        if (this.m_length == 0) {
            return new int[0];
        }
        int[] nArray = this.radixSort();
        nArray[65536] = this.m_length;
        boolean[] blArray = this.m_scratchpad.m_sortedLargeBuckets;
        Arrays.fill(blArray, false);
        boolean[] blArray2 = this.m_scratchpad.m_sortedSmallBuckets;
        Arrays.fill(blArray2, false);
        int[] nArray2 = this.m_scratchpad.m_copyStart;
        int[] nArray3 = this.m_scratchpad.m_copyEnd;
        int[] nArray4 = this.establishSortOrder(nArray);
        for (int i = 0; i < 256; ++i) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5 = nArray4[i];
            for (n4 = 0; n4 < 256; ++n4) {
                if (n4 == n5 || blArray2[n3 = n5 * 256 + n4]) continue;
                n2 = nArray[n3];
                n = nArray[n3 + 1] - n2;
                if (n > 1) {
                    this.sortBucket(n2, n, 2);
                }
                blArray2[n3] = true;
            }
            for (n4 = 0; n4 < 256; ++n4) {
                nArray2[n4] = nArray[n4 * 256 + n5];
                nArray3[n4] = nArray[n4 * 256 + n5 + 1] - 1;
            }
            for (n4 = nArray[n5 * 256]; n4 < nArray2[n5]; ++n4) {
                n3 = this.m_ptr[n4] - 1;
                if (n3 < 0) {
                    n3 += this.m_length;
                }
                if (blArray[n2 = this.getDataAt(n3)]) continue;
                int n6 = n2;
                nArray2[n6] = nArray2[n6] + 1;
                if (n >= this.m_length) {
                    n -= this.m_length;
                }
                this.m_ptr[n] = n3;
            }
            for (n4 = nArray[(n5 + 1) * 256] - 1; n4 > nArray3[n5]; --n4) {
                n3 = this.m_ptr[n4] - 1;
                if (n3 < 0) {
                    n3 += this.m_length;
                }
                if (blArray[n2 = this.getDataAt(n3)]) continue;
                int n7 = n2;
                nArray3[n7] = nArray3[n7] - 1;
                if (n < 0) {
                    n += this.m_length;
                }
                this.m_ptr[n] = n3;
            }
            for (n4 = 0; n4 < 256; ++n4) {
                blArray2[n4 * 256 + n5] = true;
            }
            blArray[n5] = true;
            if (i == 255) continue;
            n4 = nArray[n5 * 256];
            n3 = n5 < 255 ? nArray[(n5 + 1) * 256] : this.m_length;
            n2 = n3 - n4;
            assert (n2 >= 0);
            n = 0;
            while (n2 >>> n > 65534) {
                ++n;
            }
            for (int j = n2 - 1; j >= 0; --j) {
                int n8;
                int n9 = this.m_ptr[n4 + j];
                this.m_sortCache[n9] = n8 = j >>> n;
                if (n9 >= 20) continue;
                this.m_sortCache[this.m_length + n9] = n8;
            }
        }
        return this.m_ptr;
    }

    static class QuickSortRangeInfo {
        private final int m_bucketStartPos;
        private final int m_bucketLen;
        private final int m_depth;

        QuickSortRangeInfo(int n, int n2, int n3) {
            this.m_bucketStartPos = n;
            this.m_bucketLen = n2;
            this.m_depth = n3;
        }
    }
}

