/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.bzip2.prog;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.at4j.comp.bzip2.BZip2InputStream;
import org.at4j.comp.bzip2.BZip2OutputStream;
import org.at4j.comp.bzip2.BZip2OutputStreamSettings;
import org.at4j.comp.bzip2.prog.AbstractBZip2ProgramArguments;
import org.at4j.comp.prog.AbstractStreamCompressionProgram;
import org.at4j.comp.prog.IgnoreFileException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractBZip2Program<T extends AbstractBZip2ProgramArguments>
extends AbstractStreamCompressionProgram<T> {
    AbstractBZip2Program() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected InputStream createInputStream(int n, T t) throws IOException {
        InputStream inputStream = null;
        boolean bl = false;
        try {
            inputStream = new FileInputStream(((AbstractBZip2ProgramArguments)t).getSources().get(n));
            inputStream = new BufferedInputStream(inputStream);
            if (((AbstractBZip2ProgramArguments)t).isDecompress()) {
                inputStream = ((AbstractBZip2ProgramArguments)t).isApache() ? new BZip2CompressorInputStream(inputStream) : new BZip2InputStream(inputStream);
            }
            bl = true;
            InputStream inputStream2 = inputStream;
            return inputStream2;
        }
        finally {
            if (!bl && inputStream != null) {
                inputStream.close();
            }
        }
    }

    abstract String getTargetFileName(String var1, T var2) throws IgnoreFileException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OutputStream createOutputStream(int n, T t) throws IOException, IgnoreFileException {
        OutputStream outputStream = null;
        boolean bl = false;
        try {
            Object object;
            if (((AbstractBZip2ProgramArguments)t).isCompressToStdout()) {
                outputStream = System.out;
            } else {
                object = ((AbstractBZip2ProgramArguments)t).getSources().get(n);
                File file = new File(((File)object).getParentFile(), this.getTargetFileName(((File)object).getName(), t));
                if (file.exists()) {
                    throw new IgnoreFileException(file + " already exists");
                }
                outputStream = new FileOutputStream(file);
                outputStream = new BufferedOutputStream(outputStream);
            }
            if (!((AbstractBZip2ProgramArguments)t).isDecompress()) {
                if (((AbstractBZip2ProgramArguments)t).isApache()) {
                    outputStream = new BZip2CompressorOutputStream(outputStream, ((AbstractBZip2ProgramArguments)t).getBlockSize());
                } else {
                    object = new BZip2OutputStreamSettings();
                    ((BZip2OutputStreamSettings)object).setBlockSize(((AbstractBZip2ProgramArguments)t).getBlockSize());
                    ((BZip2OutputStreamSettings)object).setNumberOfEncoderThreads(((AbstractBZip2ProgramArguments)t).getNumberOfEncoderThreads());
                    outputStream = new BZip2OutputStream(outputStream, (BZip2OutputStreamSettings)object);
                }
            }
            bl = true;
            object = outputStream;
            return object;
        }
        finally {
            if (!bl && outputStream != null) {
                ((OutputStream)outputStream).close();
            }
        }
    }

    @Override
    protected void postProcess(int n, T t) throws IOException {
        File file;
        if (!((AbstractBZip2ProgramArguments)t).isDontDeleteOriginalFiles() && !(file = ((AbstractBZip2ProgramArguments)t).getSources().get(n)).delete()) {
            throw new IOException("Could not delete " + file + ". No reason given");
        }
    }
}

