/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.bzip2.prog;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.at4j.comp.prog.StreamCompressionProgramArguments;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractBZip2ProgramArguments
extends StreamCompressionProgramArguments {
    private final List<File> m_sources = new ArrayList<File>();
    private boolean m_compressToStdout;
    private boolean m_dontDeleteOriginalFiles;
    private boolean m_decompress = false;
    private boolean m_apache = false;
    private int m_blockSize = 9;
    private int m_numberOfEncoderThreads = 0;

    AbstractBZip2ProgramArguments() {
    }

    void setDecompress() {
        this.m_decompress = true;
    }

    boolean isDecompress() {
        return this.m_decompress;
    }

    void addSource(File file) {
        this.m_sources.add(file);
    }

    List<File> getSources() {
        return this.m_sources;
    }

    @Override
    public int getNumberOfSources() {
        return this.m_sources.size();
    }

    void setCompressToStdout() {
        this.m_compressToStdout = true;
    }

    boolean isCompressToStdout() {
        return this.m_compressToStdout;
    }

    void setDontDeleteOriginalFiles() {
        this.m_dontDeleteOriginalFiles = true;
    }

    boolean isDontDeleteOriginalFiles() {
        return this.m_dontDeleteOriginalFiles;
    }

    void setApache(boolean bl) {
        this.m_apache = bl;
    }

    boolean isApache() {
        return this.m_apache;
    }

    void setBlockSize(int n) {
        this.m_blockSize = n;
    }

    int getBlockSize() {
        return this.m_blockSize;
    }

    void setNumberOfEncoderThreads(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid number of encoder threads: " + n);
        }
        this.m_numberOfEncoderThreads = n;
    }

    int getNumberOfEncoderThreads() {
        return this.m_numberOfEncoderThreads;
    }
}

