/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.bzip2.prog;

import java.io.File;
import java.io.IOException;
import org.at4j.comp.bzip2.prog.AbstractBZip2Program;
import org.at4j.comp.bzip2.prog.BUnzip2CommandLineArguments;
import org.at4j.comp.prog.IgnoreFileException;
import org.at4j.support.prog.CommandErrorException;
import org.entityfs.support.exception.WrappedIOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BUnzip2
extends AbstractBZip2Program<BUnzip2CommandLineArguments> {
    @Override
    protected BUnzip2CommandLineArguments parseCommandLine(String[] stringArray) throws CommandErrorException {
        BUnzip2CommandLineArguments bUnzip2CommandLineArguments = new BUnzip2CommandLineArguments();
        int n = 0;
        String string = this.getArg(stringArray, n++, "Missing files");
        while (this.isFlagArgument(string)) {
            if ("--threads".equals(string)) {
                int n2 = Integer.valueOf(this.getArg(stringArray, n++, "Missing number of threads"));
                bUnzip2CommandLineArguments.setNumberOfThreads(n2);
            } else if ("--timing".equals(string)) {
                bUnzip2CommandLineArguments.setTiming();
            } else if ("-c".equals(string)) {
                bUnzip2CommandLineArguments.setCompressToStdout();
                bUnzip2CommandLineArguments.setDontDeleteOriginalFiles();
            } else if ("-k".equals(string) || "--keep".equals(string)) {
                bUnzip2CommandLineArguments.setDontDeleteOriginalFiles();
            } else if ("--apache".equals(string)) {
                bUnzip2CommandLineArguments.setApache(true);
            } else {
                throw new CommandErrorException("Unknown argument " + string);
            }
            string = this.getArg(stringArray, n++, "Missing files");
        }
        bUnzip2CommandLineArguments.addSource(new File(string));
        while (n < stringArray.length) {
            string = stringArray[n++];
            bUnzip2CommandLineArguments.addSource(new File(string));
        }
        return bUnzip2CommandLineArguments;
    }

    @Override
    String getTargetFileName(String string, BUnzip2CommandLineArguments bUnzip2CommandLineArguments) throws IgnoreFileException {
        if (string.toLowerCase().endsWith(".bz2")) {
            return string.substring(0, string.length() - 4);
        }
        throw new IgnoreFileException(string + ": unknown suffix -- ignored");
    }

    public static void main(String[] stringArray) {
        try {
            new BUnzip2().run(stringArray);
        }
        catch (CommandErrorException commandErrorException) {
            System.err.println(commandErrorException.getMessage());
            System.exit(1);
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            System.exit(1);
        }
        catch (WrappedIOException wrappedIOException) {
            System.err.println(wrappedIOException.getMessage());
            System.exit(1);
        }
    }
}

