/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.bzip2.prog;

import java.io.File;
import java.io.IOException;
import org.at4j.comp.bzip2.prog.AbstractBZip2Program;
import org.at4j.comp.bzip2.prog.BZip2CommandLineArguments;
import org.at4j.comp.prog.IgnoreFileException;
import org.at4j.support.prog.CommandErrorException;
import org.entityfs.support.exception.WrappedIOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BZip2
extends AbstractBZip2Program<BZip2CommandLineArguments> {
    @Override
    protected BZip2CommandLineArguments parseCommandLine(String[] stringArray) throws CommandErrorException {
        BZip2CommandLineArguments bZip2CommandLineArguments = new BZip2CommandLineArguments();
        int n = 0;
        String string = this.getArg(stringArray, n++, "Missing files");
        while (this.isFlagArgument(string)) {
            if ("--threads".equals(string)) {
                int n2 = Integer.valueOf(this.getArg(stringArray, n++, "Missing number of threads"));
                bZip2CommandLineArguments.setNumberOfThreads(n2);
            } else if ("--timing".equals(string)) {
                bZip2CommandLineArguments.setTiming();
            } else if ("-c".equals(string)) {
                bZip2CommandLineArguments.setCompressToStdout();
                bZip2CommandLineArguments.setDontDeleteOriginalFiles();
            } else if ("-d".equals(string) || "--decompress".equals(string) || "--uncompress".equals(string)) {
                bZip2CommandLineArguments.setDecompress();
            } else if ("-k".equals(string) || "--keep".equals(string)) {
                bZip2CommandLineArguments.setDontDeleteOriginalFiles();
            } else if ("-S".equals(string) || "--suffix".equals(string)) {
                bZip2CommandLineArguments.setCompressedFileSuffix(this.getArg(stringArray, n++, "Missing compressed file suffix"));
            } else if ("--fast".equals(string) || "-1".equals(string)) {
                bZip2CommandLineArguments.setBlockSize(1);
            } else if ("-2".equals(string)) {
                bZip2CommandLineArguments.setBlockSize(2);
            } else if ("-3".equals(string)) {
                bZip2CommandLineArguments.setBlockSize(3);
            } else if ("-4".equals(string)) {
                bZip2CommandLineArguments.setBlockSize(4);
            } else if ("-5".equals(string)) {
                bZip2CommandLineArguments.setBlockSize(5);
            } else if ("-6".equals(string)) {
                bZip2CommandLineArguments.setBlockSize(6);
            } else if ("-7".equals(string)) {
                bZip2CommandLineArguments.setBlockSize(7);
            } else if ("-8".equals(string)) {
                bZip2CommandLineArguments.setBlockSize(8);
            } else if ("--best".equals(string) || "-9".equals(string)) {
                bZip2CommandLineArguments.setBlockSize(9);
            } else if ("--apache".equals(string)) {
                bZip2CommandLineArguments.setApache(true);
            } else if ("--encoderThreads".equals(string)) {
                bZip2CommandLineArguments.setNumberOfEncoderThreads(Integer.parseInt(this.getArg(stringArray, n++, "Missing compressed file suffix")));
            } else {
                throw new CommandErrorException("Unknown argument " + string);
            }
            string = this.getArg(stringArray, n++, "Missing files");
        }
        bZip2CommandLineArguments.addSource(new File(string));
        while (n < stringArray.length) {
            string = stringArray[n++];
            bZip2CommandLineArguments.addSource(new File(string));
        }
        return bZip2CommandLineArguments;
    }

    @Override
    String getTargetFileName(String string, BZip2CommandLineArguments bZip2CommandLineArguments) throws IgnoreFileException {
        if (bZip2CommandLineArguments.isDecompress()) {
            if (string.toLowerCase().endsWith(".bz2")) {
                return string.substring(0, string.length() - 4);
            }
            throw new IgnoreFileException(string + ": unknown suffix -- ignored");
        }
        return string + bZip2CommandLineArguments.getCompressedFileSuffix();
    }

    public static void main(String[] stringArray) {
        try {
            new BZip2().run(stringArray);
        }
        catch (CommandErrorException commandErrorException) {
            System.err.println(commandErrorException.getMessage());
            System.exit(1);
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            System.exit(1);
        }
        catch (WrappedIOException wrappedIOException) {
            System.err.println(wrappedIOException.getMessage());
            System.exit(1);
        }
    }
}

