/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.gzip.prog;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.at4j.comp.gzip.prog.AbstractGZipProgramArguments;
import org.at4j.comp.prog.AbstractStreamCompressionProgram;
import org.at4j.comp.prog.IgnoreFileException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractGZipProgram<T extends AbstractGZipProgramArguments>
extends AbstractStreamCompressionProgram<T> {
    AbstractGZipProgram() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected InputStream createInputStream(int n, T t) throws IOException {
        InputStream inputStream = null;
        boolean bl = false;
        try {
            inputStream = new FileInputStream(((AbstractGZipProgramArguments)t).getSources().get(n));
            inputStream = new BufferedInputStream(inputStream);
            if (((AbstractGZipProgramArguments)t).isDecompress()) {
                inputStream = new GZIPInputStream(inputStream);
            }
            bl = true;
            InputStream inputStream2 = inputStream;
            return inputStream2;
        }
        finally {
            if (!bl && inputStream != null) {
                inputStream.close();
            }
        }
    }

    abstract String getTargetFileName(String var1, T var2) throws IgnoreFileException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OutputStream createOutputStream(int n, T t) throws IOException, IgnoreFileException {
        OutputStream outputStream = null;
        boolean bl = false;
        try {
            Object object;
            if (((AbstractGZipProgramArguments)t).isCompressToStdout()) {
                outputStream = System.out;
            } else {
                object = ((AbstractGZipProgramArguments)t).getSources().get(n);
                File file = new File(((File)object).getParentFile(), this.getTargetFileName(((File)object).getName(), t));
                if (file.exists()) {
                    throw new IgnoreFileException(file + " already exists");
                }
                outputStream = new FileOutputStream(file);
                outputStream = new BufferedOutputStream(outputStream);
            }
            if (!((AbstractGZipProgramArguments)t).isDecompress()) {
                outputStream = new GZIPOutputStream(outputStream);
            }
            bl = true;
            object = outputStream;
            return object;
        }
        finally {
            if (!bl && outputStream != null) {
                ((OutputStream)outputStream).close();
            }
        }
    }

    @Override
    protected void postProcess(int n, T t) throws IOException {
        File file;
        if (!((AbstractGZipProgramArguments)t).isDontDeleteOriginalFiles() && !(file = ((AbstractGZipProgramArguments)t).getSources().get(n)).delete()) {
            throw new IOException("Could not delete " + file + ". No reason given");
        }
    }
}

