/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.gzip.prog;

import java.io.File;
import java.io.IOException;
import org.at4j.comp.gzip.prog.AbstractGZipProgram;
import org.at4j.comp.gzip.prog.GUnzipCommandLineArguments;
import org.at4j.comp.prog.IgnoreFileException;
import org.at4j.support.prog.CommandErrorException;
import org.entityfs.support.exception.WrappedIOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GUnzip
extends AbstractGZipProgram<GUnzipCommandLineArguments> {
    @Override
    protected GUnzipCommandLineArguments parseCommandLine(String[] stringArray) throws CommandErrorException {
        GUnzipCommandLineArguments gUnzipCommandLineArguments = new GUnzipCommandLineArguments();
        int n = 0;
        String string = this.getArg(stringArray, n++, "Missing files");
        while (this.isFlagArgument(string)) {
            if ("--threads".equals(string)) {
                int n2 = Integer.valueOf(this.getArg(stringArray, n++, "Missing number of threads"));
                gUnzipCommandLineArguments.setNumberOfThreads(n2);
            } else if ("--timing".equals(string)) {
                gUnzipCommandLineArguments.setTiming();
            } else if ("-c".equals(string)) {
                gUnzipCommandLineArguments.setCompressToStdout();
                gUnzipCommandLineArguments.setDontDeleteOriginalFiles();
            } else {
                throw new CommandErrorException("Unknown argument " + string);
            }
            string = this.getArg(stringArray, n++, "Missing files");
        }
        gUnzipCommandLineArguments.addSource(new File(string));
        while (n < stringArray.length) {
            string = stringArray[n++];
            gUnzipCommandLineArguments.addSource(new File(string));
        }
        return gUnzipCommandLineArguments;
    }

    @Override
    String getTargetFileName(String string, GUnzipCommandLineArguments gUnzipCommandLineArguments) throws IgnoreFileException {
        if (string.toLowerCase().endsWith(".gz")) {
            return string.substring(0, string.length() - 3);
        }
        throw new IgnoreFileException(string + ": unknown suffix -- ignored");
    }

    public static void main(String[] stringArray) {
        try {
            new GUnzip().run(stringArray);
        }
        catch (CommandErrorException commandErrorException) {
            System.err.println(commandErrorException.getMessage());
            System.exit(1);
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            System.exit(1);
        }
        catch (WrappedIOException wrappedIOException) {
            System.err.println(wrappedIOException.getMessage());
            System.exit(1);
        }
    }
}

