/*
 * Decompiled with CFR 0.152.
 */
package org.at4j.comp.gzip.prog;

import java.io.File;
import java.io.IOException;
import org.at4j.comp.gzip.prog.AbstractGZipProgram;
import org.at4j.comp.gzip.prog.GZipCommandLineArguments;
import org.at4j.comp.prog.IgnoreFileException;
import org.at4j.support.prog.CommandErrorException;
import org.entityfs.support.exception.WrappedIOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GZip
extends AbstractGZipProgram<GZipCommandLineArguments> {
    @Override
    protected GZipCommandLineArguments parseCommandLine(String[] stringArray) throws CommandErrorException {
        GZipCommandLineArguments gZipCommandLineArguments = new GZipCommandLineArguments();
        int n = 0;
        String string = this.getArg(stringArray, n++, "Missing files");
        while (this.isFlagArgument(string)) {
            if ("--threads".equals(string)) {
                int n2 = Integer.valueOf(this.getArg(stringArray, n++, "Missing number of threads"));
                gZipCommandLineArguments.setNumberOfThreads(n2);
            } else if ("--timing".equals(string)) {
                gZipCommandLineArguments.setTiming();
            } else if ("-c".equals(string)) {
                gZipCommandLineArguments.setCompressToStdout();
                gZipCommandLineArguments.setDontDeleteOriginalFiles();
            } else if ("-S".equals(string) || "--suffix".equals(string)) {
                gZipCommandLineArguments.setCompressedFileSuffix(this.getArg(stringArray, n++, "Missing compressed file suffix"));
            } else if ("-d".equals(string) || "--decompress".equals(string) || "--uncompress".equals(string)) {
                gZipCommandLineArguments.setDecompress();
            } else {
                throw new CommandErrorException("Unknown argument " + string);
            }
            string = this.getArg(stringArray, n++, "Missing files");
        }
        gZipCommandLineArguments.addSource(new File(string));
        while (n < stringArray.length) {
            string = stringArray[n++];
            gZipCommandLineArguments.addSource(new File(string));
        }
        return gZipCommandLineArguments;
    }

    @Override
    String getTargetFileName(String string, GZipCommandLineArguments gZipCommandLineArguments) throws IgnoreFileException {
        if (gZipCommandLineArguments.isDecompress()) {
            if (string.toLowerCase().endsWith(".gz")) {
                return string.substring(0, string.length() - 3);
            }
            throw new IgnoreFileException(string + ": unknown suffix -- ignored");
        }
        return string + gZipCommandLineArguments.getCompressedFileSuffix();
    }

    public static void main(String[] stringArray) {
        try {
            new GZip().run(stringArray);
        }
        catch (CommandErrorException commandErrorException) {
            System.err.println(commandErrorException.getMessage());
            System.exit(1);
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            System.exit(1);
        }
        catch (WrappedIOException wrappedIOException) {
            System.err.println(wrappedIOException.getMessage());
            System.exit(1);
        }
    }
}

